/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.IntegerDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class GeometricDistribution
extends IntegerDistribution {
    private RandomGenerator randGen;
    private double chance;

    public GeometricDistribution(ChiCoordinator chiCoordinator, double chance) {
        super(chiCoordinator);
        if (chance <= 0.0 || chance > 1.0) {
            String msg = Strings.fmt((String)"The Geometric distribution expects the chance parameter to be in the range (0.0..1.0], found value %s instead.", (Object[])new Object[]{chance});
            throw new ChiSimulatorException(msg);
        }
        this.chance = chance;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public int sample() {
        return this.drawGeometric(this.randGen, this.chance);
    }

    public int drawGeometric(RandomGenerator randGen, double chance) {
        double a = 1.0 / Math.log(1.0 - chance);
        return (int)(a * Math.log(randGen.drawNonzero()));
    }
}

