/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.RandomGenerator;
import org.eclipse.escet.common.java.Strings;

public class WeibullDistribution
extends DoubleDistribution {
    private RandomGenerator randGen;
    private double shape;
    private double scale;

    public WeibullDistribution(ChiCoordinator chiCoordinator, double shape, double scale) {
        super(chiCoordinator);
        if (shape <= 0.0) {
            String msg = Strings.fmt((String)"The Weibull distribution expects the shape parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{shape});
            throw new ChiSimulatorException(msg);
        }
        if (scale <= 0.0) {
            String msg = Strings.fmt((String)"The Weibull distribution expects the scale parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{scale});
            throw new ChiSimulatorException(msg);
        }
        this.shape = shape;
        this.scale = scale;
        this.randGen = chiCoordinator.getFreshGenerator();
    }

    @Override
    public double sample() {
        return WeibullDistribution.drawWeibull(this.randGen, this.shape, this.scale);
    }

    public static double drawWeibull(RandomGenerator randGen, double shape, double scale) {
        return scale * Math.pow(-Math.log(1.0 - randGen.draw()), 1.0 / shape);
    }
}

