/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.commands;

import java.util.function.Predicate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.Annotation;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.common.base.editor.AbstractBaseDiagramTypeProvider;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.ui.services.GraphitiUi;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.shared.Access;

public class RoomOpeningHelper {
    private static final String BEHAVIOR_DTP = "org.eclipse.etrice.ui.behavior.diagramTypeProvider";
    private static final String STRUCTURE_DTP = "org.eclipse.etrice.ui.structure.diagramTypeProvider";

    public static void openBehavior(EObject object) {
        if (object instanceof ActorClass) {
            ActorClass ac = (ActorClass)object;
            boolean hasManualBehavior = ac.getBehaviorAnnotations().stream().anyMatch(new Predicate<Annotation>(){

                @Override
                public boolean test(Annotation annotation) {
                    return annotation.getType() != null && "BehaviorManual".equals(annotation.getType().getName());
                }
            });
            if (hasManualBehavior) {
                RoomOpeningHelper.showInTextualEditor((EObject)ac);
            } else {
                RoomOpeningHelper.getBehaviorDiagramAccess().openDiagramEditor((EObject)ac);
            }
        }
    }

    public static void openStructure(EObject object) {
        if (object instanceof StructureClass) {
            RoomOpeningHelper.getStructureDiagramAccess().openDiagramEditor(object);
        }
    }

    public static void showInTextualEditor(EObject object) {
        URI uri;
        URI uRI = uri = object != null ? EcoreUtil.getURI((EObject)object) : null;
        if (uri != null) {
            ((IURIEditorOpener)Access.getIURIEditorOpener().get()).open(uri, true);
        }
    }

    public static DiagramAccessBase getBehaviorDiagramAccess() {
        return RoomOpeningHelper.getDiagramAccess(BEHAVIOR_DTP);
    }

    public static DiagramAccessBase getStructureDiagramAccess() {
        return RoomOpeningHelper.getDiagramAccess(STRUCTURE_DTP);
    }

    static DiagramAccessBase getDiagramAccess(String providerId) {
        IDiagramTypeProvider dtp = GraphitiUi.getExtensionManager().createDiagramTypeProvider(providerId);
        if (dtp instanceof AbstractBaseDiagramTypeProvider) {
            return ((AbstractBaseDiagramTypeProvider)dtp).getDiagramAccess();
        }
        return null;
    }
}

