/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.expressions.ui.highlight;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import org.eclipse.etrice.expressions.detailcode.IDetailExpressionProvider;
import org.eclipse.etrice.expressions.ui.highlight.AbstractHighlightStyles;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class ExpressionRuleFactory {
    protected static IWordDetector getIDWordDetector() {
        return new IWordDetector(){

            public boolean isWordStart(char c) {
                return Character.isLowerCase(c) || Character.isUpperCase(c) || c == '_';
            }

            public boolean isWordPart(char c) {
                return this.isWordStart(c) || Character.isDigit(c);
            }
        };
    }

    public static List<IRule> getInitialExpressionRules(IDetailExpressionProvider exprProvider, AbstractHighlightStyles highlightStyle) {
        WordRule wordRule = new WordRule(ExpressionRuleFactory.getIDWordDetector());
        HashSet<String> ids = new HashSet<String>();
        for (IDetailExpressionProvider.ExpressionFeature feature : exprProvider.getInitialFeatures()) {
            if (!ids.add(feature.getId())) continue;
            wordRule.addWord(feature.getId(), (IToken)new Token(highlightStyle.getStyle(feature)));
        }
        return Lists.newArrayList((Object[])new IRule[]{wordRule});
    }
}

