/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import com.google.gson.Gson;
import java.util.Collection;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.glsp.ide.editor.ui.GLSPDiagramEditor;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.ui.keys.IBindingService;

public class ChromiumKeyBindingFunction {
    private static final Logger LOGGER = Logger.getLogger(ChromiumKeyBindingFunction.class);
    private static final String FUNCTION_NAME = "$notifyKeybinding";
    private static final String FUNCTION_CALL = "if(event.ctrlKey || event.shiftKey || event.altKey) { $notifyKeybinding(JSON.stringify({    altKey: event.altKey,     ctrlKey: event.ctrlKey,     shiftKey: event.shiftKey,     metaKey: event.metaKey,     repeat: event.repeat,     key: event.key,     code: event.code }));}";
    private static final String INSTALL_FUNCTION = "document.addEventListener('keydown', (event) => { if(event.ctrlKey || event.shiftKey || event.altKey) { $notifyKeybinding(JSON.stringify({    altKey: event.altKey,     ctrlKey: event.ctrlKey,     shiftKey: event.shiftKey,     metaKey: event.metaKey,     repeat: event.repeat,     key: event.key,     code: event.code }));} });";
    private final BrowserFunction browserFunction;

    public ChromiumKeyBindingFunction(final GLSPDiagramEditor editor, Browser browser) {
        this.browserFunction = new BrowserFunction(browser, FUNCTION_NAME){

            public Object function(Object[] arguments) {
                IBindingService bindingService;
                SerializableEvent event;
                Optional<KeySequence> keySequence;
                if (arguments.length == 1 && arguments[0] instanceof String && (keySequence = ChromiumKeyBindingFunction.this.getKeySequence(event = (SerializableEvent)new Gson().fromJson((String)arguments[0], SerializableEvent.class))).isPresent() && (bindingService = (IBindingService)editor.getSite().getService(IBindingService.class)) != null) {
                    ChromiumKeyBindingFunction.this.executeKeySequence(bindingService, keySequence.get());
                }
                return null;
            }
        };
    }

    protected void executeKeySequence(IBindingService bindingService, KeySequence keySequence) {
        this.findMatchingBinding(bindingService, keySequence).ifPresent(this::executeBinding);
    }

    protected Optional<Binding> findMatchingBinding(IBindingService bindingService, KeySequence keySequence) {
        Collection partialMatches;
        Binding perfectMatch = bindingService.getPerfectMatch((TriggerSequence)keySequence);
        if (perfectMatch == null && (partialMatches = bindingService.getConflictsFor((TriggerSequence)keySequence)) != null) {
            for (Binding binding : partialMatches) {
                if (!binding.getParameterizedCommand().getCommand().isEnabled()) continue;
                return Optional.of(binding);
            }
        }
        return Optional.ofNullable(perfectMatch);
    }

    protected void executeBinding(Binding binding) {
        if (binding != null && binding.getParameterizedCommand().getCommand().isEnabled()) {
            try {
                binding.getParameterizedCommand().executeWithChecks(null, null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException exception) {
                LOGGER.error((Object)exception);
            }
        }
    }

    protected Optional<KeySequence> getKeySequence(SerializableEvent event) {
        String keyString = event.getKey().toUpperCase();
        if (event.isCtrlKey()) {
            keyString = "CTRL+" + keyString;
        }
        if (event.isAltKey()) {
            keyString = "ALT+" + keyString;
        }
        if (event.isShiftKey()) {
            keyString = "SHIFT+" + keyString;
        }
        try {
            KeyStroke stroke = KeyStroke.getInstance((String)keyString);
            return Optional.ofNullable(KeySequence.getInstance((KeyStroke)stroke));
        }
        catch (IllegalArgumentException | ParseException exception) {
            return Optional.empty();
        }
    }

    public BrowserFunction getBrowserFunction() {
        return this.browserFunction;
    }

    public static Optional<BrowserFunction> install(GLSPDiagramEditor editor, Browser browser) {
        if ((browser.getStyle() & 0x20000) == 0 && (browser.getStyle() & 0x40000) == 0) {
            return Optional.empty();
        }
        ChromiumKeyBindingFunction function = new ChromiumKeyBindingFunction(editor, browser);
        browser.execute(INSTALL_FUNCTION);
        return Optional.of(function.getBrowserFunction());
    }

    private static class SerializableEvent {
        private static final String JAVASCRIPT_CONSTRUCTOR_FOR_EVENT = "{    altKey: event.altKey,     ctrlKey: event.ctrlKey,     shiftKey: event.shiftKey,     metaKey: event.metaKey,     repeat: event.repeat,     key: event.key,     code: event.code }";
        private boolean altKey;
        private boolean ctrlKey;
        private boolean shiftKey;
        private boolean metaKey;
        private boolean repeat;
        private String code;
        private String key;

        private SerializableEvent() {
        }

        public boolean isAltKey() {
            return this.altKey;
        }

        public boolean isCtrlKey() {
            return this.ctrlKey;
        }

        public boolean isShiftKey() {
            return this.shiftKey;
        }

        public boolean isMetaKey() {
            return this.metaKey;
        }

        public boolean isRepeat() {
            return this.repeat;
        }

        public String getCode() {
            return this.code;
        }

        public String getKey() {
            return this.key;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("SerializableEvent [isAltKey()=").append(this.isAltKey()).append(", isCtrlKey()=").append(this.isCtrlKey()).append(", isShiftKey()=").append(this.isShiftKey()).append(", isMetaKey()=").append(this.isMetaKey()).append(", isRepeat()=").append(this.isRepeat()).append(", getCode()=").append(this.getCode()).append(", getKey()=").append(this.getKey()).append("]");
            return builder.toString();
        }
    }
}

