/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.ui;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.glsp.ide.editor.utils.UIUtil;
import org.eclipse.glsp.server.actions.ServerStatusAction;
import org.eclipse.glsp.server.types.Severity;
import org.eclipse.glsp.server.utils.ServerStatusUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class GSLPDiagramEditorStatusBar
extends Composite {
    private static final ISharedImages SHARED_IMAGES = PlatformUI.getWorkbench().getSharedImages();
    private final Label statusBarIcon;
    private final Label statusBarMessage;
    private ServerStatusAction currentStatus;
    private final Timer statusTimer = new Timer();

    public GSLPDiagramEditorStatusBar(Composite parent) {
        super(parent, 16);
        GridData gridData = new GridData();
        gridData.exclude = true;
        this.setLayoutData(gridData);
        this.statusBarIcon = new Label((Composite)this, 0);
        this.statusBarIcon.setImage(SHARED_IMAGES.getImage("IMG_OBJS_INFO_TSK"));
        this.statusBarMessage = new Label((Composite)this, 0);
        this.statusBarMessage.setText("");
    }

    public synchronized void showServerStatus(ServerStatusAction serverStatus) {
        this.currentStatus = serverStatus;
        UIUtil.asyncExec(() -> this.updateStatusBar(serverStatus));
        if (serverStatus.getTimeout() > 0) {
            int timeout = serverStatus.getTimeout();
            this.statusTimer.schedule((TimerTask)new ClearStatusBarTask(serverStatus), timeout);
        }
    }

    protected synchronized void updateStatusBar(ServerStatusAction status) {
        Severity severity = Severity.valueOf((String)status.getSeverity());
        Image image = this.toImage(severity);
        String message = status.getMessage();
        if (image != null && message != null && !message.isEmpty()) {
            this.statusBarIcon.setImage(image);
            this.statusBarMessage.setText(message);
            this.setVisible(true);
            ((GridData)this.getLayoutData()).exclude = false;
        } else {
            this.statusBarIcon.setImage(null);
            this.statusBarMessage.setText("");
            this.setVisible(false);
            ((GridData)this.getLayoutData()).exclude = true;
        }
        this.getParent().layout(true, true);
    }

    private Image toImage(Severity severity) {
        switch (severity) {
            case FATAL: 
            case ERROR: {
                return SHARED_IMAGES.getImage("IMG_OBJS_ERROR_TSK");
            }
            case WARNING: {
                return SHARED_IMAGES.getImage("IMG_OBJS_WARN_TSK");
            }
            case INFO: 
            case OK: {
                return SHARED_IMAGES.getImage("IMG_OBJS_INFO_TSK");
            }
        }
        return null;
    }

    private class ClearStatusBarTask
    extends TimerTask {
        private final ServerStatusAction startStatus;

        ClearStatusBarTask(ServerStatusAction startStatus) {
            this.startStatus = startStatus;
        }

        @Override
        public void run() {
            if (GSLPDiagramEditorStatusBar.this.currentStatus == this.startStatus) {
                UIUtil.asyncExec(() -> GSLPDiagramEditorStatusBar.this.updateStatusBar(ServerStatusUtil.clear()));
            }
        }
    }
}

