/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.builder.GBuilder;

public abstract class GModelElementBuilder<T extends GModelElement, E extends GModelElementBuilder<T, E>>
extends GBuilder<T> {
    protected String type;
    protected String id;
    protected String trace;
    protected List<String> cssClasses = new ArrayList<String>();
    protected List<GModelElement> children = new ArrayList<GModelElement>();

    public GModelElementBuilder(String type) {
        this.type = type;
    }

    public E id(String id) {
        this.id = id;
        return this.self();
    }

    public E type(String type) {
        this.type = type;
        return this.self();
    }

    public E trace(String trace) {
        this.trace = trace;
        return this.self();
    }

    public E addCssClass(String cssClass) {
        this.cssClasses.add(cssClass);
        return this.self();
    }

    public E addCssClasses(List<String> cssClasses) {
        this.cssClasses.addAll(cssClasses);
        return this.self();
    }

    public E add(GModelElement child) {
        this.children.add(child);
        return this.self();
    }

    public E addAll(List<GModelElement> children) {
        this.children.addAll(children);
        return this.self();
    }

    @Override
    protected abstract T instantiate();

    protected T generateId(T element) {
        element.setId(UUID.randomUUID().toString());
        return element;
    }

    protected abstract E self();

    @Override
    protected void setProperties(T element) {
        if (this.id == null) {
            this.generateId(element);
        } else {
            element.setId(this.id);
        }
        element.setType(this.type);
        element.setTrace(this.trace);
        if (this.cssClasses != null) {
            element.getCssClasses().addAll(this.cssClasses);
        }
        if (this.children != null) {
            element.getChildren().addAll(this.children);
        }
    }

    @Override
    public T build() {
        Object element = this.instantiate();
        this.setProperties((T)element);
        return (T)element;
    }
}

