/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.jsonrpc;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.inject.Inject;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.glsp.server.actions.ActionDispatcher;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.jsonrpc.GLSPJsonrpcClient;
import org.eclipse.glsp.server.jsonrpc.GLSPJsonrpcServer;
import org.eclipse.glsp.server.model.ModelStateProvider;
import org.eclipse.glsp.server.protocol.ClientSessionManager;
import org.eclipse.glsp.server.protocol.GLSPServerException;
import org.eclipse.glsp.server.protocol.InitializeParameters;
import org.eclipse.glsp.server.utils.ServerMessageUtil;

public class DefaultGLSPServer<T>
implements GLSPJsonrpcServer {
    private static Logger log = Logger.getLogger(DefaultGLSPServer.class);
    @Inject
    protected ModelStateProvider modelStateProvider;
    @Inject
    protected ClientSessionManager sessionManager;
    @Inject
    protected ActionDispatcher actionDispatcher;
    protected GLSPJsonrpcClient clientProxy;
    protected final Class<T> optionsClazz;
    protected CompletableFuture<Boolean> initialized;
    protected String applicationId;

    public DefaultGLSPServer() {
        this(null);
    }

    public DefaultGLSPServer(Class<T> optionsClazz) {
        this.optionsClazz = optionsClazz;
        this.initialized = new CompletableFuture();
    }

    @Override
    public CompletableFuture<Boolean> initialize(InitializeParameters params) {
        try {
            this.applicationId = params.getApplicationId();
            if (this.optionsClazz != null && params.getOptions() instanceof JsonElement) {
                Object options = new Gson().fromJson((JsonElement)params.getOptions(), this.optionsClazz);
                this.initialized = this.handleOptions(options);
            } else {
                this.initialized = this.handleOptions(null);
            }
            return this.initialized;
        }
        catch (Throwable ex) {
            log.error((Object)("Could not initialize server due to corrupted options: " + params.getOptions()), ex);
            this.initialized.complete(false);
            return this.initialized;
        }
    }

    protected CompletableFuture<Boolean> handleOptions(T options) {
        return CompletableFuture.completedFuture(true);
    }

    @Override
    public void connect(GLSPJsonrpcClient clientProxy) {
        this.clientProxy = clientProxy;
        if (clientProxy != null) {
            this.sessionManager.connectClient(clientProxy);
        }
    }

    @Override
    public void process(ActionMessage message) {
        log.debug((Object)("process " + message));
        String clientId = message.getClientId();
        Function<Throwable, Void> errorHandler = ex -> {
            String errorMsg = "Could not process message:" + message;
            log.error((Object)("[ERROR] " + errorMsg), ex);
            this.getClient().process(new ActionMessage(clientId, ServerMessageUtil.error("[GLSP-Server] " + errorMsg, ex)));
            return null;
        };
        try {
            if (!this.isInitialized()) {
                throw new GLSPServerException(String.format("Could not process action message '%s'. The server has not been initalized yet", message));
            }
            this.actionDispatcher.dispatch(message).exceptionally((Function)errorHandler);
        }
        catch (RuntimeException e) {
            errorHandler.apply(e);
        }
    }

    public boolean isInitialized() {
        return this.initialized.getNow(false);
    }

    @Override
    public CompletableFuture<Boolean> shutdown() {
        boolean completed = false;
        if (this.clientProxy != null) {
            completed = this.sessionManager.disconnectClient(this.clientProxy);
            this.clientProxy = null;
        }
        return CompletableFuture.completedFuture(completed);
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public GLSPJsonrpcClient getClient() {
        return this.clientProxy;
    }
}

