/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.diagram;

import com.google.inject.Inject;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.glsp.graph.gson.GraphGsonConfigurator;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionHandler;
import org.eclipse.glsp.server.actions.ActionRegistry;
import org.eclipse.glsp.server.di.DiagramType;
import org.eclipse.glsp.server.diagram.ServerConfigurationContribution;
import org.eclipse.glsp.server.gson.GraphGsonConfigurationFactory;
import org.eclipse.glsp.server.internal.util.ReflectionUtil;
import org.eclipse.glsp.server.operations.Operation;
import org.eclipse.glsp.server.operations.OperationHandler;

public class DefaultServerConfigurationContribution
implements ServerConfigurationContribution {
    @Inject
    @DiagramType
    protected String diagramType;
    @Inject
    protected GraphGsonConfigurationFactory graphGsonConfigurationFactory;
    @Inject
    protected Set<ActionHandler> actionHandlers;
    @Inject
    protected Set<OperationHandler<?>> operationHandlers;

    @Override
    public void configure(ActionRegistry registry) {
        Stream<Action> handledActions = ReflectionUtil.construct(this.actionHandlers.stream().flatMap(h -> h.getHandledActionTypes().stream()));
        Stream<Operation> handledOperations = ReflectionUtil.construct(this.operationHandlers.stream().map(OperationHandler::getHandledOperationType));
        handledActions.forEach(action -> {
            boolean bl = registry.register(this.diagramType, action.getKind(), action.getClass());
        });
        handledOperations.forEach(operation -> {
            boolean bl = registry.register(this.diagramType, operation.getKind(), operation.getClass());
        });
    }

    @Override
    public void configure(GraphGsonConfigurator gsonConfigurator) {
        this.graphGsonConfigurationFactory.configure(gsonConfigurator);
    }
}

