/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.Set;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.actions.ResponseAction;
import org.eclipse.glsp.server.di.ClientId;
import org.eclipse.glsp.server.protocol.GLSPClient;

@Singleton
public class ClientActionForwarder {
    @Inject
    protected Provider<GLSPClient> client;
    @Inject
    @ClientId
    protected String clientId;
    @Inject
    @Named(value="ClientActions")
    protected Set<String> clientActionKinds;

    public boolean handle(Action action) {
        if (this.shouldForwardToClient(action)) {
            ActionMessage message = new ActionMessage(this.clientId, action);
            ((GLSPClient)this.client.get()).process(message);
            return true;
        }
        return false;
    }

    protected boolean shouldForwardToClient(Action action) {
        if (action.isReceivedFromClient()) {
            return false;
        }
        return this.clientActionKinds.contains(action.getKind()) || action instanceof ResponseAction;
    }
}

