/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.typehints;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.diagram.DiagramConfiguration;
import org.eclipse.glsp.server.features.typehints.CheckEdgeResultAction;
import org.eclipse.glsp.server.features.typehints.EdgeCreationChecker;
import org.eclipse.glsp.server.features.typehints.RequestCheckEdgeAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.GLSPServerException;

public class RequestCheckEdgeActionHandler
extends AbstractActionHandler<RequestCheckEdgeAction> {
    @Inject
    protected Optional<EdgeCreationChecker> edgeCreationChecker;
    @Inject
    protected DiagramConfiguration diagramConfiguration;
    @Inject
    protected GModelState modelState;

    @Override
    protected List<Action> executeAction(RequestCheckEdgeAction action) {
        boolean hasDynamicHint = this.diagramConfiguration.getEdgeTypeHints().stream().filter(hint -> hint.getElementTypeId().equals(action.getEdgeType()) && hint.isDynamic()).findAny().isPresent();
        if (!this.edgeCreationChecker.isPresent() || !hasDynamicHint) {
            return this.listOf(new CheckEdgeResultAction(true, action));
        }
        return this.listOf(new CheckEdgeResultAction(this.validate(action), action));
    }

    protected boolean validate(RequestCheckEdgeAction action) {
        GModelElement sourceElement = (GModelElement)GLSPServerException.getOrThrow(this.modelState.getIndex().get(action.getSourceElementId()), "Invalid `RequestCheckEdgeTargetAction`!. Could not find a source elemment with id: " + action.getSourceElementId());
        Optional targetElement = action.getTargetElementId().flatMap(targetId -> this.modelState.getIndex().get(targetId));
        if (action.getTargetElementId().isPresent() && targetElement.isEmpty()) {
            throw new GLSPServerException("Invalid `RequestCheckEdgeTargetAction`! Could not find a target element with id: " + action.getTargetElementId().get());
        }
        return targetElement.isPresent() ? this.edgeCreationChecker.get().isValidTarget(action.getEdgeType(), sourceElement, (GModelElement)targetElement.get()) : this.edgeCreationChecker.get().isValidSource(action.getEdgeType(), sourceElement);
    }
}

