/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.glsp.graph.GAlignable;
import org.eclipse.glsp.graph.GBounds;
import org.eclipse.glsp.graph.GBoundsAware;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GGraph;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.GraphFactory;
import org.eclipse.glsp.graph.builder.impl.GArguments;
import org.eclipse.glsp.graph.util.GraphUtil;
import org.eclipse.glsp.server.features.core.model.ComputedBoundsAction;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.types.ElementAndAlignment;
import org.eclipse.glsp.server.types.ElementAndBounds;
import org.eclipse.glsp.server.types.ElementAndRoutingPoints;
import org.eclipse.glsp.server.types.GLSPServerException;
import org.eclipse.glsp.server.utils.GeometryUtil;

public final class LayoutUtil {
    private LayoutUtil() {
    }

    public static void applyBounds(GModelRoot root, ComputedBoundsAction action, GModelState modelState) {
        GModelIndex index = modelState.getIndex();
        action.getBounds().forEach(bounds -> {
            Optional<GBoundsAware> optional = LayoutUtil.applyBounds(bounds, index);
        });
        action.getAlignments().forEach(alignment -> {
            Optional<GAlignable> optional = LayoutUtil.applyAlignment(alignment, index);
        });
        action.getRoutes().forEach(route -> {
            GEdge gEdge = LayoutUtil.applyRoute(route, index);
        });
    }

    public static Optional<GBoundsAware> applyBounds(ElementAndBounds bounds, GModelIndex index) {
        GModelElement element = (GModelElement)GLSPServerException.getOrThrow(index.get(bounds.getElementId()), "Model element not found! ID: " + bounds.getElementId());
        if (element instanceof GBoundsAware) {
            GBoundsAware bae = (GBoundsAware)element;
            if (bounds.getNewPosition() != null) {
                bae.setPosition(GraphUtil.copy((GPoint)bounds.getNewPosition()));
            }
            if (bounds.getNewSize() != null) {
                bae.setSize(GraphUtil.copy((GDimension)bounds.getNewSize()));
            }
            return Optional.of(bae);
        }
        return Optional.empty();
    }

    public static Optional<GAlignable> applyAlignment(ElementAndAlignment alignment, GModelIndex index) {
        GModelElement element = (GModelElement)GLSPServerException.getOrThrow(index.get(alignment.getElementId()), "Model element not found! ID: " + alignment.getElementId());
        if (element instanceof GAlignable) {
            GAlignable alignable = (GAlignable)element;
            alignable.setAlignment(alignment.getNewAlignment());
            return Optional.of(alignable);
        }
        return Optional.empty();
    }

    public static GEdge applyRoute(ElementAndRoutingPoints route, GModelIndex index) {
        List<GPoint> routingPoints = route.getNewRoutingPoints();
        if (routingPoints.size() < 2) {
            throw new GLSPServerException("Invalid Route!");
        }
        GEdge edge = LayoutUtil.applyRoutingPoints(route, index);
        EList edgeRoutingPoints = edge.getRoutingPoints();
        edge.getArgs().put((Object)"edgeSourcePoint", edgeRoutingPoints.remove(0));
        edge.getArgs().put((Object)"edgeTargetPoint", edgeRoutingPoints.remove(edgeRoutingPoints.size() - 1));
        return edge;
    }

    public static ElementAndRoutingPoints getRoute(GEdge edge) {
        Optional sourcePoint = GArguments.getEdgeSourcePoint((EMap)edge.getArgs());
        if (sourcePoint.isEmpty()) {
            throw new GLSPServerException("Cannot get route without source point!");
        }
        Optional targetPoint = GArguments.getEdgeTargetPoint((EMap)edge.getArgs());
        if (targetPoint.isEmpty()) {
            throw new GLSPServerException("Cannot get route without target point!");
        }
        ArrayList<GPoint> route = new ArrayList<GPoint>(EcoreUtil.copyAll((Collection)edge.getRoutingPoints()));
        route.add(0, (GPoint)sourcePoint.get());
        route.add((GPoint)targetPoint.get());
        return new ElementAndRoutingPoints(edge.getId(), route);
    }

    public static GEdge applyRoutingPoints(ElementAndRoutingPoints routingPoints, GModelIndex index) {
        GEdge edge = (GEdge)GLSPServerException.getOrThrow(index.findElementByClass(routingPoints.getElementId(), GEdge.class), "Model element not found! ID: " + routingPoints.getElementId());
        EList edgeRoutingPoints = edge.getRoutingPoints();
        edgeRoutingPoints.clear();
        edgeRoutingPoints.addAll(routingPoints.getNewRoutingPoints());
        return edge;
    }

    public static GPoint getRelativeLocation(GPoint absoluteLocation, GModelElement container) {
        boolean allowNegativeCoordinates = container instanceof GGraph;
        GModelElement modelElement = container;
        if (modelElement instanceof GBoundsAware) {
            try {
                GPoint relativePosition = GeometryUtil.absoluteToRelative(absoluteLocation, (GBoundsAware)modelElement);
                GPoint relativeLocation = allowNegativeCoordinates ? relativePosition : GraphUtil.point((double)Math.max(0.0, relativePosition.getX()), (double)Math.max(0.0, relativePosition.getY()));
                return relativeLocation;
            }
            catch (IllegalArgumentException ex) {
                return absoluteLocation;
            }
        }
        return null;
    }

    public static GPoint asPoint(GBounds bounds) {
        GPoint point = GraphFactory.eINSTANCE.createGPoint();
        point.setX(bounds.getX());
        point.setY(bounds.getY());
        return point;
    }

    public static GDimension asDimension(GBounds bounds) {
        GDimension dimension = GraphFactory.eINSTANCE.createGDimension();
        dimension.setHeight(bounds.getHeight());
        dimension.setWidth(bounds.getWidth());
        return dimension;
    }

    public static void copyLayoutData(GModelRoot fromRoot, GModelRoot toRoot) {
        GModelIndex oldIndex = GModelIndex.get((GModelElement)fromRoot);
        LayoutUtil.copyLayoutDataRecursively((GModelElement)toRoot, oldIndex);
    }

    private static void copyLayoutDataRecursively(GModelElement element, GModelIndex oldIndex) {
        Optional oldElement;
        if (element instanceof GBoundsAware) {
            oldElement = oldIndex.get(element.getId());
            if (oldElement.isPresent() && oldElement.get() instanceof GBoundsAware) {
                GBoundsAware newBae = (GBoundsAware)element;
                GBoundsAware oldBae = (GBoundsAware)oldElement.get();
                if (oldBae.getPosition() != null) {
                    newBae.setPosition((GPoint)EcoreUtil.copy((EObject)oldBae.getPosition()));
                }
                if (oldBae.getSize() != null) {
                    newBae.setSize((GDimension)EcoreUtil.copy((EObject)oldBae.getSize()));
                }
            }
        } else if (element instanceof GEdge && (oldElement = oldIndex.get(element.getId())).isPresent() && oldElement.get() instanceof GEdge && ((GEdge)oldElement.get()).getRoutingPoints() != null) {
            GEdge gEdge = (GEdge)element;
            gEdge.getRoutingPoints().clear();
            gEdge.getRoutingPoints().addAll(EcoreUtil.copyAll((Collection)((GEdge)oldElement.get()).getRoutingPoints()));
        }
        if (element.getChildren() != null) {
            for (GModelElement child : element.getChildren()) {
                LayoutUtil.copyLayoutDataRecursively(child, oldIndex);
            }
        }
    }
}

