/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jkube.generator.api.GeneratorContext;
import org.eclipse.jkube.generator.api.support.BaseGenerator;
import org.eclipse.jkube.generator.webapp.AppServerDetector;
import org.eclipse.jkube.generator.webapp.AppServerHandler;
import org.eclipse.jkube.generator.webapp.handler.CustomAppServerHandler;
import org.eclipse.jkube.kit.build.core.config.JKubeAssemblyConfiguration;
import org.eclipse.jkube.kit.build.core.config.JKubeBuildConfiguration;
import org.eclipse.jkube.kit.build.service.docker.ImageConfiguration;
import org.eclipse.jkube.kit.common.Configs;
import org.eclipse.jkube.kit.common.JKubeProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;
import org.eclipse.jkube.kit.config.image.build.Arguments;
import org.eclipse.jkube.kit.config.image.build.AssemblyConfiguration;
import org.eclipse.jkube.kit.config.image.build.BuildConfiguration;
import org.eclipse.jkube.kit.config.image.build.OpenShiftBuildStrategy;
import org.eclipse.jkube.kit.config.resource.RuntimeMode;

public class WebAppGenerator
extends BaseGenerator {
    public WebAppGenerator(GeneratorContext context) {
        super(context, "webapp");
    }

    public boolean isApplicable(List<ImageConfiguration> configs) {
        return this.shouldAddImageConfiguration(configs) && JKubeProjectUtil.hasPlugin((JKubeProject)this.getProject(), (String)"org.apache.maven.plugins", (String)"maven-war-plugin");
    }

    public List<ImageConfiguration> customize(List<ImageConfiguration> configs, boolean prePackagePhase) {
        if (this.getContext().getRuntimeMode() == RuntimeMode.openshift && this.getContext().getStrategy() == OpenShiftBuildStrategy.s2i && !prePackagePhase) {
            throw new IllegalArgumentException("S2I not yet supported for the webapp-generator. Use -Djkube.mode=kubernetes or -Djkube.build.strategy=docker for OpenShift mode. Please refer to the reference manual at https://maven.jkube.io for details about build modes.");
        }
        AppServerHandler handler = this.getAppServerHandler(this.getContext());
        this.log.info("Using %s as base image for webapp", new Object[]{handler.getFrom()});
        ImageConfiguration.Builder imageBuilder = new ImageConfiguration.Builder();
        JKubeBuildConfiguration.Builder buildBuilder = new JKubeBuildConfiguration.Builder();
        buildBuilder.from(this.getFrom(handler)).ports(handler.exposedPorts()).cmd(new Arguments(this.getDockerRunCommand(handler))).env(this.getEnv(handler));
        this.addSchemaLabels((BuildConfiguration.TypedBuilder)buildBuilder, this.log);
        if (!prePackagePhase) {
            buildBuilder.assembly((AssemblyConfiguration)this.createAssembly(handler));
        }
        this.addLatestTagIfSnapshot((BuildConfiguration.TypedBuilder)buildBuilder);
        imageBuilder.name(this.getImageName()).alias(this.getAlias()).buildConfig((JKubeBuildConfiguration)buildBuilder.build());
        configs.add(imageBuilder.build());
        return configs;
    }

    private AppServerHandler getAppServerHandler(GeneratorContext context) {
        String from = super.getFromAsConfigured();
        if (from != null) {
            return this.createCustomAppServerHandler(from);
        }
        return new AppServerDetector(context.getProject()).detect(this.getConfig(Config.server));
    }

    private AppServerHandler createCustomAppServerHandler(String from) {
        String user = this.getConfig(Config.user);
        String deploymentDir = this.getConfig(Config.targetDir, "/deployments");
        String command = this.getConfig(Config.cmd);
        List<String> ports = Arrays.asList(this.getConfig(Config.ports, "8080").split("\\s*,\\s*"));
        return new CustomAppServerHandler(from, deploymentDir, command, user, ports);
    }

    protected Map<String, String> getEnv(AppServerHandler handler) {
        HashMap<String, String> defaultEnv = new HashMap<String, String>();
        defaultEnv.put("DEPLOY_DIR", this.getDeploymentDir(handler));
        return defaultEnv;
    }

    private JKubeAssemblyConfiguration createAssembly(AppServerHandler handler) {
        String path = this.getConfig(Config.path);
        if (path.equals("/")) {
            path = "ROOT";
        }
        this.getProject().getProperties().setProperty("jkube.generator.webapp.path", path);
        JKubeAssemblyConfiguration.Builder builder = new JKubeAssemblyConfiguration.Builder();
        builder.targetDir(this.getDeploymentDir(handler)).descriptorRef("webapp");
        String user = this.getUser(handler);
        if (user != null) {
            builder.user(user);
        }
        return (JKubeAssemblyConfiguration)builder.build();
    }

    protected String getFrom(AppServerHandler handler) {
        return handler.getFrom();
    }

    private String getDockerRunCommand(AppServerHandler handler) {
        String cmd = this.getConfig(Config.cmd);
        return cmd != null ? cmd : handler.getCommand();
    }

    private String getDeploymentDir(AppServerHandler handler) {
        String deploymentDir = this.getConfig(Config.targetDir);
        return deploymentDir != null ? deploymentDir : handler.getDeploymentDir();
    }

    private String getUser(AppServerHandler handler) {
        String user = this.getConfig(Config.user);
        return user != null ? user : handler.getUser();
    }

    private static enum Config implements Configs.Key
    {
        server,
        targetDir,
        user,
        cmd,
        path{
            {
                this.d = "/";
            }
        }
        ,
        ports;

        protected String d;

        public String def() {
            return this.d;
        }
    }
}

