/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp.handler;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.eclipse.jkube.generator.api.DefaultImageLookup;
import org.eclipse.jkube.generator.webapp.AppServerHandler;
import org.eclipse.jkube.kit.common.JKubeProject;

public abstract class AbstractAppServerHandler
implements AppServerHandler {
    protected final DefaultImageLookup imageLookup;
    protected final JKubeProject project;
    private final String name;

    protected AbstractAppServerHandler(String name, JKubeProject project) {
        this.project = project;
        this.name = name;
        this.imageLookup = new DefaultImageLookup(this.getClass());
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected String[] scanFiles(String ... patterns) throws IOException {
        String buildOutputDir = this.project.getBuildDirectory();
        if (buildOutputDir != null && new File(buildOutputDir).exists()) {
            try (Stream<Path> fileStream = Files.walk(new File(buildOutputDir).toPath(), new FileVisitOption[0]);){
                String[] stringArray = (String[])fileStream.filter(path -> {
                    for (String pattern : patterns) {
                        pattern = pattern.substring(pattern.lastIndexOf(42) + 1);
                        if (!path.toUri().toString().contains(pattern)) continue;
                        return true;
                    }
                    return false;
                }).map(Path::toUri).map(URI::toString).toArray(String[]::new);
                return stringArray;
            }
        }
        return new String[0];
    }

    protected boolean hasOneOf(String ... patterns) throws IOException {
        return this.scanFiles(patterns).length > 0;
    }
}

