/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.generator.webapp.handler;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jkube.generator.webapp.handler.AbstractAppServerHandler;
import org.eclipse.jkube.kit.common.JKubeProject;
import org.eclipse.jkube.kit.common.util.JKubeProjectUtil;

public class TomcatAppSeverHandler
extends AbstractAppServerHandler {
    private static final String TOMCAT_GROUPID = "org.apache.tomcat.maven";

    public TomcatAppSeverHandler(JKubeProject project) {
        super("tomcat", project);
    }

    @Override
    public boolean isApplicable() {
        try {
            return this.hasOneOf("**/META-INF/context.xml") || JKubeProjectUtil.hasPlugin((JKubeProject)this.project, (String)TOMCAT_GROUPID, (String)"tomcat6-maven-plugin") || JKubeProjectUtil.hasPlugin((JKubeProject)this.project, (String)TOMCAT_GROUPID, (String)"tomcat7-maven-plugin");
        }
        catch (IOException exception) {
            throw new IllegalStateException("Unable to scan output directory: ", exception);
        }
    }

    @Override
    public String getFrom() {
        return this.imageLookup.getImageName("tomcat.upstream.docker");
    }

    @Override
    public List<String> exposedPorts() {
        return Arrays.asList("8080", "8778");
    }

    @Override
    public String getDeploymentDir() {
        return "/deployments";
    }

    @Override
    public String getCommand() {
        return "/opt/tomcat/bin/deploy-and-run.sh";
    }

    @Override
    public String getUser() {
        return "jboss:jboss:jboss";
    }
}

