/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.alm.mylyn.ui.handler;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.alm.mylyn.core.bp.CommentReporter;
import org.eclipse.jubula.client.alm.mylyn.ui.handler.AbstractALMReportHandler;
import org.eclipse.jubula.client.alm.mylyn.ui.i18n.Messages;
import org.eclipse.jubula.client.core.model.IALMReportingProperties;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.editors.TestResultViewer;

public class ReportToAlmHandler
extends AbstractALMReportHandler {
    protected Object executeImpl(ExecutionEvent event) {
        final List<ITestResultSummaryPO> summaries = this.getPendingSummaries();
        final int sumCount = summaries.size();
        if (sumCount > 0) {
            Job reportToALMOperation = new Job(Messages.BatchALMReporting){

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.BatchALMReporting, sumCount);
                    for (ITestResultSummaryPO summary : summaries) {
                        try {
                            if (monitor.isCanceled()) {
                                return Status.CANCEL_STATUS;
                            }
                            ReportToAlmHandler.this.reportResults(summary, monitor);
                        }
                        catch (InterruptedException interruptedException) {
                            monitor.setCanceled(true);
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            reportToALMOperation.schedule();
        }
        return null;
    }

    private void reportResults(ITestResultSummaryPO summary, IProgressMonitor monitor) throws InterruptedException {
        TestResultViewer.GenerateTestResultTreeOperation operation = new TestResultViewer.GenerateTestResultTreeOperation(summary.getId(), GeneralStorage.getInstance().getMasterSession());
        operation.run((IProgressMonitor)new NullProgressMonitor());
        Job job = CommentReporter.getInstance().gatherInformationAndCreateReportToALMJob(summary, (IALMReportingProperties)summary, operation.getRootNode());
        if (job != null) {
            job.schedule();
            job.join();
        }
    }
}

