/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jubula.client.archive.dto.CheckActivatedContextDTO;
import org.eclipse.jubula.client.archive.dto.CheckAttributeDTO;
import org.eclipse.jubula.client.core.model.ICheckConfPO;

public class CheckConfigurationDTO {
    private String m_checkId;
    private String m_severity;
    private boolean m_activated;
    private List<CheckAttributeDTO> m_checkAttributes = new ArrayList<CheckAttributeDTO>();
    private List<CheckActivatedContextDTO> m_checkActivatedContextes = new ArrayList<CheckActivatedContextDTO>();

    public CheckConfigurationDTO() {
    }

    public CheckConfigurationDTO(ICheckConfPO chkConf) {
        this.setActivated(chkConf.isActive());
        this.setSeverity(chkConf.getSeverity());
        this.fillCheckAttribute(chkConf.getAttr());
        this.fillCheckContext(chkConf.getContexts());
    }

    @JsonProperty(value="checkId")
    public String getCheckId() {
        return this.m_checkId;
    }

    public void setCheckId(String checkId) {
        this.m_checkId = checkId;
    }

    @JsonProperty(value="severity")
    public String getSeverity() {
        return this.m_severity;
    }

    public void setSeverity(String severity) {
        this.m_severity = severity;
    }

    @JsonProperty(value="activated")
    public boolean isActivated() {
        return this.m_activated;
    }

    public void setActivated(boolean activated) {
        this.m_activated = activated;
    }

    @JsonProperty(value="checkAttributes")
    public List<CheckAttributeDTO> getCheckAttributes() {
        return this.m_checkAttributes;
    }

    public void addCheckAttribut(CheckAttributeDTO checkAttribut) {
        this.m_checkAttributes.add(checkAttribut);
    }

    @JsonProperty(value="checkActivatedContextes")
    public List<CheckActivatedContextDTO> getCheckActivatedContextes() {
        return this.m_checkActivatedContextes;
    }

    public void addCheckActivatedContext(CheckActivatedContextDTO checkActivatedContext) {
        this.m_checkActivatedContextes.add(checkActivatedContext);
    }

    private void fillCheckAttribute(Map<String, String> attr) {
        for (Map.Entry<String, String> e : attr.entrySet()) {
            CheckAttributeDTO chkAttr = new CheckAttributeDTO();
            chkAttr.setName(e.getKey());
            chkAttr.setValue(e.getValue());
            this.m_checkAttributes.add(chkAttr);
        }
    }

    private void fillCheckContext(Map<String, Boolean> contexts) {
        for (Map.Entry<String, Boolean> e : contexts.entrySet()) {
            CheckActivatedContextDTO chkConf = new CheckActivatedContextDTO();
            chkConf.setClazz(e.getKey());
            Boolean obj = e.getValue();
            if (obj instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)((Object)obj);
                chkConf.setActive(bd.equals(BigDecimal.ONE));
            } else {
                chkConf.setActive(e.getValue());
            }
            this.m_checkActivatedContextes.add(chkConf);
        }
    }
}

