/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jubula.client.core.utils.DatabaseStateEvent;
import org.eclipse.jubula.client.core.utils.IDatabaseStateListener;

public class DatabaseStateDispatcher {
    private static Set<IDatabaseStateListener> listener;

    private DatabaseStateDispatcher() {
    }

    public static void addDatabaseStateListener(IDatabaseStateListener l) {
        DatabaseStateDispatcher.getListeners().add(l);
    }

    public static void removeDatabaseStateListener(IDatabaseStateListener l) {
        DatabaseStateDispatcher.getListeners().remove(l);
    }

    public static void notifyListener(DatabaseStateEvent e) {
        for (IDatabaseStateListener progressListener : DatabaseStateDispatcher.getListeners()) {
            if (progressListener != null) {
                progressListener.reactOnDatabaseEvent(e);
                continue;
            }
            if (listener == null) continue;
            listener.remove(progressListener);
        }
    }

    private static Set<IDatabaseStateListener> getListeners() {
        if (listener == null) {
            listener = new HashSet<IDatabaseStateListener>();
        }
        return listener;
    }
}

