/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.controllers.dnd;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.AbstractNodeViewerDropAdapter;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionTransfer;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.TJEditorDndSupport;
import org.eclipse.jubula.client.ui.rcp.editors.TestJobEditor;
import org.eclipse.swt.dnd.TransferData;

public class TJEditorDropTargetListener
extends AbstractNodeViewerDropAdapter {
    private TestJobEditor m_editor;

    public TJEditorDropTargetListener(TestJobEditor editor) {
        super((Viewer)editor.getTreeViewer());
        this.m_editor = editor;
        boolean scrollExpand = Plugin.getDefault().getPreferenceStore().getBoolean("TREEAUTOSCROLL_PREF_KEY");
        this.setScrollExpandEnabled(scrollExpand);
    }

    public boolean performDrop(Object data) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        IStructuredSelection selection = transfer.getSelection();
        Object target = this.getCurrentTarget();
        int location = this.getCurrentLocation();
        if (target == null) {
            target = this.getFallbackTarget(this.getViewer());
            location = 2;
        }
        if (selection instanceof StructuredSelection && target instanceof INodePO) {
            boolean succ = TJEditorDndSupport.performDrop(this.m_editor, selection, (INodePO)target, location);
            this.logDrop(selection, (INodePO)target, succ);
            return succ;
        }
        return false;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        LocalSelectionTransfer transfer = LocalSelectionTransfer.getInstance();
        IStructuredSelection selection = transfer.getSelection();
        if (selection instanceof StructuredSelection) {
            Object targetNode = target;
            if (targetNode == null) {
                targetNode = this.m_editor.getEditorHelper().getEditSupport().getWorkVersion();
            }
            if (targetNode instanceof INodePO) {
                return TJEditorDndSupport.validateDrop(transfer.getSource(), this.getViewer(), selection, (INodePO)targetNode, true);
            }
        }
        return false;
    }
}

