/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.RemoteFileStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.internal.ide.dialogs.IDEResourceInfoUtils;
import org.eclipse.ui.internal.ide.dialogs.IFileStoreFilter;

public class RemoteFileBrowserDialog
extends ElementTreeSelectionDialog {
    private ListViewer m_fsRootBrowser;
    private List<String> m_fsRootsInput;

    public RemoteFileBrowserDialog(Shell parent, boolean multiSelect, int type) {
        super(parent, (ILabelProvider)new FileLabelProvider(), (ITreeContentProvider)new FileContentProvider((type & 1) != 0));
        this.setShellStyle(this.getShellStyle() | 0x10000);
        this.setComparator(new FileViewerSorter());
        this.setValidator(new FileSelectionValidator(multiSelect, (type & 2) != 0));
        this.setEmptyListMessage(Messages.AUTConfigComponentRemoteDirEmpty);
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        this.m_fsRootBrowser = this.createFSRootSelector(parent, style);
        TreeViewer tv = super.doCreateTreeViewer(parent, style);
        return tv;
    }

    private ListViewer createFSRootSelector(Composite parent, int style) {
        ListViewer lv = new ListViewer(parent, style);
        lv.setContentProvider((IContentProvider)new ArrayContentProvider());
        lv.setInput(this.m_fsRootsInput);
        lv.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RemoteFileStore oldFS = (RemoteFileStore)((Object)RemoteFileBrowserDialog.this.getTreeViewer().getInput());
                RemoteFileStore newRemoteFS = new RemoteFileStore(oldFS.getCommunicator(), (String)((StructuredSelection)event.getSelection()).getFirstElement(), true);
                RemoteFileBrowserDialog.this.setInput((Object)newRemoteFS);
                RemoteFileBrowserDialog.this.getTreeViewer().setInput((Object)newRemoteFS);
                RemoteFileBrowserDialog.this.getTreeViewer().getTree().setFocus();
            }
        });
        GridData data = new GridData(1808);
        org.eclipse.swt.widgets.List list = lv.getList();
        list.setLayoutData((Object)data);
        list.setFont(parent.getFont());
        return lv;
    }

    public void setFSRoots(List<String> remoteFSRoots) {
        this.m_fsRootsInput = remoteFSRoots;
    }

    public void setInput(Object input) {
        super.setInput(input);
    }

    public void create() {
        super.create();
        this.selectRoot();
        this.getTreeViewer().getTree().setFocus();
    }

    private void selectRoot() {
        Object input;
        TreeViewer treeViewer = this.getTreeViewer();
        if (treeViewer != null && (input = treeViewer.getInput()) != null && input instanceof RemoteFileStore) {
            RemoteFileStore fs = (RemoteFileStore)((Object)input);
            if (this.m_fsRootBrowser != null) {
                this.m_fsRootBrowser.setSelection((ISelection)new StructuredSelection((Object)fs.getPath()));
            }
        }
    }

    private static class FileContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private IFileStoreFilter m_fileFilter;

        public FileContentProvider(final boolean showFiles) {
            this.m_fileFilter = new IFileStoreFilter(){

                public boolean accept(IFileStore file) {
                    if (!file.fetchInfo().exists()) {
                        return false;
                    }
                    return file.fetchInfo().isDirectory() || showFiles;
                }
            };
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children;
            if (parentElement instanceof IFileStore && (children = IDEResourceInfoUtils.listFileStores((IFileStore)((IFileStore)parentElement), (IFileStoreFilter)this.m_fileFilter, (IProgressMonitor)new NullProgressMonitor())) != null) {
                return children;
            }
            return EMPTY;
        }

        public Object getParent(Object element) {
            if (element instanceof IFileStore) {
                return ((IFileStore)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class FileLabelProvider
    extends LabelProvider {
        private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        private static final Image IMG_FILE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");

        private FileLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IFileStore) {
                IFileStore curr = (IFileStore)element;
                if (curr.fetchInfo().isDirectory()) {
                    return IMG_FOLDER;
                }
                return IMG_FILE;
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof IFileStore) {
                return ((IFileStore)element).getName();
            }
            return super.getText(element);
        }
    }

    private static class FileSelectionValidator
    implements ISelectionStatusValidator {
        private boolean m_multiSelect;
        private boolean m_acceptFolders;

        public FileSelectionValidator(boolean multiSelect, boolean acceptFolders) {
            this.m_multiSelect = multiSelect;
            this.m_acceptFolders = acceptFolders;
        }

        public IStatus validate(Object[] selection) {
            int nSelected = selection.length;
            String pluginId = "org.eclipse.ui.ide";
            if (nSelected == 0 || nSelected > 1 && !this.m_multiSelect) {
                return new Status(4, pluginId, 4, "", null);
            }
            int i = 0;
            while (i < selection.length) {
                Object curr = selection[i];
                if (curr instanceof IFileStore) {
                    IFileStore file = (IFileStore)curr;
                    if (!this.m_acceptFolders && file.fetchInfo().isDirectory()) {
                        return new Status(4, pluginId, 4, "", null);
                    }
                }
                ++i;
            }
            return Status.OK_STATUS;
        }
    }

    private static class FileViewerSorter
    extends ViewerComparator {
        private FileViewerSorter() {
        }

        public int category(Object element) {
            if (element instanceof IFileStore && !((IFileStore)element).fetchInfo().isDirectory()) {
                return 1;
            }
            return 0;
        }
    }
}

