/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.OpenOMETracker;
import org.eclipse.jubula.client.ui.rcp.editors.ObjectMappingMultiPageEditor;
import org.eclipse.jubula.client.ui.rcp.filter.ObjectMappingEditorProfileFilter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

public class FilterProfileHandler
extends AbstractHandler
implements IElementUpdater,
IChangeListener {
    private static final String FILTER_ACTIVE_PARAMETER = "org.eclipse.jubula.client.ui.rcp.command.parameters.filterActiveParameter";
    private static final String FILTER_PROFILE_PARAMETER = "org.eclipse.jubula.client.ui.rcp.command.parameters.filterProfilesParameter";
    private static final String FILTER_PROFILE_STATE = "org.eclipse.jubula.client.ui.rcp.commands.FilterProfile.state.filterProfile";
    private static final ObjectMappingEditorProfileFilter FILTER = new ObjectMappingEditorProfileFilter();

    public FilterProfileHandler() {
        OpenOMETracker.INSTANCE.addListener(this);
    }

    public void dispose() {
        OpenOMETracker.INSTANCE.removeListener(this);
        super.dispose();
    }

    public void updateElement(UIElement element, Map parameters) {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.eclipse.jubula.client.ui.rcp.commands.FilterProfile");
        State state = command.getState(FILTER_PROFILE_STATE);
        State filterActive = command.getState("org.eclipse.ui.commands.toggleState");
        Object filterActiveParameter = parameters.get(FILTER_ACTIVE_PARAMETER);
        if (state != null && filterActive != null && filterActiveParameter != null && filterActive.getValue().equals(true)) {
            element.setIcon(IconConstants.PROFILE_FILTER_ON_DESCRIPTOR);
        } else if (filterActive != null && filterActiveParameter != null && filterActive.getValue().equals(false)) {
            element.setIcon(IconConstants.PROFILE_FILTER_OFF_DESCRIPTOR);
        } else {
            for (Object o : parameters.keySet()) {
                if (!o.equals(FILTER_PROFILE_PARAMETER) || state == null || state.getValue() == null || !state.getValue().equals(parameters.get(o))) continue;
                element.setChecked(true);
            }
        }
    }

    protected Object executeImpl(ExecutionEvent event) throws ExecutionException {
        String parameter = event.getParameter(FILTER_PROFILE_PARAMETER);
        Command command = event.getCommand();
        State profileState = command.getState(FILTER_PROFILE_STATE);
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        Iterator i = OpenOMETracker.INSTANCE.getIterator();
        ArrayList<TreeViewer> views = new ArrayList<TreeViewer>();
        while (i.hasNext()) {
            ObjectMappingMultiPageEditor ome = (ObjectMappingMultiPageEditor)i.next();
            views.addAll(this.getViews(ome));
        }
        if (profileState != null && parameter != null && profileState.getValue() != null && profileState.getValue().equals(parameter)) {
            toggleState.setValue((Object)false);
            profileState.setValue((Object)"null");
            this.checkFilter(views);
        } else if (parameter == null) {
            profileState.setValue((Object)parameter);
            toggleState.setValue((Object)false);
            this.checkFilter(views);
        } else {
            profileState.setValue((Object)parameter);
            toggleState.setValue((Object)true);
            for (TreeViewer treeViewer : views) {
                treeViewer.removeFilter((ViewerFilter)FILTER);
            }
            FILTER.setPattern(parameter);
            this.checkFilter(views);
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        if (commandService != null) {
            commandService.refreshElements(command.getId(), null);
        }
        return null;
    }

    private List<TreeViewer> getViews(ObjectMappingMultiPageEditor ome) {
        ArrayList<TreeViewer> views = new ArrayList<TreeViewer>();
        views.add(ome.getUIElementTreeViewer());
        views.add(ome.getMappedTreeViewer());
        return views;
    }

    private void checkFilter(List<TreeViewer> views) {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.eclipse.jubula.client.ui.rcp.commands.FilterProfile");
        State filterActive = command.getState("org.eclipse.ui.commands.toggleState");
        for (TreeViewer treeViewer : views) {
            boolean alreadyHasFilter = false;
            ViewerFilter[] viewerFilterArray = treeViewer.getFilters();
            int n = viewerFilterArray.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter f = viewerFilterArray[n2];
                if (f.equals((Object)FILTER)) {
                    if (filterActive.getValue().equals(false)) {
                        treeViewer.removeFilter((ViewerFilter)FILTER);
                    }
                    alreadyHasFilter = true;
                }
                ++n2;
            }
            if (!filterActive.getValue().equals(true) || alreadyHasFilter) continue;
            treeViewer.addFilter((ViewerFilter)FILTER);
        }
        service.refreshElements(command.getId(), null);
    }

    private void resetCommand() {
        ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = service.getCommand("org.eclipse.jubula.client.ui.rcp.commands.FilterProfile");
        State filterActive = command.getState("org.eclipse.ui.commands.toggleState");
        State profileState = command.getState(FILTER_PROFILE_STATE);
        filterActive.setValue((Object)false);
        profileState.setValue(null);
    }

    /*
     * Unable to fully structure code
     */
    public void handleChange(ChangeEvent event) {
        block1: {
            i = OpenOMETracker.INSTANCE.getIterator();
            if (i.hasNext()) ** GOTO lbl6
            this.resetCommand();
            break block1;
lbl-1000:
            // 1 sources

            {
                this.checkFilter(this.getViews((ObjectMappingMultiPageEditor)i.next()));
lbl6:
                // 2 sources

                ** while (i.hasNext())
            }
        }
    }
}

