/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.TestDataBP;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.ParamTextPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.CentralTestDataEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.open.AbstractOpenHandler;
import org.eclipse.jubula.client.ui.rcp.views.JBPropertiesPage;
import org.eclipse.jubula.client.ui.rcp.views.dataset.AbstractDataSetPage;
import org.eclipse.jubula.client.ui.rcp.views.dataset.DataSetView;
import org.eclipse.swt.SWTException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.PropertySheet;

public class JumpToCTDSHandler
extends AbstractHandler {
    public Object executeImpl(ExecutionEvent event) {
        String mined = this.mineString();
        if (mined == null) {
            this.jumpToCTDSEditorByReferenceCube();
        }
        if (mined != null) {
            this.jumpToCTDSEditor(mined);
        }
        return null;
    }

    private String mineString() {
        ViewPart v = Plugin.getActiveView();
        if (v instanceof PropertySheet) {
            return this.mineFromPropertyView((PropertySheet)v);
        }
        if (v instanceof DataSetView) {
            return this.mineFromDataSetView((DataSetView)v);
        }
        return null;
    }

    private String mineFromPropertyView(PropertySheet p) {
        if (!(p.getCurrentPage() instanceof JBPropertiesPage)) {
            return null;
        }
        ITreeSelection ssel = ((JBPropertiesPage)p.getCurrentPage()).getCurrentTreeSelection();
        if (ssel == null) {
            return null;
        }
        Object f = ssel.getFirstElement();
        if (!(f instanceof ParamTextPropertyDescriptor)) {
            return null;
        }
        ParamTextPropertyDescriptor pd = (ParamTextPropertyDescriptor)f;
        if (!(pd.getId() instanceof AbstractNodePropertySource.AbstractParamValueController)) {
            return null;
        }
        return ((AbstractNodePropertySource.AbstractParamValueController)pd.getId()).getProperty();
    }

    private String mineFromDataSetView(DataSetView view) {
        if (!(view.getCurrentPage() instanceof AbstractDataSetPage)) {
            return null;
        }
        AbstractDataSetPage page = (AbstractDataSetPage)view.getCurrentPage();
        Object res = null;
        try {
            res = page.getTableCursor().getData();
        }
        catch (SWTException sWTException) {}
        if (!(res instanceof String)) {
            return null;
        }
        return (String)res;
    }

    public void jumpToCTDSEditor(String value) {
        String[] best = null;
        int max = 0;
        for (String[] arr : TestDataBP.getAllCTDSReferences((String)value)) {
            int num = 0;
            int i = 0;
            while (i < arr.length) {
                if (arr[i] != null) {
                    ++num;
                }
                ++i;
            }
            if (num <= max) continue;
            best = arr;
            max = num;
        }
        if (best != null) {
            this.openCTDS(best);
        }
    }

    private void openCTDS(String[] data) {
        IProjectPO proj = GeneralStorage.getInstance().getProject();
        IParameterInterfacePO po = TestDataCubeBP.getTestDataCubeByName((String)data[0], (IProjectPO)proj);
        if (po == null) {
            return;
        }
        IEditorPart part = AbstractOpenHandler.openEditor((IPersistentObject)proj.getTestDataCubeCont());
        if (!(part instanceof CentralTestDataEditor) || data[1] == null || data[2] == null) {
            return;
        }
        CentralTestDataEditor ctdsEd = (CentralTestDataEditor)part;
        po = (IParameterInterfacePO)ctdsEd.getEntityManager().find(po.getClass(), (Object)po.getId());
        ctdsEd.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)po));
        IViewPart view = Plugin.showView("org.eclipse.jubula.client.ui.rcp.views.DataSetView");
        if (!(view instanceof DataSetView)) {
            return;
        }
        ((DataSetView)view).navigateToCell(data[1], data[2], data[3]);
    }

    private void jumpToCTDSEditorByReferenceCube() {
        Object firstElement = this.getSelectionFromActiveEditor();
        if (firstElement instanceof IParameterInterfacePO) {
            IParameterInterfacePO referencedDataCube = ((IParameterInterfacePO)firstElement).getReferencedDataCube();
            if (referencedDataCube == null) {
                return;
            }
            IProjectPO proj = GeneralStorage.getInstance().getProject();
            IEditorPart part = AbstractOpenHandler.openEditor((IPersistentObject)proj.getTestDataCubeCont());
            CentralTestDataEditor ctdsEd = (CentralTestDataEditor)part;
            IParameterInterfacePO find = (IParameterInterfacePO)ctdsEd.getEditorHelper().getEditSupport().getSession().find(referencedDataCube.getClass(), (Object)referencedDataCube.getId());
            if (find == null) {
                return;
            }
            ctdsEd.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)find));
            Plugin.showView("org.eclipse.jubula.client.ui.rcp.views.DataSetView");
        }
    }

    private Object getSelectionFromActiveEditor() {
        AbstractJBEditor activeJBEditor = Plugin.getDefault().getActiveJBEditor();
        if (activeJBEditor == null) {
            return null;
        }
        ISelection selection = activeJBEditor.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            return structSelection.getFirstElement();
        }
        return null;
    }
}

