/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jubula.client.core.persistence.EditSupport;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PMObjectDeletedException;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.dialogs.JBPropertyDialog;
import org.eclipse.jubula.client.ui.rcp.extensions.ProjectPropertyExtensionHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.properties.AUTPropertyPage;
import org.eclipse.jubula.client.ui.rcp.properties.AbstractProjectPropertyPage;
import org.eclipse.jubula.client.ui.rcp.properties.ProjectALMPropertyPage;
import org.eclipse.jubula.client.ui.rcp.properties.ProjectGeneralPropertyPage;
import org.eclipse.jubula.client.ui.rcp.properties.ProjectUsedPropertyPage;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.swt.widgets.Shell;

public class ProjectPropertyDialog {
    private ProjectPropertyDialog() {
    }

    public static final void showPropertyDialog(Shell shell, String sectionToOpen, String innerSectionToOpen) {
        PreferenceManager mgr = new PreferenceManager();
        StructuredSelection sel = new StructuredSelection((Object)GeneralStorage.getInstance().getProject());
        try {
            EditSupport es = AbstractProjectPropertyPage.createEditSupport();
            ProjectGeneralPropertyPage generalPage = ProjectPropertyDialog.createPages(es, mgr);
            for (AbstractProjectPropertyPage pg : ProjectPropertyExtensionHandler.createPages(es, mgr)) {
                if (!(pg instanceof ProjectGeneralPropertyPage.IOkListener)) continue;
                generalPage.addOkListener((ProjectGeneralPropertyPage.IOkListener)((Object)pg));
            }
            JBPropertyDialog dialog = new JBPropertyDialog(shell, mgr, (ISelection)sel);
            dialog.create();
            if (sectionToOpen != null) {
                dialog.setCurrentPageId(sectionToOpen);
                IPreferencePage page = dialog.getCurrentPage();
                if (page instanceof PreferencePage) {
                    ((PreferencePage)page).applyData((Object)innerSectionToOpen);
                }
            }
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            Shell s = dialog.getShell();
            s.setText(String.valueOf(Messages.ProjectPropertyPageShellTitle) + generalPage.getProject().getName());
            DialogUtils.adjustShellSizeRelativeToClientSize((Shell)s, (float)0.8f, (float)0.9f, (DialogUtils.SizeType)DialogUtils.SizeType.SIZE);
            dialog.open();
            es.close();
        }
        catch (PMObjectDeletedException pMObjectDeletedException) {
            PMExceptionHandler.handleProjectDeletedException();
        }
        catch (PMException e) {
            ErrorHandlingUtil.createMessageDialog((JBException)((Object)e), null, null);
        }
    }

    private static final ProjectGeneralPropertyPage createPages(EditSupport es, PreferenceManager mgr) {
        ProjectGeneralPropertyPage generalPage = new ProjectGeneralPropertyPage(es);
        generalPage.setTitle(Messages.PropertiesActionPage1);
        PreferenceNode generalNode = new PreferenceNode("org.eclipse.jubula.client.ui.projectProperties.ProjectPropertyPage", (IPreferencePage)generalPage);
        mgr.addToRoot((IPreferenceNode)generalNode);
        AUTPropertyPage autPage = new AUTPropertyPage(es);
        autPage.setTitle(Messages.PropertiesActionPage3);
        PreferenceNode autNode = new PreferenceNode("org.eclipse.jubula.client.ui.projectProperties.AUTPropertyPage", (IPreferencePage)autPage);
        mgr.addToRoot((IPreferenceNode)autNode);
        ProjectUsedPropertyPage usedPage = new ProjectUsedPropertyPage(es);
        usedPage.setTitle(Messages.PropertiesActionPage4);
        PreferenceNode usedNode = new PreferenceNode("org.eclipse.jubula.client.ui.projectProperties.ReusedProjectPropertyPage", (IPreferencePage)usedPage);
        mgr.addToRoot((IPreferenceNode)usedNode);
        ProjectALMPropertyPage almPage = new ProjectALMPropertyPage(es);
        almPage.setTitle(Messages.PropertiesActionPage5);
        PreferenceNode almNode = new PreferenceNode("org.eclipse.jubula.client.ui.projectProperties.ALMProjectPropertyPage", (IPreferencePage)almPage);
        mgr.addToRoot((IPreferenceNode)almNode);
        generalPage.addOkListener(usedPage);
        generalPage.addOkListener(almPage);
        return generalPage;
    }
}

