/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.project;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.dto.ProjectDTO;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ParamNameBPDecorator;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.ui.handlers.project.AbstractProjectHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.VersionDialog;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.tools.internal.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveProjectAsHandler
extends AbstractProjectHandler {
    private static Logger log = LoggerFactory.getLogger(SaveProjectAsHandler.class);

    private IRunnableWithProgress createOperation(String newProjectName, ProjectVersion version) {
        return new SaveAsOperation(newProjectName, version);
    }

    private VersionDialog openInputDialog() {
        VersionDialog dialog = new VersionDialog(this.getActiveShell(), Messages.SaveProjectAsActionTitle, Messages.SaveProjectAsActionMessage, "bigProject.gif", Messages.SaveProjectAsActionShellTitle, true){

            @Override
            protected boolean isInputAllowed() {
                String newProjectName = this.getProjectNameFieldValue();
                boolean isInputAllowed = true;
                if (StringUtils.isBlank((String)newProjectName) || !ProjectNameBP.isValidProjectName((String)newProjectName, (boolean)true)) {
                    this.setErrorMessage(Messages.SaveProjectAsActionInvalidName);
                    isInputAllowed = false;
                }
                if (ProjectPM.doesProjectNameExist((String)newProjectName)) {
                    this.setErrorMessage(Messages.SaveProjectAsActionDoubleOrInvalidName);
                    isInputAllowed = false;
                }
                return isInputAllowed;
            }

            @Override
            protected void okPressed() {
                String newProjectName = this.getProjectNameFieldValue();
                if (ProjectPM.doesProjectNameExist((String)newProjectName) || StringUtils.isBlank((String)newProjectName)) {
                    ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_PROJECTNAME_ALREADY_EXISTS, (Object[])new Object[]{this.getProjectNameFieldValue()}, null);
                    return;
                }
                super.okPressed();
            }
        };
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogProjectSaveAsContextId");
        dialog.open();
        return dialog;
    }

    private void fireReady() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.fireProjectLoadedListener((IProgressMonitor)new NullProgressMonitor());
        ded.fireProjectStateChanged(DataEventDispatcher.ProjectState.opened);
    }

    public Object executeImpl(ExecutionEvent event) {
        VersionDialog dialog = this.openInputDialog();
        if (dialog.getReturnCode() == 0) {
            String newProjectName = dialog.getProjectName();
            IRunnableWithProgress op = this.createOperation(newProjectName, dialog.getProjectVersion());
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(op);
                this.fireReady();
            }
            catch (InvocationTargetException ite) {
                log.error(ite.getLocalizedMessage(), ite.getCause());
            }
            catch (InterruptedException interruptedException) {
                Utils.clearClient();
            }
        }
        return null;
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    private class SaveAsOperation
    implements IRunnableWithProgress {
        private static final int TOTAL_WORK = 100;
        private static final int WORK_GET_PROJECT_FROM_DB = 5;
        private static final int WORK_PROJECT_CREATION = 10;
        private static final int WORK_PROJECT_SAVE = 85;
        private String m_newProjectName;
        private ProjectVersion m_newProjectVersion;

        public SaveAsOperation(String newProjectName, ProjectVersion version) {
            this.m_newProjectName = newProjectName;
            this.m_newProjectVersion = version;
        }

        /*
         * Exception decompiling
         */
        public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void changeProjectVersion(ProjectDTO dto) {
            dto.setMajorProjectVersion(this.m_newProjectVersion.getMajorNumber());
            dto.setMinorProjectVersion(this.m_newProjectVersion.getMinorNumber());
            dto.setMicroProjectVersion(this.m_newProjectVersion.getMicroNumber());
            dto.setProjectVersionQualifier(this.m_newProjectVersion.getVersionQualifier());
        }

        private void attachProjectWithProgress(IProgressMonitor monitor, ParamNameBPDecorator paramNameMapper, IWritableComponentNameCache compNameCache, IProjectPO project) throws PMException, ProjectDeletedException, InterruptedException {
            IProjectPO clearedProject = GeneralStorage.getInstance().getProject();
            if (clearedProject != null) {
                Utils.clearClient();
                GeneralStorage.getInstance().nullProject();
                DataEventDispatcher ded = DataEventDispatcher.getInstance();
                ded.fireDataChangedListener((IPersistentObject)clearedProject, DataEventDispatcher.DataState.Deleted, DataEventDispatcher.UpdateState.all);
            }
            ArrayList<ParamNameBPDecorator> mapperList = new ArrayList<ParamNameBPDecorator>();
            ArrayList<IWritableComponentNameCache> compNameCacheList = new ArrayList<IWritableComponentNameCache>();
            mapperList.add(paramNameMapper);
            compNameCacheList.add(compNameCache);
            ProjectPM.attachProjectToROSession((IProjectPO)project, (String)this.m_newProjectName, mapperList, compNameCacheList, (IProgressMonitor)monitor);
            Plugin.stopLongRunning();
        }
    }
}

