/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.provider.labelprovider;

import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.db.NodeBP;
import org.eclipse.jubula.client.core.businessprocess.problems.ProblemFactory;
import org.eclipse.jubula.client.core.model.IAbstractContainerPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.ICondStructPO;
import org.eclipse.jubula.client.core.model.IConditionalStatementPO;
import org.eclipse.jubula.client.core.model.IControllerPO;
import org.eclipse.jubula.client.core.model.IDoWhilePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IIteratePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.IWhileDoPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.NodeNameUtil;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.dnd.LocalSelectionClipboardTransfer;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralLabelProvider
extends ColumnLabelProvider
implements IColorProvider,
ILabelProvider {
    protected static final String INACTIVE_PREFIX = "// ";
    protected static final String CLOSE_BRACKED = "]";
    protected static final String OPEN_BRACKED = " [";
    protected static final String SEPARATOR = "; ";
    protected static final String NEGATED_POSTFIX = " (negated) ";
    private static final Logger LOG = LoggerFactory.getLogger(GeneralLabelProvider.class);
    private static final String UNNAMED_NODE = Messages.GeneralLabelProviderUnnamedNode;
    private static final String COMMENT_PREFIX = String.valueOf(Messages.AbstractGuiNodePropertySourceComment) + ":" + " ";
    private static final Color DISABLED_COLOR = LayoutUtil.GRAY_COLOR;
    private static Color reusedProjectsColor = null;
    private static Color commentColor = null;
    private static Clipboard clipboard = null;

    public void dispose() {
    }

    public String getText(Object element) {
        return GeneralLabelProvider.getTextImpl(element);
    }

    public Image getImage(Object element) {
        IStructuredSelection sel;
        Object cbContents;
        LocalSelectionClipboardTransfer transfer;
        Image image = GeneralLabelProvider.getImageImpl(element);
        if (element instanceof INodePO && ((INodePO)element).isGenerated()) {
            image = Plugin.getGeneratedImage(image);
        }
        if ((transfer = LocalSelectionClipboardTransfer.getInstance()).getIsItCut() && (cbContents = this.getClipboard().getContents((Transfer)transfer)) instanceof IStructuredSelection && (sel = (IStructuredSelection)cbContents).toList().contains(element)) {
            image = Plugin.getCutImage(image);
        }
        return image;
    }

    private Clipboard getClipboard() {
        if (clipboard == null) {
            clipboard = new Clipboard(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay());
        }
        return clipboard;
    }

    public String getToolTipText(Object element) {
        if (element instanceof ICommentPO) {
            ICommentPO comment = (ICommentPO)element;
            return comment.getName();
        }
        if (element instanceof INodePO) {
            INodePO node = (INodePO)element;
            StringBuilder toolTip = new StringBuilder();
            String comment = node.getComment();
            if (!StringUtils.isBlank((String)comment)) {
                toolTip.append(COMMENT_PREFIX);
                toolTip.append(ObjectUtils.toString((Object)comment));
                return toolTip.toString();
            }
        }
        return super.getToolTipText(element);
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 50;
    }

    public int getToolTipTimeDisplayed(Object object) {
        if (object instanceof ICommentPO) {
            String comment = ((ICommentPO)object).getName();
            int linebreaks = comment.split(String.valueOf(System.lineSeparator()) + "+").length;
            int spaces = comment.split(" +").length;
            return (linebreaks + spaces) * 500;
        }
        return 5000;
    }

    public Image getToolTipImage(Object object) {
        if (object instanceof INodePO) {
            INodePO node = (INodePO)object;
            if (ProblemFactory.hasProblem((INodePO)node)) {
                switch (ProblemFactory.getWorstProblem((Set)node.getProblems()).getStatus().getSeverity()) {
                    case 1: {
                        return IconConstants.INFO_IMAGE;
                    }
                    case 2: {
                        return IconConstants.WARNING_IMAGE;
                    }
                    case 4: {
                        return IconConstants.ERROR_IMAGE;
                    }
                }
            }
        } else if (object instanceof IComponentNamePO && ((IComponentNamePO)object).getTypeProblem() != null) {
            return IconConstants.ERROR_IMAGE;
        }
        return super.getToolTipImage(object);
    }

    public static String getTextImpl(Object element) {
        if (element instanceof INodePO) {
            String prefix = "";
            String name = null;
            INodePO node = (INodePO)element;
            if (node.isSpecObjCont()) {
                return Messages.TreeBuilderTestCases;
            }
            if (node.isExecObjCont()) {
                IProjectPO proj = GeneralStorage.getInstance().getProject();
                if (proj != null) {
                    return proj.getName();
                }
                LOG.error(Messages.GeneralLabelProvier_NoActiveProject);
            }
            if (!GeneralLabelProvider.checkActivation(node)) {
                prefix = INACTIVE_PREFIX;
                if (!node.isActive() && !GeneralLabelProvider.isParentActive(node)) {
                    prefix = String.valueOf(prefix) + INACTIVE_PREFIX;
                }
            }
            name = node instanceof IRefTestSuitePO ? NodeNameUtil.getText((IRefTestSuitePO)((IRefTestSuitePO)node)) : (node.getName() == null ? UNNAMED_NODE : (node instanceof ICapPO ? GeneralLabelProvider.getText((ICapPO)node) : (node instanceof IExecTestCasePO ? NodeNameUtil.getText((IExecTestCasePO)((IExecTestCasePO)node), (boolean)true) : (node instanceof ISpecTestCasePO ? NodeNameUtil.getText((ISpecTestCasePO)((ISpecTestCasePO)node), (boolean)true) : node.getName()))));
            String postfix = "";
            if (node instanceof ICondStructPO && ((ICondStructPO)node).isNegate()) {
                postfix = NEGATED_POSTFIX;
            }
            return prefix + name + postfix;
        }
        if (element instanceof IReusedProjectPO) {
            IReusedProjectPO reusedProject = (IReusedProjectPO)element;
            String projectName = reusedProject.getProjectName();
            if (projectName == null) {
                projectName = reusedProject.getProjectGuid();
            }
            return String.valueOf(projectName) + "_" + "[" + reusedProject.getVersionString() + CLOSE_BRACKED;
        }
        if (element instanceof AbstractTestCaseEditor) {
            return GeneralLabelProvider.getTextImpl(((AbstractTestCaseEditor)element).getEditorHelper().getEditSupport().getWorkVersion());
        }
        return element == null ? "" : element.toString();
    }

    public static Image getImageImpl(Object element) {
        if (element instanceof INodePO && ((INodePO)element).isExecObjCont()) {
            return IconConstants.PROJECT_IMAGE;
        }
        if (element instanceof ITestSuitePO) {
            return IconConstants.TS_IMAGE;
        }
        if (element instanceof ICapPO) {
            return IconConstants.CAP_IMAGE;
        }
        if (element instanceof IEventExecTestCasePO) {
            return IconConstants.EH_IMAGE;
        }
        if (element instanceof IExecTestCasePO) {
            return IconConstants.TC_REF_IMAGE;
        }
        if (element instanceof ISpecTestCasePO) {
            return IconConstants.TC_IMAGE;
        }
        if (element instanceof ITestJobPO) {
            return IconConstants.TJ_IMAGE;
        }
        if (element instanceof ICategoryPO || element instanceof IReusedProjectPO) {
            return IconConstants.CATEGORY_IMAGE;
        }
        if (element instanceof IRefTestSuitePO) {
            return IconConstants.TS_REF_IMAGE;
        }
        if (element instanceof ITestDataCubePO) {
            return IconConstants.TDC_IMAGE;
        }
        if (element instanceof ICommentPO) {
            return IconConstants.COMMENT_IMAGE;
        }
        if (element instanceof IConditionalStatementPO) {
            return IconConstants.CONDITION;
        }
        if (element instanceof IDoWhilePO) {
            return IconConstants.DO_WHILE;
        }
        if (element instanceof IWhileDoPO) {
            return IconConstants.WHILE_DO;
        }
        if (element instanceof IAbstractContainerPO) {
            return IconConstants.CONTAINER;
        }
        if (element instanceof IIteratePO) {
            return IconConstants.ITERATE;
        }
        if (element instanceof AbstractTestCaseEditor) {
            return ((AbstractTestCaseEditor)element).getIcon();
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof IExecTestCasePO || element instanceof ICapPO || element instanceof IRefTestSuitePO || element instanceof IControllerPO || element instanceof IAbstractContainerPO) {
            if (!GeneralLabelProvider.checkActivation((INodePO)element)) {
                return LayoutUtil.INACTIVE_COLOR;
            }
            return DISABLED_COLOR;
        }
        if (element instanceof ISpecTestCasePO) {
            return null;
        }
        if (element instanceof IReusedProjectPO || element instanceof INodePO && !NodeBP.isEditable((IPersistentObject)((INodePO)element))) {
            return this.getReusedProjectsColor();
        }
        if (element instanceof ICommentPO) {
            return this.getCommentColor();
        }
        return null;
    }

    private static boolean checkActivation(INodePO node) {
        if (!node.isActive()) {
            return false;
        }
        return GeneralLabelProvider.isParentActive(node);
    }

    private static boolean isParentActive(INodePO node) {
        INodePO parent = node.getParentNode();
        while (parent != null && !(parent instanceof ISpecTestCasePO)) {
            if (!parent.isActive()) {
                return false;
            }
            parent = parent.getParentNode();
        }
        return true;
    }

    private Color getReusedProjectsColor() {
        if (reusedProjectsColor == null) {
            reusedProjectsColor = Display.getDefault().getSystemColor(9);
        }
        return reusedProjectsColor;
    }

    private Color getCommentColor() {
        if (commentColor == null) {
            commentColor = Display.getDefault().getSystemColor(9);
        }
        return commentColor;
    }

    private static String getText(ICapPO testStep) {
        if (Plugin.getDefault().getPreferenceStore().getBoolean("SHOWCAPINFO_PREF_KEY")) {
            StringBuilder nameBuilder = new StringBuilder(testStep.getName());
            nameBuilder.append(OPEN_BRACKED);
            Map map = StringHelper.getInstance().getMap();
            IComponentNameCache compCache = Plugin.getActiveCompCache();
            nameBuilder.append(Messages.CapGUIType).append((String)map.get(testStep.getComponentType())).append(SEPARATOR).append(Messages.CapGUIName);
            String componentName = testStep.getComponentName();
            componentName = compCache != null ? compCache.getNameByGuid(componentName) : CompNameManager.getInstance().getNameByGuid(componentName);
            if (componentName != null) {
                nameBuilder.append(componentName);
            }
            nameBuilder.append(SEPARATOR).append(Messages.CapGUIAction).append((String)map.get(testStep.getActionName())).append(CLOSE_BRACKED);
            return nameBuilder.toString();
        }
        return testStep.getName();
    }

    private static String getShortTypeName(IParamDescriptionPO paramDesc) {
        String typeName = paramDesc.getType();
        int i = typeName.lastIndexOf(46);
        return typeName.substring(i + 1);
    }

    public static String getTextWithType(IParamDescriptionPO paramDesc) {
        return String.valueOf(paramDesc.getName()) + OPEN_BRACKED + GeneralLabelProvider.getShortTypeName(paramDesc) + CLOSE_BRACKED;
    }
}

