/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.util;

public class NameValidator {
    private NameValidator() {
    }

    public static String convertToValidLogicalName(String name) {
        String trimName = name.trim();
        StringBuffer res = new StringBuffer(trimName.length());
        int len = trimName.length();
        int i = 0;
        while (i < len) {
            char ch = trimName.charAt(i);
            if (NameValidator.isValidChar(ch)) {
                res.append(ch);
            }
            ++i;
        }
        return res.toString();
    }

    public static boolean isValidLogicalName(String name, boolean checkSpaces) {
        if (checkSpaces) {
            if (name.startsWith(" ")) {
                return false;
            }
            if (name.endsWith(" ")) {
                return false;
            }
        }
        int len = name.length();
        int i = 0;
        while (i < len) {
            char ch = name.charAt(i);
            if (!NameValidator.isValidChar(ch)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isValidChar(char ch) {
        boolean valid = Character.isLetterOrDigit(ch) || ch == '_';
        return valid;
    }
}

