/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.rcp.e4.starter;

import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolItem;
import org.eclipse.jubula.rc.rcp.e4.namer.E4ComponentNamer;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessor
implements EventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcessor.class);

    @Execute
    protected void hookListener(IEventBroker eventBroker) {
        if (!eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", (EventHandler)this)) {
            LOG.error("Could not subscribe to event broker TOPIC_WIDGET!");
            System.exit(25);
        }
    }

    public void handleEvent(Event event) {
        MUIElement changedModelElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedModelElement instanceof MWindow) {
            MWindow mWindow = (MWindow)changedModelElement;
            if (mWindow.getWidget() != null) {
                this.onModelWindowCreated(mWindow);
            }
        } else if (changedModelElement.getWidget() != null) {
            if (changedModelElement instanceof MPartStack) {
                this.getE4ComponentNamer().onModelPartStackCreated((MPartStack)changedModelElement);
            } else if (changedModelElement instanceof MToolBar) {
                this.getE4ComponentNamer().onModelToolBarCreated((MToolBar)changedModelElement);
            } else if (changedModelElement instanceof MToolItem) {
                this.getE4ComponentNamer().onModelToolItemCreated((MToolItem)changedModelElement);
            } else if (changedModelElement instanceof MPart) {
                this.getE4ComponentNamer().onModelPartCreated((MPart)changedModelElement);
            }
        }
    }

    protected abstract E4ComponentNamer getE4ComponentNamer();

    protected abstract void onModelWindowCreated(MWindow var1);
}

