/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.ui;

import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.ui.internal.ServicesContentProvider;

public class ServiceSelectorComposite
extends Composite {
    private final StructuredViewer viewer;
    private final Link link;
    private IStorageService selectedService;

    public ServiceSelectorComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        ServicesContentProvider contentProvider = new ServicesContentProvider(){

            @Override
            public void serviceAdded(IStorageService service) {
                super.serviceAdded(service);
                ServiceSelectorComposite.this.serviceAdded(service);
            }

            @Override
            public void serviceRemoved(IStorageService service) {
                super.serviceRemoved(service);
                ServiceSelectorComposite.this.serviceRemoved(service);
            }
        };
        this.viewer = this.createViewer(this);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        this.viewer.setInput((Object)IStorageService.Registry.INSTANCE);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServiceSelectorComposite.this.selectedService = ServiceSelectorComposite.this.getViewerSelection();
            }
        });
        this.link = new Link((Composite)this, 0);
        this.link.setText("<a>Configure</a>");
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStorageService service = ServiceSelectorComposite.this.getViewerSelection();
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)ServiceSelectorComposite.this.getShell(), (String)"org.eclipse.userstorage.ui.PreferencePage", null, (Object)service);
                dialog.open();
            }
        });
    }

    public final IStorageService getSelectedService() {
        return this.selectedService;
    }

    public final void setSelectedService(IStorageService service) {
        if (service != this.selectedService) {
            this.selectedService = service;
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)service));
        }
    }

    public boolean setFocus() {
        return this.viewer.getControl().setFocus();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.viewer.getControl().setEnabled(enabled);
        this.link.setEnabled(enabled);
    }

    protected void serviceAdded(IStorageService service) {
    }

    protected void serviceRemoved(IStorageService service) {
    }

    protected StructuredViewer createViewer(Composite parent) {
        return new ComboViewer(parent, 8);
    }

    private IStorageService getViewerSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return (IStorageService)selection.getFirstElement();
    }

    public static boolean isShowServices() {
        String property = System.getProperty("org.eclipse.userstorage.ui.showServices", "auto");
        if ("auto".equalsIgnoreCase(property)) {
            return IStorageService.Registry.INSTANCE.getServices().length > 1;
        }
        return Boolean.parseBoolean(property);
    }
}

