/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.launching.environments.ExecutionEnvironmentDescription;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.launch.Equinox;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ResolverError;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateHelper;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.api.tools.internal.AnyValue;
import org.eclipse.pde.api.tools.internal.ApiBaselineManager;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.builder.ApiAnalysisBuilder;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.model.BundleComponent;
import org.eclipse.pde.api.tools.internal.model.ProjectComponent;
import org.eclipse.pde.api.tools.internal.model.SystemLibraryApiComponent;
import org.eclipse.pde.api.tools.internal.model.WorkspaceBaseline;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.eclipse.pde.internal.core.BuildDependencyCollector;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.osgi.framework.Version;

public class ApiBaseline
extends ApiElement
implements IApiBaseline,
IVMInstallChangedListener {
    private static final IApiComponent[] EMPTY_COMPONENTS = new IApiComponent[0];
    private volatile State fState;
    private String fExecutionEnvironment;
    private final List<IApiComponent> fSystemLibraryComponentList;
    private boolean fAutoResolve = true;
    private String fLocation;
    private IStatus fEEStatus = null;
    private final AnyValue ANY_VALUE = new AnyValue("*");
    private final Map<String, Map<IApiComponent, IApiComponent[]>> fComponentsProvidingPackageCache = new ConcurrentHashMap<String, Map<IApiComponent, IApiComponent[]>>(8);
    private final Map<String, IApiComponent> fComponentsById;
    private final Map<String, Set<IApiComponent>> fAllComponentsById;
    private final Map<String, IApiComponent> fComponentsByProjectNames;
    private volatile Set<String> fSystemPackageNames;
    private volatile IVMInstall fVMBinding;
    private volatile boolean disposed;
    private volatile boolean restored;

    public ApiBaseline(String name) {
        super(null, 4, name);
        this.fSystemLibraryComponentList = new CopyOnWriteArrayList<IApiComponent>();
        this.fComponentsById = new ConcurrentHashMap<String, IApiComponent>();
        this.fAllComponentsById = new ConcurrentHashMap<String, Set<IApiComponent>>();
        this.fComponentsByProjectNames = new ConcurrentHashMap<String, IApiComponent>();
        this.fEEStatus = Status.error((String)CoreMessages.ApiBaseline_0);
    }

    public ApiBaseline(String name, ExecutionEnvironmentDescription ee, String location) throws CoreException {
        this(name);
        if (ee != null) {
            this.fAutoResolve = false;
            this.initialize(ee);
            this.fEEStatus = Status.OK_STATUS;
        }
        this.fLocation = location;
    }

    private void initialize(ExecutionEnvironmentDescription ee) throws CoreException {
        String environmentId = ee.getProperty("-Dee.class.library.level");
        Properties properties = ApiBaseline.getJavaProfileProperties(environmentId);
        if (properties == null && ApiPlugin.isRunningInFramework()) {
            IExecutionEnvironment ev = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(environmentId);
            properties = ev.getProfileProperties();
        }
        if (properties == null) {
            this.abort("Unknown execution environment: " + environmentId, null);
        } else {
            this.initialize(properties, ee);
        }
    }

    public static Properties getJavaProfileProperties(String ee) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = Equinox.class.getResourceAsStream("/" + ee.replace('/', '_') + ".profile");){
                if (is != null) {
                    Properties profile = new Properties();
                    profile.load(is);
                    return profile;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ApiPlugin.log(e);
        }
        return null;
    }

    private synchronized void initialize(Properties profile, ExecutionEnvironmentDescription description) throws CoreException {
        String environmentId = description.getProperty("-Dee.class.library.level");
        IExecutionEnvironment ee = JavaRuntime.getExecutionEnvironmentsManager().getEnvironment(environmentId);
        String value = TargetPlatformHelper.getSystemPackages((IExecutionEnvironment)ee, (Properties)profile);
        String[] systemPackages = null;
        if (value != null) {
            systemPackages = value.split(",");
        }
        if (!(this instanceof WorkspaceBaseline)) {
            Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
            if (value != null) {
                ((Dictionary)dictionary).put("org.osgi.framework.system.packages", value);
            }
            if ((value = profile.getProperty("org.osgi.framework.executionenvironment")) != null) {
                ((Dictionary)dictionary).put("org.osgi.framework.executionenvironment", value);
            }
            this.fExecutionEnvironment = profile.getProperty("osgi.java.profile.name");
            if (this.fExecutionEnvironment == null) {
                String id;
                this.fExecutionEnvironment = id = description.getProperty("-Dee.class.library.level");
                if (this.fExecutionEnvironment == null) {
                    this.abort("Profile file missing 'osgi.java.profile.name'", null);
                }
            }
            ((Dictionary)dictionary).put("osgi.os", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.arch", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.ws", this.ANY_VALUE);
            ((Dictionary)dictionary).put("osgi.nl", this.ANY_VALUE);
            this.getState().setPlatformProperties(dictionary);
        }
        for (IApiComponent comp : this.fSystemLibraryComponentList) {
            this.fComponentsById.remove(comp.getSymbolicName());
        }
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
            this.fSystemPackageNames = null;
        }
        this.clearComponentsCache();
        SystemLibraryApiComponent fSystemLibraryComponent = new SystemLibraryApiComponent(this, description, systemPackages);
        this.addComponent(fSystemLibraryComponent);
        this.fSystemLibraryComponentList.add(fSystemLibraryComponent);
    }

    private void clearComponentsCache() {
        this.fComponentsProvidingPackageCache.clear();
    }

    protected void addComponent(IApiComponent component) {
        if (this.isDisposed() || component == null) {
            return;
        }
        IApiComponent comp = this.fComponentsById.get(component.getSymbolicName());
        if (comp != null) {
            if (this.fAllComponentsById.containsKey(component.getSymbolicName())) {
                allComponents = this.fAllComponentsById.get(component.getSymbolicName());
                if (!allComponents.contains(component)) {
                    allComponents.add(component);
                }
            } else {
                allComponents = new TreeSet<IApiComponent>((comp1, comp2) -> {
                    if (comp2.getVersion().equals(comp1.getVersion())) {
                        if (comp2.getVersion().contains("JavaSE")) {
                            ApiPlugin.logInfoMessage("Multiple locations for the same Java = " + comp1.getLocation() + comp2.getLocation());
                        }
                        return 0;
                    }
                    return new Version(comp2.getVersion()).compareTo(new Version(comp1.getVersion()));
                });
                ((TreeSet)allComponents).add(comp);
                ((TreeSet)allComponents).add(component);
                this.fAllComponentsById.put(component.getSymbolicName(), allComponents);
            }
        }
        this.fComponentsById.put(component.getSymbolicName(), component);
        if (component instanceof ProjectComponent) {
            ProjectComponent projectApiComponent = (ProjectComponent)component;
            this.fComponentsByProjectNames.put(projectApiComponent.getJavaProject().getProject().getName(), component);
        }
    }

    @Override
    public void addApiComponents(IApiComponent[] components) throws CoreException {
        if (this.isDisposed()) {
            return;
        }
        HashSet<String> ees = new HashSet<String>();
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent apiComponent = iApiComponentArray[n2];
            BundleComponent component = (BundleComponent)apiComponent;
            if (!component.isSourceComponent()) {
                BundleDescription description = component.getBundleDescription();
                this.getState().addBundle(description);
                this.addComponent(component);
                ees.addAll(component.getExecutionEnvironments());
            }
            ++n2;
        }
        this.resolveSystemLibrary(ees);
        this.getState().resolve();
    }

    protected void resolveSystemLibrary(HashSet<String> ees) {
        if (ApiPlugin.isRunningInFramework() && this.fAutoResolve) {
            IStatus error = null;
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            TreeMap<IVMInstall, Set> vmToEEs = new TreeMap<IVMInstall, Set>(new VmVersionComparator());
            for (String ee : ees) {
                IVMInstall[] compatibleVMs;
                IExecutionEnvironment environment = manager.getEnvironment(ee);
                if (environment == null) continue;
                IVMInstall[] iVMInstallArray = compatibleVMs = environment.getCompatibleVMs();
                int n = compatibleVMs.length;
                int n2 = 0;
                while (n2 < n) {
                    IVMInstall vm = iVMInstallArray[n2];
                    vmToEEs.computeIfAbsent(vm, m -> new HashSet()).add(ee);
                    ++n2;
                }
            }
            ArrayList allVMInstalls = new ArrayList(vmToEEs.keySet());
            for (IVMInstall vmInstall : allVMInstalls) {
                try {
                    ExecutionEnvironmentDescription ee = Util.createEEDescription(vmInstall);
                    this.initialize(ee);
                    this.fVMBinding = vmInstall;
                    break;
                }
                catch (IOException | CoreException e) {
                    error = Status.error((String)CoreMessages.ApiBaseline_2, (Throwable)e);
                }
            }
            if (this.fVMBinding != null) {
                JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
            } else {
                error = Status.error((String)CoreMessages.ApiBaseline_6);
            }
            if (error == null) {
                HashSet<String> missing = new HashSet<String>(ees);
                HashSet covered = new HashSet();
                for (IVMInstall fit : allVMInstalls) {
                    covered.addAll((Collection)vmToEEs.get(fit));
                }
                missing.removeAll(covered);
                if (missing.isEmpty()) {
                    this.fEEStatus = Status.OK_STATUS;
                } else {
                    MultiStatus multi = new MultiStatus("org.eclipse.pde.api.tools", 0, CoreMessages.ApiBaseline_4, null);
                    for (String id : missing) {
                        multi.add(Status.warning((String)MessageFormat.format(CoreMessages.ApiBaseline_5, id)));
                    }
                    this.fEEStatus = multi;
                }
            } else {
                this.fEEStatus = error;
            }
        }
    }

    public boolean peekInfos() {
        return !this.fComponentsById.isEmpty();
    }

    @Override
    public IApiComponent[] getApiComponents() {
        this.loadBaselineInfos();
        return this.getAlreadyLoadedApiComponents();
    }

    protected IApiComponent[] getAlreadyLoadedApiComponents() {
        if (this.disposed) {
            return EMPTY_COMPONENTS;
        }
        Collection<IApiComponent> values = this.fComponentsById.values();
        return values.toArray(new IApiComponent[values.size()]);
    }

    @Override
    public IApiComponent[] resolvePackage(IApiComponent sourceComponent, String packageName) throws CoreException {
        if (this.disposed) {
            IStatus error = Status.error((String)("Trying to use disposed baseline " + this.getName()));
            throw new CoreException(error);
        }
        Map componentsForPackage = this.fComponentsProvidingPackageCache.computeIfAbsent(packageName, x -> new ConcurrentHashMap(8));
        IApiComponent[] cachedComponents = (IApiComponent[])componentsForPackage.get(sourceComponent);
        if (cachedComponents != null && cachedComponents.length > 0) {
            return cachedComponents;
        }
        if (sourceComponent != null) {
            ArrayList<IApiComponent> componentsList = new ArrayList<IApiComponent>();
            this.resolvePackage0(sourceComponent, packageName, componentsList);
            if (componentsList.size() != 0) {
                cachedComponents = new IApiComponent[componentsList.size()];
                componentsList.toArray(cachedComponents);
            }
        }
        if (this.isSystemPackage(packageName) && !this.fSystemLibraryComponentList.isEmpty()) {
            if (cachedComponents == null) {
                cachedComponents = this.fSystemLibraryComponentList.toArray(new IApiComponent[0]);
            } else {
                ArrayList<IApiComponent> list = new ArrayList<IApiComponent>(Arrays.asList(cachedComponents));
                list.addAll(this.fSystemLibraryComponentList);
                cachedComponents = list.toArray(new IApiComponent[0]);
            }
        }
        if (cachedComponents == null) {
            cachedComponents = EMPTY_COMPONENTS;
        }
        if (cachedComponents.length == 0) {
            return EMPTY_COMPONENTS;
        }
        componentsForPackage.put(sourceComponent, cachedComponents);
        return cachedComponents;
    }

    private void resolvePackage0(IApiComponent component, String packageName, List<IApiComponent> componentsList) throws CoreException {
        BundleDescription bundle;
        if (component instanceof BundleComponent && (bundle = ((BundleComponent)component).getBundleDescription()) != null) {
            String[] packageNames;
            int index;
            ExportPackageDescription[] visiblePackages;
            StateHelper helper = this.getState().getStateHelper();
            ExportPackageDescription[] exportPackageDescriptionArray = visiblePackages = helper.getVisiblePackages(bundle);
            int n = visiblePackages.length;
            int n2 = 0;
            while (n2 < n) {
                BundleDescription bundleDescription;
                IApiComponent exporter;
                ExportPackageDescription pkg = exportPackageDescriptionArray[n2];
                String pkgName = pkg.getName();
                if (pkgName.equals(".")) {
                    pkgName = "";
                }
                if (packageName.equals(pkgName) && (exporter = this.getApiComponent((bundleDescription = pkg.getExporter()).getSymbolicName())) != null) {
                    componentsList.add(exporter);
                }
                ++n2;
            }
            if (component.isFragment()) {
                BundleDescription[] hosts;
                HostSpecification host = bundle.getHost();
                BundleDescription[] bundleDescriptionArray = hosts = host.getHosts();
                int n3 = hosts.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleDescription currentHost = bundleDescriptionArray[n4];
                    IApiComponent apiComponent = component.getBaseline().getApiComponent(currentHost.getName());
                    if (apiComponent != null) {
                        this.resolvePackage0(apiComponent, packageName, componentsList);
                    }
                    ++n4;
                }
            }
            if ((index = Arrays.binarySearch(packageNames = component.getPackageNames(), packageName, null)) >= 0) {
                componentsList.add(component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSystemPackage(String packageName) {
        if (packageName.startsWith("java.")) {
            return true;
        }
        Set<String> systemPackageNames = this.fSystemPackageNames;
        if (systemPackageNames == null) {
            ApiBaseline apiBaseline = this;
            synchronized (apiBaseline) {
                ExportPackageDescription[] systemPackages = this.getState().getSystemPackages();
                systemPackageNames = new HashSet<String>(systemPackages.length);
                ExportPackageDescription[] exportPackageDescriptionArray = systemPackages;
                int n = systemPackages.length;
                int n2 = 0;
                while (n2 < n) {
                    ExportPackageDescription systemPackage = exportPackageDescriptionArray[n2];
                    systemPackageNames.add(systemPackage.getName());
                    ++n2;
                }
                this.fSystemPackageNames = systemPackageNames;
            }
        }
        return systemPackageNames.contains(packageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        if (this.disposed) {
            return this.fState;
        }
        if (this.fState == null) {
            ApiBaseline apiBaseline = this;
            synchronized (apiBaseline) {
                this.fState = StateObjectFactory.defaultFactory.createState(true);
            }
        }
        return this.fState;
    }

    @Override
    public IApiComponent getApiComponent(String id) {
        this.loadBaselineInfos();
        if (this.disposed) {
            return null;
        }
        return this.fComponentsById.get(id);
    }

    @Override
    public Set<IApiComponent> getAllApiComponents(String id) {
        this.loadBaselineInfos();
        if (this.disposed) {
            return Collections.emptySet();
        }
        Set<IApiComponent> set = this.fAllComponentsById.get(id);
        if (set == null) {
            return Collections.emptySet();
        }
        return set;
    }

    @Override
    public String getExecutionEnvironment() {
        return this.fExecutionEnvironment;
    }

    private void loadBaselineInfos() {
        if (this.disposed || this.restored) {
            return;
        }
        ApiBaselineManager manager = ApiBaselineManager.getManager();
        if (!this.fComponentsById.isEmpty() && manager.isBaselineLoaded(this)) {
            return;
        }
        if (this.disposed || this.restored) {
            return;
        }
        try {
            manager.loadBaselineInfos(this);
        }
        catch (CoreException ce) {
            ApiPlugin.log(ce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreFrom(InputStream stream) throws CoreException {
        if (this.disposed || this.restored) {
            return;
        }
        IApiComponent[] components = ApiBaselineManager.getManager().readBaselineComponents(this, stream);
        if (components == null) {
            this.restored = true;
            return;
        }
        ApiBaseline apiBaseline = this;
        synchronized (apiBaseline) {
            if (this.disposed || this.restored) {
                IApiComponent[] iApiComponentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiComponent component = iApiComponentArray[n2];
                    component.dispose();
                    ++n2;
                }
                return;
            }
            this.addApiComponents(components);
            this.restored = true;
        }
    }

    public ResolverError[] getErrors() {
        BundleDescription[] bundles;
        ArrayList<ResolverError> errs = null;
        BundleDescription[] bundleDescriptionArray = bundles = this.getState().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            ResolverError[] errors;
            BundleDescription bundle = bundleDescriptionArray[n2];
            ResolverError[] resolverErrorArray = errors = this.getState().getResolverErrors(bundle);
            int n3 = errors.length;
            int n4 = 0;
            while (n4 < n3) {
                ResolverError error = resolverErrorArray[n4];
                if (errs == null) {
                    errs = new ArrayList<ResolverError>();
                }
                errs.add(error);
                ++n4;
            }
            ++n2;
        }
        if (errs != null) {
            return errs.toArray(new ResolverError[errs.size()]);
        }
        return null;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof IApiBaseline) {
            IApiBaseline baseline = (IApiBaseline)obj;
            return this.getName().equals(baseline.getName());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public void dispose() {
        if (this.fState == null) {
            return;
        }
        this.doDispose();
        this.fState = null;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDispose() {
        IApiComponent[] components;
        if (this.disposed) {
            return;
        }
        ApiBaseline apiBaseline = this;
        synchronized (apiBaseline) {
            components = this.getAlreadyLoadedApiComponents();
            this.disposed = true;
        }
        this.clearCachedElements();
        if (ApiPlugin.isRunningInFramework()) {
            JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
        }
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            component2.dispose();
            ++n2;
        }
        this.clearComponentsCache();
        this.fComponentsById.clear();
        this.fAllComponentsById.clear();
        this.fComponentsByProjectNames.clear();
        if (this.fSystemPackageNames != null) {
            this.fSystemPackageNames.clear();
        }
        for (IApiComponent iApiComponent : this.fSystemLibraryComponentList) {
            iApiComponent.dispose();
        }
        this.fSystemLibraryComponentList.clear();
    }

    @Override
    public void close() throws CoreException {
        IApiComponent[] components;
        this.clearCachedElements();
        IApiComponent[] iApiComponentArray = components = this.getApiComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component2 = iApiComponentArray[n2];
            component2.close();
            ++n2;
        }
    }

    void clearCachedElements() {
        ApiModelCache.getCache().removeElementInfo(this);
    }

    @Override
    public IApiComponent[] getPrerequisiteComponents(IApiComponent[] components) throws CoreException {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>(components.length);
        IApiComponent[] iApiComponentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            IApiComponent component = iApiComponentArray[n2];
            if (component instanceof BundleComponent) {
                BundleComponent bundleComponent = (BundleComponent)component;
                bundles.add(bundleComponent.getBundleDescription());
            }
            ++n2;
        }
        Collection dependencies = BuildDependencyCollector.collectBuildRelevantDependencies(bundles);
        return (IApiComponent[])dependencies.stream().map(BundleDescription::getSymbolicName).map(id -> this.getApiComponent((String)id)).filter(Objects::nonNull).toArray(IApiComponent[]::new);
    }

    public void clearPackage(String packageName) {
        this.fComponentsProvidingPackageCache.remove(packageName);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public IStatus getExecutionEnvironmentStatus() {
        return this.fEEStatus;
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    public void vmAdded(IVMInstall vm) {
        if (!(vm instanceof VMStandin)) {
            this.rebindVM();
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property;
        if (!(event.getSource() instanceof VMStandin) && (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property = event.getProperty()) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property))) {
            this.rebindVM();
        }
    }

    private void rebindVM() {
        final IVMInstall originalVm = this.fVMBinding;
        Job.getJobManager().cancel(ApiAnalysisBuilder.ApiAnalysisJob.class);
        Job job = new Job("Rebinding JVM"){

            public IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled() || ApiBaseline.this.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    Job.getJobManager().join(ApiAnalysisBuilder.ApiAnalysisJob.class, monitor);
                }
                catch (InterruptedException | OperationCanceledException e) {
                    ApiPlugin.log("Interrupted while rebinding JVM", e);
                    return Status.CANCEL_STATUS;
                }
                if (originalVm != ApiBaseline.this.fVMBinding) {
                    return Status.CANCEL_STATUS;
                }
                ApiBaseline.this.fVMBinding = null;
                IApiComponent[] components = ApiBaseline.this.getApiComponents();
                HashSet<String> ees = new HashSet<String>();
                IApiComponent[] iApiComponentArray = components;
                int n = components.length;
                int n2 = 0;
                while (n2 < n) {
                    IApiComponent component = iApiComponentArray[n2];
                    try {
                        ees.addAll(component.getExecutionEnvironments());
                    }
                    catch (CoreException e) {
                        ApiPlugin.log("Error reading execution environment from " + String.valueOf(component), e);
                    }
                    ++n2;
                }
                ApiBaseline.this.resolveSystemLibrary(ees);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return super.belongsTo(family) || family == ApiBaseline.class;
            }
        };
        job.setRule((ISchedulingRule)new ApiBaselineManager.ApiBaselineManagerRule());
        job.setSystem(true);
        job.schedule();
    }

    public void vmRemoved(IVMInstall vm) {
        if (vm.equals(this.fVMBinding)) {
            this.rebindVM();
        }
    }

    @Override
    public String getLocation() {
        return this.fLocation;
    }

    @Override
    public void setLocation(String location) {
        this.fLocation = location;
    }

    @Override
    public IApiComponent getApiComponent(IProject project) {
        this.loadBaselineInfos();
        if (this.disposed) {
            return null;
        }
        return this.fComponentsByProjectNames.get(project.getName());
    }

    static final class VmVersionComparator
    implements Comparator<IVMInstall> {
        private static final String UNKNOWN_VERSION = "UNKNOWN";
        private static final Integer UNKNOWN_VERSION_ORDINAL = -1;
        private static final Map<String, Integer> KNOWN_VERSIONS_MAP;

        static {
            List allVersions = JavaCore.getAllVersions();
            KNOWN_VERSIONS_MAP = new HashMap<String, Integer>(allVersions.size() + 1);
            int i = 0;
            while (i < allVersions.size()) {
                KNOWN_VERSIONS_MAP.put((String)allVersions.get(i), i);
                ++i;
            }
            KNOWN_VERSIONS_MAP.put(UNKNOWN_VERSION, UNKNOWN_VERSION_ORDINAL);
        }

        VmVersionComparator() {
        }

        @Override
        public int compare(IVMInstall o1, IVMInstall o2) {
            String vmVersion1 = VmVersionComparator.getSimpleVmVersion(o1);
            String vmVersion2 = VmVersionComparator.getSimpleVmVersion(o2);
            Integer ordinal1 = VmVersionComparator.getVmOrdinal(vmVersion1);
            Integer ordinal2 = VmVersionComparator.getVmOrdinal(vmVersion2);
            return ordinal2.compareTo(ordinal1);
        }

        /*
         * WARNING - void declaration
         */
        private static String getSimpleVmVersion(IVMInstall vm) {
            void vm2;
            if (!(vm instanceof IVMInstall2)) {
                return UNKNOWN_VERSION;
            }
            IVMInstall2 iVMInstall2 = (IVMInstall2)vm;
            String javaVersion = vm2.getJavaVersion();
            if (javaVersion == null) {
                return UNKNOWN_VERSION;
            }
            if ((javaVersion = javaVersion.strip()).length() > 2 && javaVersion.startsWith("1.")) {
                javaVersion = javaVersion.substring(0, 3);
            } else {
                int firstDot = javaVersion.indexOf(".");
                if (firstDot > 0) {
                    javaVersion = javaVersion.substring(0, firstDot);
                }
            }
            return javaVersion;
        }

        private static Integer getVmOrdinal(String vmVersion) {
            Integer value = KNOWN_VERSIONS_MAP.get(vmVersion);
            if (value == null) {
                try {
                    return Integer.valueOf(vmVersion);
                }
                catch (Exception e) {
                    return UNKNOWN_VERSION_ORDINAL;
                }
            }
            return value;
        }
    }
}

