/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.internal.runtime.XmlProcessorFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.touchpoint.eclipse.query.OSGiBundleQuery;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IUBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "InstallableUnit";
    private static final String FEATURE_ID_SUFFIX = ".feature.group";
    public static final int INCLUDE_REQUIRED = 1;
    public static final int INCLUDE_ALL_ENVIRONMENTS = 2;
    public static final int INCLUDE_SOURCE = 4;
    public static final int INCLUDE_CONFIGURE_PHASE = 8;
    public static final int FOLLOW_REPOSITORY_REFERENCES = 16;
    private final Set<UnitDeclaration> fIUs;
    private Map<IInstallableUnit, UnitDeclaration> fUnits = Map.of();
    private final List<URI> fRepos;
    private final int fFlags;
    private P2TargetUtils fSynchronizer;
    private ITargetDefinition fTarget;
    private static final Comparator<UnitDeclaration> BY_ID_THEN_VERSION = Comparator.comparing(UnitDeclaration::id).thenComparing(u -> !u.hasSingleVersion()).thenComparing(unit -> unit.version().getMinimum()).thenComparing(unit -> unit.version().getMaximum());

    IUBundleContainer(List<UnitDeclaration> units, List<URI> repositories, int resolutionFlags) {
        this.fIUs = new LinkedHashSet<UnitDeclaration>(units);
        this.fFlags = resolutionFlags;
        this.fRepos = List.copyOf(repositories);
    }

    @Override
    public String getLocation(boolean resolve) throws CoreException {
        return P2TargetUtils.BUNDLE_POOL.toOSString();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected TargetFeature[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        this.fTarget = definition;
        if (!this.isResolved()) {
            this.fSynchronizer.synchronize(definition, monitor);
        }
        return this.fFeatures;
    }

    public ITargetDefinition getTarget() {
        return this.isResolved() ? this.fTarget : null;
    }

    private void cacheFeatures(ITargetDefinition target) throws CoreException {
        HashSet<NameVersionDescriptor> features = new HashSet<NameVersionDescriptor>();
        IQueryResult queryResult = this.fSynchronizer.getProfile().query(QueryUtil.createIUAnyQuery(), null);
        if (queryResult.isEmpty()) {
            return;
        }
        for (IInstallableUnit unit : queryResult) {
            String id = unit.getId();
            if (!id.endsWith(FEATURE_ID_SUFFIX)) continue;
            id = id.substring(0, id.length() - FEATURE_ID_SUFFIX.length());
            String version = unit.getVersion().toString();
            features.add(new NameVersionDescriptor(id, version, "feature"));
        }
        if (features.isEmpty()) {
            return;
        }
        TargetFeature[] allFeatures = ((TargetDefinition)target).resolveFeatures(this.getLocation(false), (IProgressMonitor)new NullProgressMonitor());
        ArrayList<TargetFeature> result = new ArrayList<TargetFeature>();
        TargetFeature[] targetFeatureArray = allFeatures;
        int n = allFeatures.length;
        int n2 = 0;
        while (n2 < n) {
            TargetFeature allFeature = targetFeatureArray[n2];
            NameVersionDescriptor candidate = new NameVersionDescriptor(allFeature.getId(), allFeature.getVersion(), "feature");
            if (features.contains(candidate)) {
                result.add(allFeature);
            }
            ++n2;
        }
        this.fFeatures = (TargetFeature[])result.toArray(TargetFeature[]::new);
    }

    @Override
    protected TargetBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        this.fTarget = definition;
        if (!this.isResolved()) {
            this.fSynchronizer.synchronize(definition, monitor);
        }
        return this.fBundles;
    }

    private void cacheIUs() throws CoreException {
        IProfile profile = this.fSynchronizer.getProfile();
        LinkedHashMap result = new LinkedHashMap();
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories);
        for (UnitDeclaration unit : this.fIUs) {
            this.queryIU((IQueryable<IInstallableUnit>)profile, unit, status).ifPresent(iu -> {
                UnitDeclaration unitDeclaration2 = result.put(iu, unit);
            });
        }
        if (!status.isOK()) {
            this.fResolutionStatus = status;
            throw new CoreException((IStatus)status);
        }
        this.fUnits = Collections.unmodifiableMap(result);
    }

    private void cacheBundles(ITargetDefinition target) throws CoreException {
        boolean onlyStrict = !this.fSynchronizer.getIncludeAllRequired();
        IProfile metadata = this.fSynchronizer.getProfile();
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)metadata, new HashMap(), true, false, true, onlyStrict, false);
        IQueryable slice = slicer.slice(this.fUnits.keySet(), (IProgressMonitor)new NullProgressMonitor());
        if (slicer.getStatus().getSeverity() == 4) {
            throw new CoreException((IStatus)slicer.getStatus());
        }
        IFileArtifactRepository artifacts = null;
        try {
            if (P2TargetUtils.fgTargetArtifactRepo.containsKey(target)) {
                artifacts = P2TargetUtils.fgTargetArtifactRepo.get(target);
            } else {
                artifacts = P2TargetUtils.getBundlePool();
                P2TargetUtils.fgTargetArtifactRepo.put(target, artifacts);
            }
        }
        catch (CoreException e) {
            if (PDECore.DEBUG_TARGET_PROFILE) {
                System.out.println("Bundle pool repository could not be loaded");
            }
            this.fBundles = null;
            return;
        }
        Map<BundleInfo, TargetBundle> bundles = this.generateResolvedBundles((IQueryable<IInstallableUnit>)slice, (IQueryable<IInstallableUnit>)metadata, artifacts);
        if (bundles.isEmpty()) {
            if (PDECore.DEBUG_TARGET_PROFILE) {
                System.out.println("Profile does not contain any bundles or artifacts were missing");
            }
            if (slicer.getStatus().getSeverity() == 2) {
                throw new CoreException((IStatus)slicer.getStatus());
            }
            this.fBundles = null;
            return;
        }
        this.fBundles = (TargetBundle[])bundles.values().toArray(TargetBundle[]::new);
    }

    void synchronizerChanged(ITargetDefinition target) {
        try {
            this.cacheIUs();
            this.cacheBundles(target);
            this.cacheFeatures(target);
        }
        catch (CoreException e) {
            PDECore.logException(e, e.getMessage());
            this.fBundles = new TargetBundle[0];
            this.fFeatures = new TargetFeature[0];
            this.fResolutionStatus = e.getStatus();
        }
    }

    public synchronized IUBundleContainer update(Set<String> toUpdate, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IQueryable<IInstallableUnit> source = P2TargetUtils.getQueryableMetadata(this.fRepos, this.isFollowRepositoryReferences(), (IProgressMonitor)progress.split(30));
        boolean updated = false;
        ArrayList<UnitDeclaration> updatedUnits = new ArrayList<UnitDeclaration>(this.fIUs);
        SubMonitor loopProgress = progress.split(70).setWorkRemaining(updatedUnits.size());
        int i = 0;
        while (i < updatedUnits.size()) {
            UnitDeclaration unit = (UnitDeclaration)updatedUnits.get(i);
            if (toUpdate.isEmpty() || toUpdate.contains(unit.id())) {
                IQuery<IInstallableUnit> query = IUBundleContainer.createLatestIUQuery(unit.id());
                Optional<IInstallableUnit> queryResult = IUBundleContainer.queryFirst(source, query, (IProgressMonitor)loopProgress.split(1));
                Version updatedVersion = queryResult.map(IVersionedId::getVersion).orElseThrow(() -> new CoreException(Status.error((String)NLS.bind((String)Messages.IUBundleContainer_1, (Object)unit))));
                if (!unit.hasSingleVersion()) {
                    updated = true;
                } else {
                    Version declaredVersion = unit.getSingleVersion();
                    if (!updatedVersion.equals(declaredVersion)) {
                        updated = true;
                        if (!declaredVersion.equals(Version.emptyVersion)) {
                            updatedUnits.set(i, UnitDeclaration.create(unit.id(), updatedVersion));
                        }
                    }
                }
            }
            ++i;
        }
        if (updated) {
            return new IUBundleContainer(updatedUnits, this.fRepos, this.fFlags);
        }
        return null;
    }

    private Map<BundleInfo, TargetBundle> generateResolvedBundles(IQueryable<IInstallableUnit> source, IQueryable<IInstallableUnit> metadata, IFileArtifactRepository artifacts) throws CoreException {
        OSGiBundleQuery query = new OSGiBundleQuery();
        IQueryResult queryResult = source.query((IQuery)query, null);
        LinkedHashMap<BundleInfo, TargetBundle> bundles = new LinkedHashMap<BundleInfo, TargetBundle>();
        for (IInstallableUnit unit : queryResult) {
            IQuery sourceQuery;
            Optional<IInstallableUnit> result;
            this.generateBundle(unit, artifacts, bundles);
            if (!this.getIncludeSource() || !(result = IUBundleContainer.queryFirst(metadata, sourceQuery = QueryUtil.createIUQuery((String)(unit.getId() + ".source"), (Version)unit.getVersion()), null)).isPresent()) continue;
            this.generateBundle(result.get(), artifacts, bundles);
        }
        return bundles;
    }

    private void generateBundle(IInstallableUnit unit, IFileArtifactRepository repo, Map<BundleInfo, TargetBundle> bundles) throws CoreException {
        Collection artifacts = unit.getArtifacts();
        for (IArtifactKey artifactKey : artifacts) {
            File file = null;
            Map<IFileArtifactRepository, File> mapRepoFile = P2TargetUtils.fgArtifactKeyRepoFile.get(artifactKey);
            if (mapRepoFile != null) {
                file = mapRepoFile.get(repo);
            }
            if (file == null && (file = repo.getArtifactFile(artifactKey)) != null) {
                ConcurrentHashMap<IFileArtifactRepository, File> repoFile = new ConcurrentHashMap<IFileArtifactRepository, File>();
                repoFile.put(repo, file);
                P2TargetUtils.fgArtifactKeyRepoFile.putIfAbsent(artifactKey, repoFile);
            }
            if (file == null) continue;
            TargetBundle bundle = new TargetBundle(file);
            bundles.put(bundle.getBundleInfo(), bundle);
        }
    }

    public int hashCode() {
        return Objects.hash(this.getIncludeAllRequired(), this.getIncludeAllEnvironments(), this.getIncludeSource(), this.getIncludeConfigurePhase(), this.fIUs, this.fRepos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IUBundleContainer) {
            IUBundleContainer other = (IUBundleContainer)obj;
            if (this.getIncludeAllRequired() == other.getIncludeAllRequired() && this.getIncludeAllEnvironments() == other.getIncludeAllEnvironments() && this.getIncludeSource() == other.getIncludeSource() && this.getIncludeConfigurePhase() == other.getIncludeConfigurePhase() && this.fIUs.equals(other.fIUs) && this.fRepos.equals(other.fRepos)) {
                return true;
            }
        }
        return false;
    }

    public List<URI> getRepositories() {
        return this.fRepos;
    }

    public synchronized void removeInstallableUnit(IInstallableUnit unit) {
        UnitDeclaration description = this.fUnits.get(unit);
        if (description != null) {
            this.fIUs.remove(description);
        }
        this.clearResolutionStatus();
    }

    public boolean getIncludeAllRequired() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 1) != 0;
        }
        return this.fSynchronizer.getIncludeAllRequired();
    }

    public boolean getIncludeAllEnvironments() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 2) != 0;
        }
        return this.fSynchronizer.getIncludeAllEnvironments();
    }

    public boolean getIncludeSource() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 4) != 0;
        }
        return this.fSynchronizer.getIncludeSource();
    }

    public boolean getIncludeConfigurePhase() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 8) != 0;
        }
        return this.fSynchronizer.getIncludeConfigurePhase();
    }

    public boolean isFollowRepositoryReferences() {
        if (this.fSynchronizer == null) {
            return (this.fFlags & 0x10) != 0;
        }
        return this.fSynchronizer.isFollowRepositoryReferences();
    }

    public Collection<IInstallableUnit> getInstallableUnits() {
        return this.fUnits.keySet();
    }

    public Map<IInstallableUnit, String> getInstallableUnitSpecifications() {
        return this.fUnits.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> {
            UnitDeclaration u = (UnitDeclaration)e.getValue();
            if (u.hasEmptyVersion() || !u.hasSingleVersion()) {
                return u.version().toString();
            }
            return "";
        }));
    }

    Collection<UnitDeclaration> getDeclaredUnits() {
        return Collections.unmodifiableSet(this.fIUs);
    }

    P2TargetUtils getSynchronizer(ITargetDefinition definition) {
        if (this.fSynchronizer != null) {
            return this.fSynchronizer;
        }
        if (definition == null) {
            return null;
        }
        this.fSynchronizer = P2TargetUtils.getSynchronizer(definition);
        return this.fSynchronizer;
    }

    void setSynchronizer(P2TargetUtils value) {
        this.fSynchronizer = value;
    }

    @Override
    protected void associateWithTarget(ITargetDefinition target) {
        super.associateWithTarget(target);
        this.fSynchronizer = this.getSynchronizer(target);
        this.fSynchronizer.setIncludeAllRequired((this.fFlags & 1) == 1);
        this.fSynchronizer.setIncludeAllEnvironments((this.fFlags & 2) == 2);
        this.fSynchronizer.setIncludeSource((this.fFlags & 4) == 4);
        this.fSynchronizer.setIncludeConfigurePhase((this.fFlags & 8) == 8);
        this.fSynchronizer.setFollowRepositoryReferences((this.fFlags & 0x10) == 16);
    }

    @Override
    public String serialize() {
        Document document;
        try {
            Document d;
            document = d = XmlProcessorFactory.newDocumentWithErrorOnDOCTYPE();
        }
        catch (Exception e) {
            PDECore.log(e);
            return null;
        }
        Element containerElement = document.createElement("location");
        containerElement.setAttribute("type", this.getType());
        containerElement.setAttribute("includeMode", this.getIncludeAllRequired() ? "planner" : "slicer");
        containerElement.setAttribute("includeAllPlatforms", Boolean.toString(this.getIncludeAllEnvironments()));
        containerElement.setAttribute("includeSource", Boolean.toString(this.getIncludeSource()));
        containerElement.setAttribute("includeConfigurePhase", Boolean.toString(this.getIncludeConfigurePhase()));
        boolean includeReferences = this.isFollowRepositoryReferences();
        if (includeReferences) {
            containerElement.removeAttribute("followRepositoryReferences");
        } else {
            containerElement.setAttribute("followRepositoryReferences", Boolean.toString(includeReferences));
        }
        ArrayList<URI> repositories = new ArrayList<URI>(this.getRepositories());
        repositories.sort(null);
        for (URI repository : repositories) {
            Element repo = document.createElement("repository");
            repo.setAttribute("location", repository.toASCIIString());
            containerElement.appendChild(repo);
        }
        this.fIUs.stream().sorted(BY_ID_THEN_VERSION).forEach(iu -> {
            Element unit = document.createElement("unit");
            unit.setAttribute("id", iu.id());
            if (iu.hasVersion()) {
                unit.setAttribute("version", iu.versionString());
            }
            containerElement.appendChild(unit);
        });
        try {
            document.appendChild(containerElement);
            StreamResult result = new StreamResult(new StringWriter());
            Transformer transformer = XmlProcessorFactory.createTransformerFactoryWithErrorOnDOCTYPE().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(document), result);
            return result.getWriter().toString();
        }
        catch (TransformerException ex) {
            return null;
        }
    }

    Map<IInstallableUnit, Set<VersionRange>> getRootIUs(IProgressMonitor monitor) throws CoreException {
        IQueryable<IInstallableUnit> repos = P2TargetUtils.getQueryableMetadata(this.getRepositories(), this.isFollowRepositoryReferences(), monitor);
        MultiStatus status = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories);
        HashMap<IInstallableUnit, Set<VersionRange>> result = new HashMap<IInstallableUnit, Set<VersionRange>>();
        for (UnitDeclaration iu : this.fIUs) {
            this.queryIU(repos, iu, status).ifPresent(u -> {
                boolean bl = result.computeIfAbsent((IInstallableUnit)u, __ -> new HashSet(1)).add(iu.version());
            });
        }
        if (!status.isOK()) {
            this.fResolutionStatus = status;
            throw new CoreException((IStatus)status);
        }
        return result;
    }

    private Optional<IInstallableUnit> queryIU(IQueryable<IInstallableUnit> queryable, UnitDeclaration iu, MultiStatus status) {
        Optional<IInstallableUnit> queryResult = IUBundleContainer.queryFirst(queryable, iu.createIUQuery(), null);
        if (queryResult.isEmpty()) {
            status.add(Status.error((String)NLS.bind((String)Messages.IUBundleContainer_1, (Object)iu)));
        }
        return queryResult;
    }

    static <T> Optional<T> queryFirst(IQueryable<T> queryable, IQuery<T> query, IProgressMonitor monitor) {
        return queryable.query(query, monitor).stream().findFirst();
    }

    private static IQuery<IInstallableUnit> createLatestIUQuery(String id) {
        return QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)id));
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isInstance(this.fSynchronizer)) {
            return adapter.cast(this.fSynchronizer);
        }
        return (T)super.getAdapter(adapter);
    }

    public String toString() {
        return this.getClass().getSimpleName() + String.valueOf(this.fRepos);
    }

    record UnitDeclaration(String id, VersionRange version, boolean hasVersion) {
        private static final String EMPTY_VERSION = Version.emptyVersion.toString();

        static UnitDeclaration parse(String id, String version) {
            if ((version = version.strip()).isEmpty() || version.equals(EMPTY_VERSION)) {
                return new UnitDeclaration(id, VersionRange.emptyRange, !version.isEmpty());
            }
            if (version.contains(",")) {
                return new UnitDeclaration(id, VersionRange.create((String)version), true);
            }
            return UnitDeclaration.create(id, Version.parseVersion((String)version));
        }

        static UnitDeclaration create(String id, Version version) {
            VersionRange range = new VersionRange(version, true, version, true);
            return new UnitDeclaration(id, range, true);
        }

        UnitDeclaration {
            Objects.requireNonNull(id);
            Objects.requireNonNull(version);
        }

        private boolean hasSingleVersion() {
            return this.hasEmptyVersion() || this.version.getMaximum().equals(this.version.getMinimum()) && this.version.getIncludeMinimum() && this.version.getIncludeMaximum();
        }

        private boolean hasEmptyVersion() {
            return this.version.equals((Object)VersionRange.emptyRange);
        }

        Version getSingleVersion() {
            if (!this.hasSingleVersion()) {
                throw new IllegalStateException("Declaration does not have a single version");
            }
            return this.version.getMinimum();
        }

        IQuery<IInstallableUnit> createIUQuery() {
            if (this.hasEmptyVersion()) {
                return IUBundleContainer.createLatestIUQuery(this.id);
            }
            if (this.hasSingleVersion()) {
                return QueryUtil.createIUQuery((String)this.id, (Version)this.version.getMinimum());
            }
            return QueryUtil.createLatestQuery((IQuery)QueryUtil.createIUQuery((String)this.id, (VersionRange)this.version));
        }

        String versionString() {
            return this.hasSingleVersion() ? this.version.getMinimum().toString() : this.version.toString();
        }

        @Override
        public String toString() {
            return this.hasEmptyVersion() ? this.id : this.id + "/" + this.versionString();
        }
    }
}

