/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.core.config;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.sort.config.DefaultSortConfiguration;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.swt.widgets.Control;
import org.polarsys.kitalpha.massactions.core.config.IMAConfiguration;
import org.polarsys.kitalpha.massactions.core.config.MAColumnConfiguration;
import org.polarsys.kitalpha.massactions.core.config.MAExportConfiguration;
import org.polarsys.kitalpha.massactions.core.config.MAMenuConfiguration;
import org.polarsys.kitalpha.massactions.core.config.MAThemeConfiguration;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;

public abstract class MAConfiguration
implements IMAConfiguration {
    protected final NatTable natTable;
    protected MAColumnConfiguration editorConfiguration;
    protected MAMenuConfiguration menuConfiguration;
    protected DefaultSortConfiguration sortConfiguration;
    protected MAExportConfiguration exportConfiguration;
    protected MAThemeConfiguration themeExtension;

    public MAConfiguration(NatTable natTable, IConfigRegistry configRegistry) {
        this.natTable = natTable;
        this.natTable.setConfigRegistry(configRegistry);
        this.addConfigurations();
    }

    protected void addConfigurations() {
        this.themeExtension = this.createThemeConfiguration();
        if (this.themeExtension != null) {
            this.natTable.addConfiguration((IConfiguration)this.themeExtension);
        }
        this.editorConfiguration = this.createColumnConfiguration();
        if (this.editorConfiguration != null) {
            this.natTable.addConfiguration((IConfiguration)this.editorConfiguration);
        }
        this.sortConfiguration = this.createSortConfiguration();
        if (this.sortConfiguration != null) {
            this.natTable.addConfiguration((IConfiguration)this.sortConfiguration);
        }
        this.exportConfiguration = this.createExportConfiguration();
        if (this.exportConfiguration != null) {
            this.natTable.addConfiguration((IConfiguration)this.exportConfiguration);
        }
        this.menuConfiguration = this.createMenuConfiguration();
        if (this.menuConfiguration != null) {
            this.natTable.addConfiguration((IConfiguration)this.menuConfiguration);
        }
    }

    protected MAExportConfiguration createExportConfiguration() {
        return new MAExportConfiguration();
    }

    protected DefaultSortConfiguration createSortConfiguration() {
        return new SingleClickSortConfiguration();
    }

    protected MAColumnConfiguration createColumnConfiguration() {
        return new MAColumnConfiguration(this.getBodyLayer());
    }

    protected MAThemeConfiguration createThemeConfiguration() {
        return new MAThemeConfiguration();
    }

    protected MAMenuConfiguration createMenuConfiguration() {
        return new MAMenuConfiguration(this.natTable);
    }

    public MAMenuConfiguration getMenuConfiguration() {
        return this.menuConfiguration;
    }

    public MAColumnConfiguration getEditorConfiguration() {
        return this.editorConfiguration;
    }

    public DefaultSortConfiguration getSortConfiguration() {
        return this.sortConfiguration;
    }

    public MAExportConfiguration getExportConfiguration() {
        return this.exportConfiguration;
    }

    public MAThemeConfiguration getThemeExtension() {
        return this.themeExtension;
    }

    protected abstract IMABodyLayer getBodyLayer();

    @Override
    public void apply() {
        this.natTable.configure();
        this.fillDefaults();
    }

    protected void fillDefaults() {
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.natTable);
    }

    @Override
    public void dataChanged(Collection<EObject> data) {
        if (this.editorConfiguration != null) {
            this.editorConfiguration.dataChanged(data);
        }
        this.natTable.configure();
        this.natTable.refresh();
    }

    @Override
    public void dispose() {
        if (this.editorConfiguration != null) {
            this.editorConfiguration.dispose();
        }
    }
}

