/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.resourcereuse.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.kitalpha.resourcereuse.helper.Constants;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;
import org.polarsys.kitalpha.resourcereuse.registry.PlatformRegistry;
import org.polarsys.kitalpha.resourcereuse.registry.ResourceRegistry;

public class PlatformReader
implements Constants {
    private Resource createResource(IConfigurationElement element) {
        Resource res = new Resource();
        String symbolicName = element.getContributor().getName();
        res.setProviderSymbolicName(symbolicName);
        res.setProviderLocation(Location.PLATFORM);
        res.setId(element.getAttribute("id"));
        String value = element.getAttribute("weight");
        if (value != null) {
            res.setWeight(Integer.parseInt(value));
        }
        res.setName(element.getAttribute("name"));
        res.setDomain(element.getAttribute("domain"));
        res.setDescription(element.getAttribute("description"));
        res.setVersion(element.getAttribute("version"));
        res.setPath(element.getAttribute("path"));
        res.setMetadataPath(element.getAttribute("metadata"));
        String tags = element.getAttribute("tags");
        if (tags != null) {
            String[] stringArray = tags.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tag = stringArray[n2];
                res.getTags().add(tag.trim());
                ++n2;
            }
        }
        return res;
    }

    public ResourceRegistry readResources() {
        HashMap<String, Set<String>> user2concern = new HashMap<String, Set<String>>(100);
        HashMap<String, Set<String>> used2concern = new HashMap<String, Set<String>>(100);
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.resourcereuse.concerns");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String concernName = element.getAttribute("name");
            String user = element.getAttribute("userResourceId");
            String used = element.getAttribute("usedResourceId");
            this.addConcern(user2concern, user, concernName);
            this.addConcern(used2concern, used, concernName);
            ++n2;
        }
        PlatformRegistry registry = new PlatformRegistry();
        IConfigurationElement[] iConfigurationElementArray2 = Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.kitalpha.resourcereuse.resources");
        int n3 = iConfigurationElementArray2.length;
        n = 0;
        while (n < n3) {
            IConfigurationElement element = iConfigurationElementArray2[n];
            Resource resource = this.createResource(element);
            registry.addResource(resource, (Set)user2concern.get(resource.getId()), (Set)used2concern.get(resource.getId()));
            ++n;
        }
        return registry;
    }

    private void addConcern(Map<String, Set<String>> resourceId2concern, String resourceId, String concernName) {
        Set<String> concerns = resourceId2concern.get(resourceId);
        if (concerns == null) {
            concerns = new HashSet<String>();
            resourceId2concern.put(resourceId, concerns);
        }
        concerns.add(concernName);
    }
}

