/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.validation.java.provider.generic;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ModelConstraint;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.polarsys.kitalpha.validation.java.provider.generic.IExtendedJavaConstraint;
import org.polarsys.kitalpha.validation.java.provider.generic.IJavaConstraint;
import org.polarsys.kitalpha.validation.util.LabelUtil;

public class JavaConstraint<T extends EObject>
extends ModelConstraint {
    private AbstractConstraintDescriptor descriptor;
    private IJavaConstraint<T> constraint;
    private Class<T> type;

    public JavaConstraint(AbstractConstraintDescriptor descriptor, IJavaConstraint<T> constraint, Class<T> type) {
        super((IConstraintDescriptor)descriptor);
        this.descriptor = descriptor;
        this.constraint = constraint;
        this.type = type;
    }

    public IStatus validate(IValidationContext ctx) {
        boolean valid;
        EObject target = ctx.getTarget();
        if (this.type.isInstance(target) && !(valid = this.constraint.isValid((EObject)this.type.cast(target)))) {
            String objectLabel = LabelUtil.getEObjectLabel(target);
            Object[] args = new Object[]{objectLabel};
            if (this.constraint instanceof IExtendedJavaConstraint) {
                IExtendedJavaConstraint castedConstraint = (IExtendedJavaConstraint)this.constraint;
                Object[] additionalArguments = castedConstraint.getAdditionalArguments();
                args = new Object[1 + additionalArguments.length];
                args[0] = objectLabel;
                System.arraycopy(additionalArguments, 0, args, 1, additionalArguments.length);
            }
            return ctx.createFailureStatus(args);
        }
        return ctx.createSuccessStatus();
    }
}

