/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.TextFieldNavigationHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.polarsys.kitalpha.ad.common.AD_Log;
import org.polarsys.kitalpha.ad.viewpoint.ui.Messages;

public abstract class NewElementWizardPage
extends NewTypeWizardPage {
    protected static final String ELEMENT_NAME = "element.name";
    protected StringDialogField fElementNameDialogField = new StringDialogField();
    protected IStatus fElementNameStatus;

    public NewElementWizardPage(boolean isClass, String pageName) {
        super(isClass, pageName);
        this.fElementNameDialogField.setDialogFieldListener(field -> this.handleFieldChanged(ELEMENT_NAME));
        this.fElementNameDialogField.setLabelText(this.getElementLabel());
    }

    protected void createElementNameControls(Composite composite, int nColumns) {
        this.fElementNameDialogField.doFillIntoGrid(composite, nColumns - 1);
        DialogField.createEmptySpace((Composite)composite);
        Text text = this.fElementNameDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text, (int)this.getMaxFieldWidth());
        TextFieldNavigationHandler.install((Text)text);
    }

    public String getElementName() {
        return this.fElementNameDialogField.getText();
    }

    protected void setFocus() {
        this.fElementNameDialogField.setFocus();
    }

    protected String getTypeNameLabel() {
        return Messages.JavaRuleWizard_type_label;
    }

    public String getElementLabel() {
        return Messages.JavaRuleWizard_rule_label;
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.createInheritedMethods(type, false, true, imports, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (monitor != null) {
            monitor.done();
        }
    }

    protected void doStatusUpdate() {
        ArrayList<IStatus> allStatus = new ArrayList<IStatus>();
        this.collectStatus(allStatus);
        this.updateStatus(allStatus.toArray(new IStatus[allStatus.size()]));
    }

    protected void collectStatus(List<IStatus> allStatus) {
        allStatus.add(this.fContainerStatus);
        allStatus.add(this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus);
        allStatus.add(this.fTypeNameStatus);
        allStatus.add(this.fModifierStatus);
        allStatus.add(this.fSuperClassStatus);
        allStatus.add(this.fSuperInterfacesStatus);
        allStatus.add(this.fElementNameStatus);
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName == ELEMENT_NAME) {
            this.fElementNameStatus = this.elementNameChanged();
        }
        this.doStatusUpdate();
    }

    protected IStatus elementNameChanged() {
        StatusInfo status = new StatusInfo();
        String text = this.fElementNameDialogField.getText();
        if (text == null || "".equals(text)) {
            status.setError(Messages.NewCreationWizardPage_error1);
        }
        return status;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    public void init(IStructuredSelection selection) {
        IJavaElement root;
        IResource findMember;
        String location;
        IDialogSettings section;
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (section = dialogSettings.getSection("rule.provider.wizard.section")) != null && (location = section.get("default.location.key")) != null && (findMember = ResourcesPlugin.getWorkspace().getRoot().findMember(location)) != null && findMember.exists() && (root = JavaCore.create((IResource)findMember)) != null && root.exists() && root instanceof IPackageFragmentRoot) {
            IPackageFragment packg;
            IPackageFragmentRoot root2 = (IPackageFragmentRoot)root;
            this.setPackageFragmentRoot(root2, true);
            String pack = section.get("default.package.key");
            if (pack != null && (packg = root2.getPackageFragment(pack)) != null && packg.exists()) {
                this.setPackageFragment(packg, true);
            }
        }
    }

    protected IPackageFragmentRoot chooseContainer() {
        IPackageFragmentRoot initElement = this.getPackageFragmentRoot();
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        LocalTypedElementSelectionValidator validator = new LocalTypedElementSelectionValidator(acceptedClasses, false);
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IJavaProject) {
                    IJavaProject jproj = (IJavaProject)element;
                    try {
                        return jproj.getProject().hasNature("org.eclipse.pde.PluginNature");
                    }
                    catch (CoreException e) {
                        AD_Log.getDefault().logWarning((Throwable)e);
                        return false;
                    }
                }
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        AD_Log.getDefault().logWarning((Throwable)e);
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        dialog.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        dialog.setInitialSelection((Object)initElement);
        dialog.setHelpAvailable(false);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private final class LocalTypedElementSelectionValidator
    extends TypedElementSelectionValidator {
        private LocalTypedElementSelectionValidator(Class<?>[] acceptedTypes, boolean allowMultipleSelection) {
            super((Class[])acceptedTypes, allowMultipleSelection);
        }

        public boolean isSelectedValid(Object element) {
            try {
                if (element instanceof IJavaProject) {
                    IJavaProject jproject = (IJavaProject)element;
                    IPath path = jproject.getProject().getFullPath();
                    return jproject.findPackageFragmentRoot(path) != null;
                }
                if (element instanceof IPackageFragmentRoot) {
                    return ((IPackageFragmentRoot)element).getKind() == 1;
                }
                return true;
            }
            catch (JavaModelException e) {
                AD_Log.getDefault().logWarning((Throwable)e);
                return false;
            }
        }
    }
}

