/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.integration.sirius.dialog;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.polarsys.kitalpha.ad.integration.sirius.Activator;
import org.polarsys.kitalpha.ad.integration.sirius.SiriusViewpointManager;

public class ViewpointsTableLabelProvider
extends ColumnLabelProvider {
    private final Map<Viewpoint, Boolean> viewpoints;
    private int columnIndex;

    public ViewpointsTableLabelProvider(Map<Viewpoint, Boolean> viewpoints) {
        this.viewpoints = viewpoints;
    }

    private boolean findViewpoint(Viewpoint vp) {
        for (Map.Entry<Viewpoint, Boolean> entry : this.viewpoints.entrySet()) {
            if (!EqualityHelper.areEquals((EObject)((EObject)entry.getKey()), (EObject)vp) || !entry.getValue().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private ImageDescriptor getOverlayedDescriptor(Image baseImage, String decoratorPath) {
        ImageDescriptor decoratorDescriptor = SiriusEditPlugin.Implementation.getBundledImageDescriptor((String)decoratorPath);
        return new DecorationOverlayIcon(baseImage, decoratorDescriptor, 2);
    }

    private Image getEnhancedImage(Image image, Viewpoint viewpoint) {
        if (ViewpointRegistry.getInstance().isFromPlugin(viewpoint) && image != null) {
            return SiriusEditPlugin.getPlugin().getImage(this.getOverlayedDescriptor(image, "icons/full/others/plugin.gif"));
        }
        return image;
    }

    public Image getImage(Object element) {
        if (!(element instanceof Viewpoint)) {
            return null;
        }
        Image image = null;
        Viewpoint vp = (Viewpoint)element;
        switch (this.columnIndex) {
            case 0: {
                boolean underControl = SiriusViewpointManager.INSTANCE.isUnderControl(vp);
                if (this.findViewpoint(vp)) {
                    return underControl ? Activator.getDefault().getImage("icons/checkboxgrayedselected.gif") : SiriusEditPlugin.getPlugin().getBundledImage("/icons/full/others/checkbox_active.gif");
                }
                return underControl ? Activator.getDefault().getImage("icons/checkboxgrayedunselected.gif") : SiriusEditPlugin.getPlugin().getBundledImage("/icons/full/others/checkbox_inactive.gif");
            }
            case 1: {
                ImageDescriptor desc;
                if (vp.getIcon() != null && vp.getIcon().length() > 0 && (desc = SiriusEditPlugin.Implementation.findImageDescriptor((String)vp.getIcon())) != null) {
                    image = SiriusEditPlugin.getPlugin().getImage(desc);
                    return this.getEnhancedImage(image, vp);
                }
                image = SiriusEditPlugin.getPlugin().getImage(SiriusEditPlugin.getPlugin().getItemImageDescriptor((Object)vp));
                return this.getEnhancedImage(image, vp);
            }
        }
        return null;
    }

    public String getText(Object element) {
        switch (this.columnIndex) {
            case 2: {
                if (!(element instanceof Viewpoint)) break;
                return MessageTranslator.INSTANCE.getMessage((EObject)((Viewpoint)element), new IdentifiedElementQuery((IdentifiedElement)((Viewpoint)element)).getLabel());
            }
        }
        return null;
    }

    public String getToolTipText(Object element) {
        String toolTip = null;
        if (this.columnIndex == 2 && element instanceof Viewpoint) {
            Viewpoint viewpoint = (Viewpoint)element;
            Resource resource = ((Viewpoint)element).eResource();
            if (resource != null) {
                toolTip = resource.getURI().toString();
            }
            if (viewpoint.getEndUserDocumentation() != null && viewpoint.getEndUserDocumentation().trim().length() > 0) {
                toolTip = toolTip != null ? String.valueOf(toolTip) + "\n\n" : "";
                toolTip = String.valueOf(toolTip) + viewpoint.getEndUserDocumentation();
            }
        }
        return toolTip;
    }

    public Point getToolTipShift(Object object) {
        return new Point(5, 5);
    }

    public int getToolTipDisplayDelayTime(Object object) {
        return 200;
    }

    public Color getBackground(Object element) {
        return super.getBackground(element);
    }

    public void update(ViewerCell cell) {
        this.columnIndex = cell.getColumnIndex();
        Font font = cell.getFont();
        super.update(cell);
        Object element = cell.getElement();
        if (font != null && font.getFontData().length != 0 && element instanceof Viewpoint && SiriusViewpointManager.INSTANCE.isUnderControl((Viewpoint)element)) {
            String name = font.getFontData()[0].getName();
            FontRegistry fontRegistry = JFaceResources.getFontRegistry();
            Font italic = fontRegistry.getItalic(name);
            cell.setFont(italic);
        } else {
            cell.setFont(null);
        }
    }

    public int getToolTipStyle(Object object) {
        return 8;
    }
}

