/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.common.ui.preference;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.osgi.service.prefs.BackingStoreException;

public abstract class AbstractPreferencePage
extends PreferencePage {
    private boolean isDirty;

    public AbstractPreferencePage() {
    }

    public AbstractPreferencePage(String title) {
        super(title);
    }

    public AbstractPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public void init(IWorkbench workbench) {
    }

    protected abstract void loadData();

    protected abstract void doApply() throws BackingStoreException;

    protected abstract void addContents(Composite var1);

    protected void performApply() {
        try {
            this.doApply();
            this.setDirty(false);
        }
        catch (BackingStoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)e.getMessage());
        }
    }

    public boolean performCancel() {
        this.performDefaults();
        return super.performCancel();
    }

    protected void performDefaults() {
        if (!this.isDirty) {
            return;
        }
        this.loadData();
        this.setDirty(false);
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void setDirty(boolean dirty) {
        if (this.isDirty == dirty) {
            return;
        }
        this.isDirty = dirty;
        this.updateButtons();
    }

    protected void updateButtons() {
        this.getApplyButton().setEnabled(this.isDirty && this.isValid());
        this.getDefaultsButton().setEnabled(this.isDirty);
    }

    protected Control createContents(Composite parent) {
        Composite bar = new Composite(parent, 0);
        bar.setLayoutData((Object)new GridData(1808));
        bar.setLayout((Layout)new GridLayout(2, false));
        this.addContents(bar);
        this.loadData();
        return bar;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.updateButtons();
    }

    public final class DirtyManagerSelectionListener
    implements SelectionListener {
        protected void doWidgetSelected(SelectionEvent e) {
        }

        public final void widgetSelected(SelectionEvent e) {
            AbstractPreferencePage.this.setDirty(true);
            this.doWidgetSelected(e);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

