/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.extension.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;

public class ExtensionAnnotationsHelper {
    public static final String EXTENSION_NS_URI = "http://www.polarsys.org/kitalpha/emde/1.0.0/extension";
    public static final String CONSTRAINT_NS_URI = "http://www.polarsys.org/kitalpha/emde/1.0.0/constraint";
    public static final String TRUE = "true";
    public static final String TRACK_RESOURCE_MODIFICATION = "trackResourceModification";
    public static final String USE_UUIDS = "useUUIDs";
    public static final String USE_ID_ATTRIBUTES = "useIDAttributes";
    public static final String USED_GEN_PACKAGES = "usedGenPackages";
    public static final String EXTENDED_ELEMENT = "ExtendedElement";

    public static boolean isTrackResourceModification(EPackage genPackage) {
        return ExtensionAnnotationsHelper.hasAnnotation((EModelElement)genPackage, TRACK_RESOURCE_MODIFICATION);
    }

    public static boolean isUseUUIDS(EPackage genPackage) {
        return ExtensionAnnotationsHelper.hasAnnotation((EModelElement)genPackage, USE_UUIDS);
    }

    public static boolean isUseIDAttributes(EPackage genPackage) {
        return ExtensionAnnotationsHelper.hasAnnotation((EModelElement)genPackage, USE_ID_ATTRIBUTES);
    }

    public static List<String> getUsedGenPackages(EPackage genPackage) {
        return ExtensionAnnotationsHelper.getAnnotationDetails((EModelElement)genPackage, EXTENSION_NS_URI, USED_GEN_PACKAGES);
    }

    public static List<String> getExtendedElement(EClass eClass_p) {
        return ExtensionAnnotationsHelper.getAnnotationDetails((EModelElement)eClass_p, CONSTRAINT_NS_URI, EXTENDED_ELEMENT);
    }

    private static List<String> getAnnotationDetails(EModelElement eModel, String source, String entry) {
        ArrayList<String> items = new ArrayList<String>();
        if (eModel == null) {
            return items;
        }
        EAnnotation eAnnotation = eModel.getEAnnotation(source);
        try {
            if (eAnnotation == null) {
                return items;
            }
            String details = (String)eAnnotation.getDetails().get((Object)entry);
            if (details == null) {
                return items;
            }
            StringTokenizer token = new StringTokenizer(details);
            while (token.hasMoreTokens()) {
                String item = token.nextToken();
                if (item == null || items.contains(item.trim())) continue;
                items.add(item.trim());
            }
            return items;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid EAnnotation entry: " + entry);
        }
    }

    private static boolean hasAnnotation(EModelElement eModel, String entry) {
        EAnnotation eAnnotation = eModel.getEAnnotation(EXTENSION_NS_URI);
        try {
            return eAnnotation == null ? false : TRUE.equalsIgnoreCase((String)eAnnotation.getDetails().get((Object)entry));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalArgumentException("Invalid EAnnotation entry: " + entry);
        }
    }
}

