/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.massactions.edit.data.accessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.kitalpha.massactions.core.column.IMAColumn;
import org.polarsys.kitalpha.massactions.core.data.accessor.AbstractMAColumnPropertyAccessor;
import org.polarsys.kitalpha.massactions.core.extensionpoint.columnprovider.IMAColumnProvider;
import org.polarsys.kitalpha.massactions.core.extensions.columnprovider.MABasicColumnProvider;
import org.polarsys.kitalpha.massactions.core.helper.CommonFeaturesHelper;
import org.polarsys.kitalpha.massactions.core.table.layer.body.IMABodyLayer;

public class MEColumnPropertyAccessor
extends AbstractMAColumnPropertyAccessor {
    private static final Log log = LogFactory.getLog(MEColumnPropertyAccessor.class);
    private TransactionalEditingDomain editingDomain;
    private List<Command> recordingCommands;
    private boolean isEditingSelection;
    private Collection<EObject> currentData;

    public MEColumnPropertyAccessor(IMABodyLayer bodyLayer) {
        super(bodyLayer);
        this.columnProperties = Collections.emptyList();
        this.prevColumnProperties = Collections.emptyList();
        this.initializeColumnProviders();
        this.dataChanged(bodyLayer.getData());
    }

    private void initializeColumnProviders() {
        LinkedList<IMAColumnProvider> localColumnProviders = new LinkedList<IMAColumnProvider>();
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] config = extensionRegistry.getConfigurationElementsFor("org.polarsys.kitalpha.massactions.core.columnprovider");
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                String kind;
                IConfigurationElement element = iConfigurationElementArray[n2];
                Object o = element.createExecutableExtension("class");
                if (o instanceof IMAColumnProvider && "editing".equals(kind = element.getAttribute("kind"))) {
                    IMAColumnProvider columnProvider = (IMAColumnProvider)o;
                    columnProvider.setBodyLayer(this.bodyLayer);
                    if (o instanceof MABasicColumnProvider) {
                        localColumnProviders.addFirst(columnProvider);
                    } else {
                        localColumnProviders.add(columnProvider);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            log.error((Object)e.getMessage());
        }
        this.columnProviders = new ArrayList(localColumnProviders);
    }

    public void dataChanged(Collection<EObject> data) {
        this.currentData = data;
        Collection possibleFeatures = CommonFeaturesHelper.getCommonPossibleFeatures(this.currentData);
        int columnIndex = 0;
        this.columnList = new ArrayList();
        this.prevColumnProperties = this.columnProperties;
        this.columnProperties = new ArrayList();
        this.columnPropertiesIndex = new HashMap();
        for (IMAColumnProvider columnProvider : this.columnProviders) {
            Collection extensionColumns = columnProvider.getColumnValues(possibleFeatures, this.currentData);
            for (IMAColumn column : extensionColumns) {
                column.setIndex(columnIndex++);
                column.dataChanged(this.currentData);
                this.columnProperties.add(column.getName());
                this.columnPropertiesIndex.put(column.getName(), column.getIndex());
                this.columnList.add(column);
            }
        }
    }

    public void beforeEditSelectionCommand() {
        this.recordingCommands = new ArrayList<Command>();
        this.isEditingSelection = true;
    }

    public void afterEditSelectionCommand() {
        if (this.isEditingSelection && this.editingDomain != null) {
            CompoundCommand command = new CompoundCommand(this.recordingCommands);
            this.editingDomain.getCommandStack().execute((Command)command);
            this.recordingCommands = null;
        }
    }

    public void cleanResources() {
        this.isEditingSelection = false;
    }

    public Object getDataValue(EObject rowObject, int columnIndex) {
        return ((IMAColumn)this.columnList.get(columnIndex)).getDataValue(rowObject);
    }

    public void setDataValue(final EObject rowObject, final int columnIndex, final Object newValue) {
        if (this.editingDomain == null) {
            this.editingDomain = TransactionUtil.getEditingDomain((EObject)rowObject);
        }
        RecordingCommand recordingCommand = new RecordingCommand(this.editingDomain){

            protected void doExecute() {
                ((IMAColumn)MEColumnPropertyAccessor.this.columnList.get(columnIndex)).setDataValue(rowObject, newValue);
            }
        };
        if (this.isEditingSelection) {
            this.recordingCommands.add((Command)recordingCommand);
        } else {
            this.editingDomain.getCommandStack().execute((Command)recordingCommand);
        }
    }

    public Collection<EObject> getCurrentDataRepresentation() {
        return this.currentData;
    }
}

