/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.wireadmin;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import org.eclipse.equinox.internal.util.ref.Log;
import org.eclipse.equinox.internal.wireadmin.Activator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.wireadmin.Wire;
import org.osgi.service.wireadmin.WireAdminEvent;
import org.osgi.service.wireadmin.WireAdminListener;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class WireReDispatcher
implements WireAdminListener {
    static final String BUNDLE = "bundle";
    static final String BUNDLE_ID = "bundle.id";
    static final String BUNDLE_SYMBOLICNAME = "bundle.symbolicName";
    static final String EVENT = "event";
    static final String EXCEPTION = "exception";
    static final String EXCEPTION_CLASS = "exception.class";
    static final String EXCEPTION_MESSAGE = "exception.message";
    static final String SERVICE = "service";
    static final String SERVICE_ID = "service.id";
    static final String SERVICE_OBJECTCLASS = "service.objectClass";
    static final String SERVICE_PID = "service.pid";
    static final char TOPIC_SEPARATOR = '/';
    static final String WIRE_HEADER = "org/osgi/service/wireadmin/WireAdminEvent";
    static final String WIRE_CREATED = "WIRE_CREATED";
    static final String WIRE_CONNECTED = "WIRE_CONNECTED";
    static final String WIRE_UPDATED = "WIRE_UPDATED";
    static final String WIRE_TRACE = "WIRE_TRACE";
    static final String WIRE_DISCONNECTED = "WIRE_DISCONNECTED";
    static final String WIRE_DELETED = "WIRE_DELETED";
    static final String PRODUCER_EXCEPTION = "PRODUCER_EXCEPTION";
    static final String CONSUMER_EXCEPTION = "CONSUMER_EXCEPTION";
    static final String[] EVENT_TOPICS = new String[8];
    static final String WIRE_ENTRY = "wire.entry";
    static final String WA_WIRE = "wire";
    static final String WA_WIRE_FLAVORS = "wire.flavors";
    static final String WA_WIRE_SCOPE = "wire.scope";
    static final String WA_WIRE_CONNECTED = "wire.connected";
    static final String WA_WIRE_VALID = "wire.valid";
    BundleContext bc;
    ServiceRegistration waReg;
    Log log;
    ServiceTracker eventAdminTracker;
    ServiceTracker eventHandlerTracker;
    EventHandlerIndex eventHandlerIndex;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        WireReDispatcher.EVENT_TOPICS[0] = "org/osgi/service/wireadmin/WireAdminEvent/WIRE_CREATED";
        WireReDispatcher.EVENT_TOPICS[1] = "org/osgi/service/wireadmin/WireAdminEvent/WIRE_CONNECTED";
        WireReDispatcher.EVENT_TOPICS[2] = "org/osgi/service/wireadmin/WireAdminEvent/WIRE_UPDATED";
        WireReDispatcher.EVENT_TOPICS[3] = "org/osgi/service/wireadmin/WireAdminEvent/WIRE_TRACE";
        WireReDispatcher.EVENT_TOPICS[4] = "org/osgi/service/wireadmin/WireAdminEvent/WIRE_DISCONNECTED";
        WireReDispatcher.EVENT_TOPICS[5] = "org/osgi/service/wireadmin/WireAdminEvent/WIRE_DELETED";
        WireReDispatcher.EVENT_TOPICS[6] = "org/osgi/service/wireadmin/WireAdminEvent/PRODUCER_EXCEPTION";
        WireReDispatcher.EVENT_TOPICS[7] = "org/osgi/service/wireadmin/WireAdminEvent/CONSUMER_EXCEPTION";
    }

    public void start(BundleContext bc) throws Exception {
        this.bc = bc;
        this.log = new Log(bc, false);
        this.eventHandlerIndex = new EventHandlerIndex();
        this.log.setDebug(Activator.getBoolean("equinox.wireadmin.redispatcher.debug"));
        this.log.setPrintOnConsole(Activator.getBoolean("equinox.wireadmin.redispatcher.console"));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.event.EventHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventHandlerTracker = new ServiceTracker(bc, clazz.getName(), (ServiceTrackerCustomizer)this.eventHandlerIndex);
        this.eventHandlerTracker.open();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.eventAdminTracker = new ServiceTracker(bc, clazz2.getName(), null);
        this.eventAdminTracker.open();
    }

    public void stop() throws Exception {
        if (this.eventAdminTracker != null) {
            this.eventAdminTracker.close();
            this.eventAdminTracker = null;
        }
        if (this.eventHandlerTracker != null) {
            this.eventHandlerTracker.close();
            this.eventHandlerTracker = null;
        }
        this.log.close();
        this.bc = null;
    }

    void addExceptionProps(Hashtable props, Throwable t) {
        props.put(EXCEPTION, t);
        props.put(EXCEPTION_CLASS, t.getClass().getName());
        String message = t.getMessage();
        if (message != null) {
            props.put(EXCEPTION_MESSAGE, t.getMessage());
        }
    }

    void addServiceProps(Hashtable props, ServiceReference ref) {
        props.put(SERVICE, ref);
        props.put(SERVICE_ID, ref.getProperty(SERVICE_ID));
        Object tmp = ref.getProperty(SERVICE_PID);
        if (tmp != null && tmp instanceof String) {
            props.put(SERVICE_PID, tmp);
        }
        if ((tmp = ref.getProperty("objectClass")) != null && tmp instanceof String[]) {
            props.put(SERVICE_OBJECTCLASS, tmp);
        }
    }

    public void wireAdminEvent(WireAdminEvent event) {
        EventAdmin eventAdmin;
        ServiceTracker st = this.eventAdminTracker;
        EventAdmin eventAdmin2 = eventAdmin = st == null ? null : (EventAdmin)st.getService();
        if (eventAdmin != null) {
            Throwable throwable;
            int topicIndex;
            ServiceReference ref = event.getServiceReference();
            if (ref == null) {
                throw new RuntimeException("Wire Admin ServiceReference is null");
            }
            switch (event.getType()) {
                case 4: {
                    topicIndex = 0;
                    break;
                }
                case 32: {
                    topicIndex = 1;
                    break;
                }
                case 8: {
                    topicIndex = 2;
                    break;
                }
                case 128: {
                    topicIndex = 3;
                    break;
                }
                case 64: {
                    topicIndex = 4;
                    break;
                }
                case 16: {
                    topicIndex = 5;
                    break;
                }
                case 1: {
                    topicIndex = 6;
                    break;
                }
                case 2: {
                    topicIndex = 7;
                    break;
                }
                default: {
                    return;
                }
            }
            if (!this.eventHandlerIndex.hasEventHandlers(topicIndex)) {
                if (Activator.LOG_DEBUG) {
                    this.log.debug(0, 10017, event.toString(), null, false);
                }
                return;
            }
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            this.addServiceProps(props, ref);
            Wire wire = event.getWire();
            if (wire != null) {
                props.put(WA_WIRE, wire);
                props.put(WA_WIRE_CONNECTED, wire.isConnected() ? Boolean.TRUE : Boolean.FALSE);
                if (wire.getFlavors() != null) {
                    props.put(WA_WIRE_FLAVORS, wire.getFlavors());
                }
                if (wire.getScope() != null) {
                    props.put(WA_WIRE_SCOPE, wire.getScope());
                }
                props.put(WA_WIRE_VALID, wire.isValid() ? Boolean.TRUE : Boolean.FALSE);
            }
            if ((throwable = event.getThrowable()) != null) {
                this.addExceptionProps(props, throwable);
            }
            props.put(EVENT, event);
            final Event eaEvent = new Event(EVENT_TOPICS[topicIndex], props);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    eventAdmin.postEvent(eaEvent);
                    return null;
                }
            });
            if (Activator.LOG_DEBUG) {
                this.log.debug(0, 10018, event.toString(), null, false);
            }
        }
    }

    protected static boolean matchTopic(String pattern, String topic) {
        if (pattern.length() > topic.length()) {
            return false;
        }
        if ("*".equals(pattern) || pattern.equals(topic)) {
            return true;
        }
        int index = pattern.indexOf(47);
        if (index == -1 || index == 0 || index == pattern.length() - 1) {
            return false;
        }
        index = 0;
        while (index < pattern.length()) {
            if (pattern.charAt(index) == '*') {
                if (pattern.charAt(index - 1) != '/') {
                    return false;
                }
                return index == pattern.length() - 1;
            }
            if (pattern.charAt(index) != topic.charAt(index)) {
                return false;
            }
            ++index;
        }
        if (index != topic.length()) {
            return false;
        }
        return pattern.charAt(index - 1) != '/';
    }

    synchronized void register() {
        this.unregister();
        Hashtable<String, Integer> props = new Hashtable<String, Integer>(3);
        props.put("wireadmin.events", new Integer(Integer.MAX_VALUE));
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.wireadmin.WireAdminListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.waReg = this.bc.registerService(clazz.getName(), (Object)this, props);
    }

    synchronized void unregister() {
        if (this.waReg != null) {
            this.waReg.unregister();
            this.waReg = null;
        }
    }

    class EventHandlerIndex
    implements ServiceTrackerCustomizer {
        final int[] eventHandlerCount = new int[EVENT_TOPICS.length];
        int totalEventHandlerCount = 0;

        EventHandlerIndex() {
        }

        public synchronized Object addingService(ServiceReference reference) {
            int topics = this.process(reference);
            if (topics != 0 && this.totalEventHandlerCount++ == 0) {
                WireReDispatcher.this.register();
            }
            return new EventHandlerTopics(topics);
        }

        public void modifiedService(ServiceReference reference, Object service) {
            this.removedService(reference, service);
            EventHandlerTopics newTopics = (EventHandlerTopics)this.addingService(reference);
            ((EventHandlerTopics)service).topics = newTopics.topics;
        }

        public synchronized void removedService(ServiceReference reference, Object service) {
            int topics = ((EventHandlerTopics)service).topics;
            if (topics == 0) {
                return;
            }
            this.remove(topics);
            if (--this.totalEventHandlerCount == 0) {
                WireReDispatcher.this.unregister();
            }
        }

        int process(ServiceReference ref) {
            Object topic = ref.getProperty("event.topics");
            if (!(topic instanceof String[])) {
                return 0;
            }
            String[] topics = (String[])topic;
            int matchingTopics = 0;
            int i = 0;
            while (i < topics.length) {
                matchingTopics |= this.processTopicPattern(topics[i]);
                ++i;
            }
            return matchingTopics;
        }

        int processTopicPattern(String pattern) {
            int matchingTopics = 0;
            int i = 0;
            while (i < EVENT_TOPICS.length) {
                if (WireReDispatcher.matchTopic(pattern, EVENT_TOPICS[i])) {
                    int n = i;
                    this.eventHandlerCount[n] = this.eventHandlerCount[n] + 1;
                    matchingTopics |= 1 << i;
                }
                ++i;
            }
            return matchingTopics;
        }

        void remove(int topics) {
            int i = 0;
            while (i < EVENT_TOPICS.length) {
                if ((topics & 1 << i) != 0) {
                    int n = i;
                    this.eventHandlerCount[n] = this.eventHandlerCount[n] - 1;
                }
                ++i;
            }
        }

        boolean hasEventHandlers(int topicIndex) {
            return this.eventHandlerCount[topicIndex] != 0;
        }
    }

    static class EventHandlerTopics {
        int topics;

        public EventHandlerTopics(int topics) {
            this.topics = topics;
        }
    }
}

