/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.xml;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.WrappedFile;
import org.apache.camel.builder.xml.DefaultNamespaceContext;
import org.apache.camel.builder.xml.InvalidXPathExpression;
import org.apache.camel.builder.xml.MessageVariableResolver;
import org.apache.camel.builder.xml.Namespaces;
import org.apache.camel.converter.jaxp.ThreadSafeNodeList;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.MessageHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathBuilder
extends ServiceSupport
implements CamelContextAware,
Expression,
Predicate,
NamespaceAware {
    private static final Logger LOG = LoggerFactory.getLogger(XPathBuilder.class);
    private static final String SAXON_OBJECT_MODEL_URI = "http://saxon.sf.net/jaxp/xpath/om";
    private static final String SAXON_FACTORY_CLASS_NAME = "net.sf.saxon.xpath.XPathFactoryImpl";
    private static final String OBTAIN_ALL_NS_XPATH = "//*/namespace::*";
    private static volatile XPathFactory defaultXPathFactory;
    private CamelContext camelContext;
    private final Queue<XPathExpression> pool = new ConcurrentLinkedQueue<XPathExpression>();
    private final Queue<XPathExpression> poolLogNamespaces = new ConcurrentLinkedQueue<XPathExpression>();
    private final String text;
    private final ThreadLocal<Exchange> exchange = new ThreadLocal();
    private final MessageVariableResolver variableResolver = new MessageVariableResolver(this.exchange);
    private final Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private boolean threadSafety;
    private volatile XPathFactory xpathFactory;
    private volatile Class<?> documentType = Document.class;
    private volatile Class<?> resultType;
    private volatile QName resultQName = XPathConstants.NODESET;
    private volatile String objectModelUri;
    private volatile String factoryClassName;
    private volatile DefaultNamespaceContext namespaceContext;
    private volatile boolean logNamespaces;
    private volatile XPathFunctionResolver functionResolver;
    private volatile XPathFunction bodyFunction;
    private volatile XPathFunction headerFunction;
    private volatile XPathFunction outBodyFunction;
    private volatile XPathFunction outHeaderFunction;
    private volatile XPathFunction propertiesFunction;
    private volatile XPathFunction simpleFunction;
    private volatile String headerName;

    public XPathBuilder(String text) {
        this.text = text;
    }

    public static XPathBuilder xpath(String text) {
        return new XPathBuilder(text);
    }

    public static XPathBuilder xpath(String text, Class<?> resultType) {
        XPathBuilder builder = new XPathBuilder(text);
        builder.setResultType(resultType);
        return builder;
    }

    public String toString() {
        return "XPath: " + this.text;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean matches(Exchange exchange) {
        try {
            Object booleanResult = this.evaluateAs(exchange, XPathConstants.BOOLEAN);
            boolean bl = exchange.getContext().getTypeConverter().convertTo(Boolean.class, booleanResult);
            return bl;
        }
        finally {
            this.exchange.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T evaluate(Exchange exchange, Class<T> type) {
        try {
            Object result = this.evaluate(exchange);
            T t = exchange.getContext().getTypeConverter().convertTo(type, exchange, result);
            return t;
        }
        finally {
            this.exchange.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matches(CamelContext context, Object body) {
        ObjectHelper.notNull(context, "CamelContext");
        DefaultExchange dummy = new DefaultExchange(context);
        dummy.getIn().setBody(body);
        try {
            boolean bl = this.matches(dummy);
            return bl;
        }
        finally {
            this.exchange.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T evaluate(CamelContext context, Object body, Class<T> type) {
        ObjectHelper.notNull(context, "CamelContext");
        DefaultExchange dummy = new DefaultExchange(context);
        dummy.getIn().setBody(body);
        try {
            T t = this.evaluate(dummy, type);
            return t;
        }
        finally {
            this.exchange.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String evaluate(CamelContext context, Object body) {
        ObjectHelper.notNull(context, "CamelContext");
        DefaultExchange dummy = new DefaultExchange(context);
        dummy.getIn().setBody(body);
        this.setResultQName(XPathConstants.STRING);
        this.setResultType(String.class);
        try {
            String string = this.evaluate(dummy, String.class);
            return string;
        }
        finally {
            this.exchange.remove();
        }
    }

    public XPathBuilder booleanResult() {
        this.resultQName = XPathConstants.BOOLEAN;
        return this;
    }

    public XPathBuilder nodeResult() {
        this.resultQName = XPathConstants.NODE;
        return this;
    }

    public XPathBuilder nodeSetResult() {
        this.resultQName = XPathConstants.NODESET;
        return this;
    }

    public XPathBuilder numberResult() {
        this.resultQName = XPathConstants.NUMBER;
        return this;
    }

    public XPathBuilder stringResult() {
        this.resultQName = XPathConstants.STRING;
        return this;
    }

    public XPathBuilder resultType(Class<?> resultType) {
        this.setResultType(resultType);
        return this;
    }

    public XPathBuilder objectModel(String uri) {
        this.objectModelUri = uri;
        return this;
    }

    public XPathBuilder factoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
        return this;
    }

    public XPathBuilder saxon() {
        this.objectModelUri = SAXON_OBJECT_MODEL_URI;
        this.factoryClassName = SAXON_FACTORY_CLASS_NAME;
        return this;
    }

    public XPathBuilder functionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
        return this;
    }

    public XPathBuilder namespace(String prefix, String uri) {
        this.namespaces.put(prefix, uri);
        return this;
    }

    public XPathBuilder namespaces(Namespaces namespaces) {
        namespaces.configure(this);
        return this;
    }

    public XPathBuilder variable(String name, Object value) {
        this.getVariableResolver().addVariable(name, value);
        return this;
    }

    public XPathBuilder documentType(Class<?> documentType) {
        this.setDocumentType(documentType);
        return this;
    }

    public XPathBuilder factory(XPathFactory xpathFactory) {
        this.setXPathFactory(xpathFactory);
        return this;
    }

    public XPathBuilder logNamespaces() {
        this.setLogNamespaces(true);
        return this;
    }

    public XPathBuilder threadSafety(boolean threadSafety) {
        this.setThreadSafety(threadSafety);
        return this;
    }

    public XPathFactory getXPathFactory() {
        return this.xpathFactory;
    }

    public void setXPathFactory(XPathFactory xpathFactory) {
        this.xpathFactory = xpathFactory;
    }

    public Class<?> getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Class<?> documentType) {
        this.documentType = documentType;
    }

    public String getText() {
        return this.text;
    }

    public QName getResultQName() {
        return this.resultQName;
    }

    public void setResultQName(QName resultQName) {
        this.resultQName = resultQName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public boolean isThreadSafety() {
        return this.threadSafety;
    }

    public void setThreadSafety(boolean threadSafety) {
        this.threadSafety = threadSafety;
    }

    public DefaultNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public void setNamespaceContext(DefaultNamespaceContext namespaceContext) {
        this.namespaceContext = namespaceContext;
    }

    public XPathFunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public void setFunctionResolver(XPathFunctionResolver functionResolver) {
        this.functionResolver = functionResolver;
    }

    @Override
    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces.clear();
        this.namespaces.putAll(namespaces);
    }

    @Override
    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public XPathFunction getBodyFunction() {
        return this.bodyFunction;
    }

    private XPathFunction createBodyFunction() {
        return new XPathFunction(){

            public Object evaluate(List list) throws XPathFunctionException {
                return ((Exchange)XPathBuilder.this.exchange.get()).getIn().getBody();
            }
        };
    }

    public void setBodyFunction(XPathFunction bodyFunction) {
        this.bodyFunction = bodyFunction;
    }

    public XPathFunction getHeaderFunction() {
        return this.headerFunction;
    }

    private XPathFunction createHeaderFunction() {
        return new XPathFunction(){

            public Object evaluate(List list) throws XPathFunctionException {
                Object value;
                if (!list.isEmpty() && (value = list.get(0)) != null) {
                    String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                    return ((Exchange)XPathBuilder.this.exchange.get()).getIn().getHeader(text);
                }
                return null;
            }
        };
    }

    public void setHeaderFunction(XPathFunction headerFunction) {
        this.headerFunction = headerFunction;
    }

    public XPathFunction getOutBodyFunction() {
        return this.outBodyFunction;
    }

    private XPathFunction createOutBodyFunction() {
        return new XPathFunction(){

            public Object evaluate(List list) throws XPathFunctionException {
                if (XPathBuilder.this.exchange.get() != null && ((Exchange)XPathBuilder.this.exchange.get()).hasOut()) {
                    return ((Exchange)XPathBuilder.this.exchange.get()).getOut().getBody();
                }
                return null;
            }
        };
    }

    public void setOutBodyFunction(XPathFunction outBodyFunction) {
        this.outBodyFunction = outBodyFunction;
    }

    public XPathFunction getOutHeaderFunction() {
        return this.outHeaderFunction;
    }

    private XPathFunction createOutHeaderFunction() {
        return new XPathFunction(){

            public Object evaluate(List list) throws XPathFunctionException {
                Object value;
                if (XPathBuilder.this.exchange.get() != null && !list.isEmpty() && (value = list.get(0)) != null) {
                    String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                    return ((Exchange)XPathBuilder.this.exchange.get()).getOut().getHeader(text);
                }
                return null;
            }
        };
    }

    public void setOutHeaderFunction(XPathFunction outHeaderFunction) {
        this.outHeaderFunction = outHeaderFunction;
    }

    public XPathFunction getPropertiesFunction() {
        return this.propertiesFunction;
    }

    private XPathFunction createPropertiesFunction() {
        return new XPathFunction(){

            public Object evaluate(List list) throws XPathFunctionException {
                Object value;
                if (!list.isEmpty() && (value = list.get(0)) != null) {
                    String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                    try {
                        String answer = ((Exchange)XPathBuilder.this.exchange.get()).getContext().resolvePropertyPlaceholders("{{" + text + "}}");
                        return answer;
                    }
                    catch (Exception e) {
                        throw new XPathFunctionException(e);
                    }
                }
                return null;
            }
        };
    }

    public void setPropertiesFunction(XPathFunction propertiesFunction) {
        this.propertiesFunction = propertiesFunction;
    }

    public XPathFunction getSimpleFunction() {
        return this.simpleFunction;
    }

    private XPathFunction createSimpleFunction() {
        return new XPathFunction(){

            public Object evaluate(List list) throws XPathFunctionException {
                Object value;
                if (!list.isEmpty() && (value = list.get(0)) != null) {
                    String text = ((Exchange)XPathBuilder.this.exchange.get()).getContext().getTypeConverter().convertTo(String.class, value);
                    Language simple = ((Exchange)XPathBuilder.this.exchange.get()).getContext().resolveLanguage("simple");
                    Expression exp = simple.createExpression(text);
                    Object answer = exp.evaluate((Exchange)XPathBuilder.this.exchange.get(), Object.class);
                    return answer;
                }
                return null;
            }
        };
    }

    public void setSimpleFunction(XPathFunction simpleFunction) {
        this.simpleFunction = simpleFunction;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
        if (Number.class.isAssignableFrom(resultType)) {
            this.numberResult();
        } else if (String.class.isAssignableFrom(resultType)) {
            this.stringResult();
        } else if (Boolean.class.isAssignableFrom(resultType)) {
            this.booleanResult();
        } else if (Node.class.isAssignableFrom(resultType)) {
            this.nodeResult();
        } else if (NodeList.class.isAssignableFrom(resultType)) {
            this.nodeSetResult();
        }
    }

    public void setLogNamespaces(boolean logNamespaces) {
        this.logNamespaces = logNamespaces;
    }

    public boolean isLogNamespaces() {
        return this.logNamespaces;
    }

    public void enableSaxon() {
        this.setObjectModelUri(SAXON_OBJECT_MODEL_URI);
        this.setFactoryClassName(SAXON_FACTORY_CLASS_NAME);
    }

    public String getObjectModelUri() {
        return this.objectModelUri;
    }

    public void setObjectModelUri(String objectModelUri) {
        this.objectModelUri = objectModelUri;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public void setFactoryClassName(String factoryClassName) {
        this.factoryClassName = factoryClassName;
    }

    protected Object evaluate(Exchange exchange) {
        Object answer = this.evaluateAs(exchange, this.resultQName);
        if (this.resultType != null) {
            return ExchangeHelper.convertToType(exchange, this.resultType, answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object evaluateAs(Exchange exchange, QName resultQName) {
        XPathExpression xpathExpression = this.pool.poll();
        if (xpathExpression == null) {
            LOG.trace("Creating new XPathExpression as none was available from pool");
            try {
                xpathExpression = this.createXPathExpression();
            }
            catch (XPathExpressionException e) {
                throw new InvalidXPathExpression(this.getText(), e);
            }
            catch (Exception e) {
                throw new RuntimeExpressionException("Cannot create xpath expression", e);
            }
        } else {
            LOG.trace("Acquired XPathExpression from pool");
        }
        try {
            if (this.logNamespaces && LOG.isInfoEnabled()) {
                this.logNamespaces(exchange);
            }
            Object object = this.doInEvaluateAs(xpathExpression, exchange, resultQName);
            return object;
        }
        finally {
            this.pool.add(xpathExpression);
            LOG.trace("Released XPathExpression back to pool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logNamespaces(Exchange exchange) {
        InputStream is = null;
        NodeList answer = null;
        XPathExpression xpathExpression = null;
        try {
            Source source;
            Object document;
            xpathExpression = this.poolLogNamespaces.poll();
            if (xpathExpression == null) {
                xpathExpression = this.createTraceNamespaceExpression();
            }
            if (this.isInputStreamNeeded(exchange)) {
                is = exchange.getIn().getBody(InputStream.class);
                document = this.getDocument(exchange, is);
            } else {
                Object body = exchange.getIn().getBody();
                document = this.getDocument(exchange, body);
            }
            if (document instanceof InputSource) {
                InputSource inputSource = (InputSource)document;
                answer = (NodeList)xpathExpression.evaluate(inputSource, XPathConstants.NODESET);
            } else if (document instanceof DOMSource) {
                source = (DOMSource)document;
                answer = (NodeList)xpathExpression.evaluate(((DOMSource)source).getNode(), XPathConstants.NODESET);
            } else {
                Object result;
                answer = document instanceof SAXSource ? ((result = xpathExpression.evaluate(((SAXSource)(source = (SAXSource)document)).getInputSource(), XPathConstants.NODESET)) instanceof NodeList ? (NodeList)result : null) : (NodeList)xpathExpression.evaluate(document, XPathConstants.NODESET);
            }
            IOHelper.close((Closeable)is);
            this.poolLogNamespaces.add(xpathExpression);
        }
        catch (Exception e) {
            LOG.warn("Unable to trace discovered namespaces in XPath expression", (Throwable)e);
        }
        finally {
            IOHelper.close(is);
            this.poolLogNamespaces.add(xpathExpression);
        }
        if (answer != null) {
            this.logDiscoveredNamespaces(answer);
        }
    }

    private void logDiscoveredNamespaces(NodeList namespaces) {
        LinkedHashMap map = new LinkedHashMap();
        for (int i = 0; i < namespaces.getLength(); ++i) {
            Node n = namespaces.item(i);
            if (n.getNodeName().equals("xmlns:xml")) continue;
            String prefix = namespaces.item(i).getNodeName();
            if (prefix.equals("xmlns")) {
                prefix = "DEFAULT";
            }
            if (!map.containsKey(prefix)) {
                map.put(prefix, new HashSet());
            }
            ((HashSet)map.get(prefix)).add(namespaces.item(i).getNodeValue());
        }
        LOG.info("Namespaces discovered in message: {}.", map);
    }

    protected Object doInEvaluateAs(XPathExpression xpathExpression, Exchange exchange, QName resultQName) {
        Object answer;
        InputStream is;
        block24: {
            LOG.trace("Evaluating exchange: {} as: {}", (Object)exchange, (Object)resultQName);
            this.exchange.set(exchange);
            is = null;
            try {
                DOMSource source;
                InputSource inputSource;
                Object document;
                if (ObjectHelper.isNotEmpty(this.getHeaderName())) {
                    String headerName = this.getHeaderName();
                    if (this.isInputStreamNeeded(exchange, headerName)) {
                        is = exchange.getIn().getHeader(headerName, InputStream.class);
                        document = this.getDocument(exchange, is);
                    } else {
                        Object headerObject = exchange.getIn().getHeader(this.getHeaderName());
                        document = this.getDocument(exchange, headerObject);
                    }
                } else if (this.isInputStreamNeeded(exchange)) {
                    is = exchange.getIn().getBody(InputStream.class);
                    document = this.getDocument(exchange, is);
                } else {
                    Object body = exchange.getIn().getBody();
                    document = this.getDocument(exchange, body);
                }
                if (resultQName != null) {
                    if (document instanceof InputSource) {
                        inputSource = (InputSource)document;
                        answer = xpathExpression.evaluate(inputSource, resultQName);
                    } else if (document instanceof DOMSource) {
                        source = (DOMSource)document;
                        answer = xpathExpression.evaluate(source.getNode(), resultQName);
                    } else {
                        answer = xpathExpression.evaluate(document, resultQName);
                    }
                    break block24;
                }
                if (document instanceof InputSource) {
                    inputSource = (InputSource)document;
                    answer = xpathExpression.evaluate(inputSource);
                    break block24;
                }
                if (document instanceof DOMSource) {
                    source = (DOMSource)document;
                    answer = xpathExpression.evaluate(source.getNode());
                    break block24;
                }
                answer = xpathExpression.evaluate(document);
            }
            catch (XPathExpressionException e) {
                try {
                    String message = this.getText();
                    if (ObjectHelper.isNotEmpty(this.getHeaderName())) {
                        message = message + " with headerName " + this.getHeaderName();
                    }
                    throw new InvalidXPathExpression(message, e);
                }
                catch (Throwable throwable) {
                    IOHelper.close(is);
                    throw throwable;
                }
            }
        }
        IOHelper.close((Closeable)is);
        if (this.threadSafety && answer != null && answer instanceof NodeList) {
            try {
                boolean threadSafetyNeeded;
                NodeList list = (NodeList)answer;
                boolean bl = threadSafetyNeeded = list.getLength() >= 2;
                if (threadSafetyNeeded) {
                    answer = new ThreadSafeNodeList(list);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created thread-safe result from: {} as: {}", (Object)list.getClass().getName(), (Object)answer.getClass().getName());
                    }
                }
            }
            catch (Exception e) {
                throw ObjectHelper.wrapRuntimeCamelException(e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Done evaluating exchange: {} as: {} with result: {}", new Object[]{exchange, resultQName, answer});
        }
        return answer;
    }

    protected synchronized XPathExpression createXPathExpression() throws XPathExpressionException, XPathFactoryConfigurationException {
        try {
            this.start();
        }
        catch (Exception e) {
            throw new RuntimeExpressionException("Error starting XPathBuilder", e);
        }
        XPath xPath = this.getXPathFactory().newXPath();
        if (!this.logNamespaces && LOG.isTraceEnabled()) {
            LOG.trace("Creating new XPath expression in pool. Namespaces on XPath expression: {}", (Object)this.getNamespaceContext().toString());
        } else if (this.logNamespaces && LOG.isInfoEnabled()) {
            LOG.info("Creating new XPath expression in pool. Namespaces on XPath expression: {}", (Object)this.getNamespaceContext().toString());
        }
        xPath.setNamespaceContext(this.getNamespaceContext());
        xPath.setXPathVariableResolver(this.getVariableResolver());
        XPathFunctionResolver parentResolver = this.getFunctionResolver();
        if (parentResolver == null) {
            parentResolver = xPath.getXPathFunctionResolver();
        }
        xPath.setXPathFunctionResolver(this.createDefaultFunctionResolver(parentResolver));
        return xPath.compile(this.text);
    }

    protected synchronized XPathExpression createTraceNamespaceExpression() throws XPathFactoryConfigurationException, XPathExpressionException {
        XPath xPath = this.getXPathFactory().newXPath();
        return xPath.compile(OBTAIN_ALL_NS_XPATH);
    }

    protected DefaultNamespaceContext createNamespaceContext(XPathFactory factory) {
        DefaultNamespaceContext context = new DefaultNamespaceContext(factory);
        this.populateDefaultNamespaces(context);
        return context;
    }

    protected void populateDefaultNamespaces(DefaultNamespaceContext context) {
        this.setNamespaceIfNotPresent(context, "in", "http://camel.apache.org/xml/in/");
        this.setNamespaceIfNotPresent(context, "out", "http://camel.apache.org/xml/out/");
        this.setNamespaceIfNotPresent(context, "env", "http://camel.apache.org/xml/variables/environment-variables");
        this.setNamespaceIfNotPresent(context, "system", "http://camel.apache.org/xml/variables/system-properties");
        this.setNamespaceIfNotPresent(context, "function", "http://camel.apache.org/xml/function/");
    }

    protected void setNamespaceIfNotPresent(DefaultNamespaceContext context, String prefix, String uri) {
        String current;
        if (context != null && (current = context.getNamespaceURI(prefix)) == null) {
            context.add(prefix, uri);
        }
    }

    protected XPathFunctionResolver createDefaultFunctionResolver(final XPathFunctionResolver parent) {
        return new XPathFunctionResolver(){

            @Override
            public XPathFunction resolveFunction(QName qName, int argumentCount) {
                XPathFunction answer = null;
                if (parent != null) {
                    answer = parent.resolveFunction(qName, argumentCount);
                }
                if (answer == null) {
                    String localPart;
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/in/") || Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/schema/spring")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("body") && argumentCount == 0) {
                            return XPathBuilder.this.getBodyFunction();
                        }
                        if (localPart.equals("header") && argumentCount == 1) {
                            return XPathBuilder.this.getHeaderFunction();
                        }
                    }
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/out/")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("body") && argumentCount == 0) {
                            return XPathBuilder.this.getOutBodyFunction();
                        }
                        if (localPart.equals("header") && argumentCount == 1) {
                            return XPathBuilder.this.getOutHeaderFunction();
                        }
                    }
                    if (Namespaces.isMatchingNamespaceOrEmptyNamespace(qName.getNamespaceURI(), "http://camel.apache.org/xml/function/")) {
                        localPart = qName.getLocalPart();
                        if (localPart.equals("properties") && argumentCount == 1) {
                            return XPathBuilder.this.getPropertiesFunction();
                        }
                        if (localPart.equals("simple") && argumentCount == 1) {
                            return XPathBuilder.this.getSimpleFunction();
                        }
                    }
                }
                return answer;
            }
        };
    }

    protected boolean isInputStreamNeeded(Exchange exchange) {
        Object body = exchange.getIn().getBody();
        return this.isInputStreamNeededForObject(exchange, body);
    }

    protected boolean isInputStreamNeeded(Exchange exchange, String headerName) {
        Object header = exchange.getIn().getHeader(headerName);
        return this.isInputStreamNeededForObject(exchange, header);
    }

    protected boolean isInputStreamNeededForObject(Exchange exchange, Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof WrappedFile) {
            obj = ((WrappedFile)obj).getFile();
        }
        return obj instanceof File;
    }

    protected Object getDocument(Exchange exchange, Object body) {
        try {
            Object object = this.doGetDocument(exchange, body);
            return object;
        }
        catch (Exception e) {
            throw ObjectHelper.wrapRuntimeCamelException(e);
        }
        finally {
            MessageHelper.resetStreamCache(exchange.getIn());
        }
    }

    protected Object doGetDocument(Exchange exchange, Object body) throws Exception {
        if (body == null) {
            return null;
        }
        Object answer = null;
        Class<?> type = this.getDocumentType();
        Exception cause = null;
        if (type != null) {
            try {
                answer = exchange.getContext().getTypeConverter().convertTo(type, exchange, body);
            }
            catch (Exception e) {
                cause = e;
            }
        }
        if (type == null && answer == null) {
            answer = body;
        } else if (answer == null) {
            if (cause != null) {
                throw cause;
            }
            throw new NoTypeConversionAvailableException(body, type);
        }
        return answer;
    }

    private MessageVariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    @Override
    public void doStart() throws Exception {
        if (this.xpathFactory == null) {
            this.xpathFactory = this.createXPathFactory();
        }
        if (this.namespaceContext == null) {
            this.namespaceContext = this.createNamespaceContext(this.xpathFactory);
        }
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            this.namespaceContext.add(entry.getKey(), entry.getValue());
        }
        if (this.bodyFunction == null) {
            this.bodyFunction = this.createBodyFunction();
        }
        if (this.headerFunction == null) {
            this.headerFunction = this.createHeaderFunction();
        }
        if (this.outBodyFunction == null) {
            this.outBodyFunction = this.createOutBodyFunction();
        }
        if (this.outHeaderFunction == null) {
            this.outHeaderFunction = this.createOutHeaderFunction();
        }
        if (this.propertiesFunction == null) {
            this.propertiesFunction = this.createPropertiesFunction();
        }
        if (this.simpleFunction == null) {
            this.simpleFunction = this.createSimpleFunction();
        }
    }

    @Override
    public void doStop() throws Exception {
        this.pool.clear();
        this.poolLogNamespaces.clear();
    }

    protected synchronized XPathFactory createXPathFactory() throws XPathFactoryConfigurationException {
        if (this.objectModelUri != null) {
            String xpathFactoryClassName = this.factoryClassName;
            if (this.objectModelUri.equals(SAXON_OBJECT_MODEL_URI) && (xpathFactoryClassName == null || SAXON_FACTORY_CLASS_NAME.equals(xpathFactoryClassName))) {
                try {
                    Class<XPathFactory> clazz;
                    if (this.camelContext != null && (clazz = this.camelContext.getClassResolver().resolveClass(SAXON_FACTORY_CLASS_NAME, XPathFactory.class)) != null) {
                        LOG.debug("Creating Saxon XPathFactory using class: {})", clazz);
                        this.xpathFactory = this.camelContext.getInjector().newInstance(clazz);
                        LOG.info("Created Saxon XPathFactory: {}", (Object)this.xpathFactory);
                    }
                }
                catch (Throwable e) {
                    LOG.warn("Attempted to create Saxon XPathFactory by creating a new instance of net.sf.saxon.xpath.XPathFactoryImpl failed. Will fallback and create XPathFactory using JDK API. This exception is ignored (stacktrace in DEBUG logging level).");
                    LOG.debug("Error creating Saxon XPathFactory. This exception is ignored.", e);
                }
            }
            if (this.xpathFactory == null) {
                LOG.debug("Creating XPathFactory from objectModelUri: {}", (Object)this.objectModelUri);
                this.xpathFactory = ObjectHelper.isEmpty(xpathFactoryClassName) ? XPathFactory.newInstance(this.objectModelUri) : XPathFactory.newInstance(this.objectModelUri, xpathFactoryClassName, null);
                LOG.info("Created XPathFactory: {} from objectModelUri: {}", (Object)this.xpathFactory, (Object)this.objectModelUri);
            }
            return this.xpathFactory;
        }
        if (defaultXPathFactory == null) {
            defaultXPathFactory = XPathBuilder.createDefaultXPathFactory();
        }
        return defaultXPathFactory;
    }

    protected static XPathFactory createDefaultXPathFactory() throws XPathFactoryConfigurationException {
        XPathFactory factory = null;
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> prop : properties.entrySet()) {
            String uri;
            String key = (String)prop.getKey();
            if (!key.startsWith("javax.xml.xpath.XPathFactory") || (uri = ObjectHelper.after(key, ":")) == null) continue;
            factory = XPathFactory.newInstance(uri);
            LOG.info("Using system property {} with value {} when created default XPathFactory {}", new Object[]{key, uri, factory});
        }
        if (factory == null) {
            factory = XPathFactory.newInstance();
            LOG.info("Created default XPathFactory {}", (Object)factory);
        }
        return factory;
    }
}

