/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.uriresolver;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadedException;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.CacheResourcesManager;
import org.eclipse.lemminx.uriresolver.FileServer;
import org.eclipse.lemminx.uriresolver.InvalidURIException;
import org.eclipse.lemminx.utils.ExceptionUtils;
import org.eclipse.lemminx.utils.FilesUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CacheResourcesManagerTest
extends AbstractCacheBasedTest {
    private CacheResourcesManager cacheResourcesManager;
    private FileServer server;

    @BeforeEach
    public void setup() throws Exception {
        this.cacheResourcesManager = new CacheResourcesManager(this.testingCache());
        this.cacheResourcesManager.setUseCache(true);
    }

    @AfterEach
    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    @Test
    public void testCanUseCache() {
        this.testCanUseCache(true);
        this.testCanUseCache(false);
    }

    private void testCanUseCache(boolean useCacheEnabled) {
        this.cacheResourcesManager.setUseCache(useCacheEnabled);
        Assertions.assertEquals((Object)useCacheEnabled, (Object)this.cacheResourcesManager.canUseCache("http://foo"));
        Assertions.assertEquals((Object)useCacheEnabled, (Object)this.cacheResourcesManager.canUseCache("ftp://foo"));
        Assertions.assertEquals((Object)useCacheEnabled, (Object)this.cacheResourcesManager.canUseCache("https://foo"));
        Assertions.assertFalse((boolean)this.cacheResourcesManager.canUseCache("file:///foo"));
    }

    @Test
    public void testUnavailableCache() throws Exception {
        FileServer server = new FileServer();
        server.start();
        String uri = server.getUri("bad/url");
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy downloading the url");
        }
        catch (CacheResourceDownloadingException containsFuture) {
            block8: {
                try {
                    containsFuture.getFuture().get(2L, TimeUnit.SECONDS);
                    Assertions.fail((String)"Download should have failed");
                }
                catch (ExecutionException failedDownload) {
                    if (failedDownload.getCause() instanceof CacheResourceDownloadedException) break block8;
                    Assertions.fail((String)"Incorrect exception thrown during failed download");
                }
            }
            try {
                this.cacheResourcesManager.getResource(uri);
                Assertions.fail((String)"cacheResourcesManager should retrow CacheResourceDownloadedException");
            }
            catch (CacheResourceDownloadedException cacheResourceDownloadedException) {
                // empty catch block
            }
        }
        TimeUnit.SECONDS.sleep(2L);
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy re-downloading the url");
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }

    @Test
    public void testAvailableCache() throws Exception {
        FileServer server = new FileServer();
        server.start();
        String uri = server.getUri("/dtd/web-app_2_3.dtd");
        Path path = null;
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy downloading the url");
        }
        catch (CacheResourceDownloadingException containsFuture) {
            path = (Path)containsFuture.getFuture().get(2L, TimeUnit.SECONDS);
        }
        Assertions.assertNotNull((Object)path);
        Assertions.assertNotNull((Object)this.cacheResourcesManager.getResource(uri));
        server.stop();
        TimeUnit.SECONDS.sleep(2L);
        this.cacheResourcesManager.getResource(uri);
        Assertions.assertNotNull((Object)this.cacheResourcesManager.getResource(uri));
    }

    @Test
    public void testGetBadResourceName() throws Exception {
        String url = "http://localhost/foo/bar/`test.txt`";
        try {
            this.cacheResourcesManager.getResource(url);
            Assertions.fail((String)"Invalid url should fail to download");
        }
        catch (Exception e) {
            Assertions.assertEquals(InvalidURIException.class, e.getClass());
            Assertions.assertEquals((Object)InvalidURIException.InvalidURIError.ILLEGAL_SYNTAX, (Object)((InvalidURIException)e).getErrorCode());
        }
    }

    @Test
    public void testDirectoryTraversal() throws Exception {
        FileServer server = new FileServer();
        server.start();
        String uri = server.getUri("/dtd/web-app_2_3.dtd/../../xsd/choice.xsd");
        Path path = null;
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy downloading the url");
        }
        catch (CacheResourceDownloadingException containsFuture) {
            path = (Path)containsFuture.getFuture().get(2L, TimeUnit.SECONDS);
        }
        Assertions.assertEquals((Object)"choice.xsd", (Object)path.getFileName().toString());
        String choice = FilesUtils.readString((Path)path);
        Assertions.assertTrue((boolean)choice.contains("<xs:element name=\"person\">"), () -> "Unexpected file content:" + choice);
        String invalidUri = server.getUri("/../../../xsd/choice.xsd");
        try {
            this.cacheResourcesManager.getResource(invalidUri);
            Assertions.fail((String)"Invalid url should fail to download");
        }
        catch (Exception e) {
            Assertions.assertEquals(InvalidURIException.class, e.getClass());
            Assertions.assertEquals((Object)InvalidURIException.InvalidURIError.INVALID_PATH, (Object)((InvalidURIException)e).getErrorCode());
        }
    }

    @Test
    public void testForbiddenRedirection() throws Exception {
        AbstractHandler redirectHandler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                response.setHeader("Location", request.getParameter("redirect"));
            }
        };
        FileServer server = new FileServer(new Handler[]{redirectHandler});
        server.start();
        String uri = server.getUri("/?redirect=file:///etc/password");
        try {
            this.cacheResourcesManager.getResource(uri);
            Assertions.fail((String)"cacheResourcesManager should be busy downloading the url");
        }
        catch (CacheResourceDownloadingException containsFuture) {
            try {
                containsFuture.getFuture().get(2L, TimeUnit.SECONDS);
                Assertions.fail((String)"Download should have failed");
            }
            catch (ExecutionException failedDownload) {
                Throwable cause = failedDownload.getCause();
                Assertions.assertEquals(CacheResourceDownloadedException.class, cause.getClass());
                Throwable rootCause = ExceptionUtils.getRootCause((Throwable)cause);
                Assertions.assertEquals((Object)InvalidURIException.InvalidURIError.UNSUPPORTED_PROTOCOL, (Object)((InvalidURIException)rootCause).getErrorCode());
                Assertions.assertEquals((Object)"Unsupported 'file' protocol in 'file:/etc/password'", (Object)rootCause.getMessage());
            }
        }
    }

    private Cache<String, CacheResourceDownloadedException> testingCache() {
        return CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).maximumSize(1L).build();
    }
}

