/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.preferences;

import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.linuxtools.docker.ui.Activator;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerRefreshManager;
import org.eclipse.linuxtools.internal.docker.ui.preferences.PreferenceMessages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DockerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String REFRESH_TIME_MSG = "RefreshTime.label";
    private static final String RESTART_WAIT_TIME_MSG = "RestartWaitTime.label";
    private static final String INVALID_REFRESH_TIME_MSG = "RefreshTime.invalid.label";
    private static final String INVALID_RESTART_WAIT_TIME_MSG = "RestartWaitTime.invalid.label";
    private IntegerFieldEditor refreshTimeField;
    private IntegerFieldEditor restartWaitTimeField;

    public DockerPreferencePage() {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    private void savePreferences() {
        if (this.refreshTimeField != null) {
            this.refreshTimeField.store();
        }
        if (this.restartWaitTimeField != null) {
            this.restartWaitTimeField.store();
        }
    }

    public boolean performOk() {
        this.savePreferences();
        return true;
    }

    protected void performApply() {
        this.savePreferences();
        super.performApply();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(container);
        GridDataFactory.fillDefaults().align(4, 4).applyTo((Control)container);
        this.createContainerRefreshContainer(container);
        return container;
    }

    private void createContainerRefreshContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridDataFactory.fillDefaults().align(4, 4).span(1, 1).grab(true, false).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(0, 0).spacing(10, 2).applyTo(container);
        this.refreshTimeField = new IntegerFieldEditor("containerRefreshTime", PreferenceMessages.getString(REFRESH_TIME_MSG), container);
        this.refreshTimeField.setPreferenceStore(this.getPreferenceStore());
        this.refreshTimeField.setValidateStrategy(0);
        this.refreshTimeField.setValidRange(5, 200);
        this.refreshTimeField.setPage((DialogPage)this);
        this.refreshTimeField.setErrorMessage(PreferenceMessages.getString(INVALID_REFRESH_TIME_MSG));
        this.refreshTimeField.showErrorMessage();
        this.refreshTimeField.load();
        this.refreshTimeField.setPropertyChangeListener(event -> {
            if (event.getSource().equals(this.refreshTimeField)) {
                if (this.refreshTimeField.isValid()) {
                    DockerContainerRefreshManager.getInstance().setRefreshTime((long)this.refreshTimeField.getIntValue());
                    this.setErrorMessage(null);
                } else {
                    this.setErrorMessage(this.refreshTimeField.getErrorMessage());
                }
                this.setValid(this.refreshTimeField.isValid());
            }
        });
        this.restartWaitTimeField = new IntegerFieldEditor("containerRestartWaitTime", PreferenceMessages.getString(RESTART_WAIT_TIME_MSG), container);
        this.restartWaitTimeField.setPreferenceStore(this.getPreferenceStore());
        this.restartWaitTimeField.setValidateStrategy(0);
        this.restartWaitTimeField.setValidRange(0, Integer.MAX_VALUE);
        this.restartWaitTimeField.setPage((DialogPage)this);
        this.restartWaitTimeField.setErrorMessage(PreferenceMessages.getString(INVALID_RESTART_WAIT_TIME_MSG));
        this.restartWaitTimeField.showErrorMessage();
        this.restartWaitTimeField.load();
        this.restartWaitTimeField.setPropertyChangeListener(event -> {
            if (event.getSource().equals(this.restartWaitTimeField)) {
                if (this.restartWaitTimeField.isValid()) {
                    DockerContainerRefreshManager.getInstance().setRefreshTime((long)this.restartWaitTimeField.getIntValue());
                    this.setErrorMessage(null);
                } else {
                    this.setErrorMessage(this.restartWaitTimeField.getErrorMessage());
                }
                this.setValid(this.restartWaitTimeField.isValid());
            }
        });
    }
}

