/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.Activator;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmMacroProposalsList;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.parser.SpecfileSource;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RPMUtils {
    private RPMUtils() {
    }

    public static void showErrorDialog(Shell shell, String title, String message) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MessageDialog.openError((Shell)shell, (String)title, (String)message));
    }

    public static boolean isValidUrl(String line) {
        try {
            new URL(line);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static String getURLFilename(String url) {
        String rc = "";
        try {
            String fileName = new URL(url).getPath();
            int lastSegment = fileName.lastIndexOf(47) + 1;
            rc = fileName.substring(lastSegment).trim();
        }
        catch (IndexOutOfBoundsException | MalformedURLException e) {
            SpecfileLog.logError(e);
        }
        return rc;
    }

    public static boolean fileExistsInSources(IFile original, String fileName) {
        if (fileName.trim().isEmpty()) {
            return false;
        }
        IContainer container = original.getParent();
        IResource resourceToOpen = container.findMember(fileName);
        IFile file = null;
        if (resourceToOpen == null) {
            IResource sourcesFolder = container.getProject().findMember("SOURCES");
            file = container.getFile((IPath)new Path(fileName));
            if (sourcesFolder != null) {
                file = ((IFolder)sourcesFolder).getFile((IPath)new Path(fileName));
            }
            if (!file.exists()) {
                return false;
            }
        }
        return true;
    }

    public static String getSourceOrPatchValue(Specfile spec, String patchOrSourceName) {
        String value = null;
        Pattern p = Pattern.compile("(source|patch)(\\d*)");
        Matcher m = p.matcher(patchOrSourceName);
        if (m.matches()) {
            String digits = m.group(2);
            SpecfileSource source = null;
            int number = -1;
            if (digits != null && digits.isEmpty()) {
                number = 0;
            } else if (digits != null && !digits.isEmpty()) {
                number = Integer.parseInt(digits);
            }
            if (number != -1) {
                if (m.group(1).equals("source")) {
                    source = spec.getSource(number);
                } else if (m.group(1).equals("patch")) {
                    source = spec.getPatch(number);
                }
                if (source != null) {
                    value = source.getFileName();
                }
            }
        }
        return value;
    }

    public static String getMacroValueFromMacroList(String macroName) {
        String value = null;
        if (Activator.getDefault().getRpmMacroList().findKey("%" + macroName)) {
            String currentConfig = Activator.getDefault().getPreferenceStore().getString("macroHoverViewContent");
            value = currentConfig.equals("macroHoverViewDescription") ? Activator.getDefault().getRpmMacroList().getValue(macroName) : RpmMacroProposalsList.getMacroEval("%" + macroName);
        }
        return value;
    }
}

