/**
 * Copyright (c) 2021 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Do not edit: This file is generated by Xtext
 */
package org.eclipse.lsat.activity.teditor.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.lsat.activity.teditor.ide.contentassist.antlr.internal.InternalActivityParser;
import org.eclipse.lsat.activity.teditor.services.ActivityGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class ActivityParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(ActivityGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, ActivityGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getNodeAccess().getAlternatives(), "rule__Node__Alternatives");
			builder.put(grammarAccess.getClaimAccess().getAlternatives_3(), "rule__Claim__Alternatives_3");
			builder.put(grammarAccess.getClaimAccess().getAlternatives_7(), "rule__Claim__Alternatives_7");
			builder.put(grammarAccess.getReleaseAccess().getAlternatives_3(), "rule__Release__Alternatives_3");
			builder.put(grammarAccess.getReleaseAccess().getAlternatives_6(), "rule__Release__Alternatives_6");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_3(), "rule__Move__Alternatives_3");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_8(), "rule__Move__Alternatives_8");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_8_0_0(), "rule__Move__Alternatives_8_0_0");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_8_1_0(), "rule__Move__Alternatives_8_1_0");
			builder.put(grammarAccess.getMoveAccess().getAlternatives_11(), "rule__Move__Alternatives_11");
			builder.put(grammarAccess.getSimpleActionAccess().getAlternatives_3(), "rule__SimpleAction__Alternatives_3");
			builder.put(grammarAccess.getSimpleActionAccess().getAlternatives_7(), "rule__SimpleAction__Alternatives_7");
			builder.put(grammarAccess.getSourceReferenceAccess().getAlternatives_1(), "rule__SourceReference__Alternatives_1");
			builder.put(grammarAccess.getDependencyTargetAccess().getAlternatives(), "rule__DependencyTarget__Alternatives");
			builder.put(grammarAccess.getTargetReferenceAccess().getAlternatives_1(), "rule__TargetReference__Alternatives_1");
			builder.put(grammarAccess.getIIDAccess().getAlternatives(), "rule__IID__Alternatives");
			builder.put(grammarAccess.getEStringAccess().getAlternatives(), "rule__EString__Alternatives");
			builder.put(grammarAccess.getSchedulingAccess().getAlternatives(), "rule__Scheduling__Alternatives");
			builder.put(grammarAccess.getActivitySetAccess().getGroup(), "rule__ActivitySet__Group__0");
			builder.put(grammarAccess.getImportAccess().getGroup(), "rule__Import__Group__0");
			builder.put(grammarAccess.getActivityAccess().getGroup(), "rule__Activity__Group__0");
			builder.put(grammarAccess.getActivityAccess().getGroup_3(), "rule__Activity__Group_3__0");
			builder.put(grammarAccess.getResourceQualifiedNameAccess().getGroup(), "rule__ResourceQualifiedName__Group__0");
			builder.put(grammarAccess.getResourceQualifiedNameAccess().getGroup_1(), "rule__ResourceQualifiedName__Group_1__0");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getGroup(), "rule__LocationPrerequisite__Group__0");
			builder.put(grammarAccess.getClaimAccess().getGroup(), "rule__Claim__Group__0");
			builder.put(grammarAccess.getClaimAccess().getGroup_3_1(), "rule__Claim__Group_3_1__0");
			builder.put(grammarAccess.getClaimAccess().getGroup_7_1(), "rule__Claim__Group_7_1__0");
			builder.put(grammarAccess.getReleaseAccess().getGroup(), "rule__Release__Group__0");
			builder.put(grammarAccess.getReleaseAccess().getGroup_3_1(), "rule__Release__Group_3_1__0");
			builder.put(grammarAccess.getReleaseAccess().getGroup_6_1(), "rule__Release__Group_6_1__0");
			builder.put(grammarAccess.getRaiseEventAccess().getGroup(), "rule__RaiseEvent__Group__0");
			builder.put(grammarAccess.getRequireEventAccess().getGroup(), "rule__RequireEvent__Group__0");
			builder.put(grammarAccess.getMoveAccess().getGroup(), "rule__Move__Group__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_3_1(), "rule__Move__Group_3_1__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_8_0(), "rule__Move__Group_8_0__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_8_1(), "rule__Move__Group_8_1__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_9(), "rule__Move__Group_9__0");
			builder.put(grammarAccess.getMoveAccess().getGroup_11_1(), "rule__Move__Group_11_1__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup(), "rule__SimpleAction__Group__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_3_1(), "rule__SimpleAction__Group_3_1__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_5(), "rule__SimpleAction__Group_5__0");
			builder.put(grammarAccess.getSimpleActionAccess().getGroup_7_1(), "rule__SimpleAction__Group_7_1__0");
			builder.put(grammarAccess.getTracePointAccess().getGroup(), "rule__TracePoint__Group__0");
			builder.put(grammarAccess.getEdgeAccess().getGroup(), "rule__Edge__Group__0");
			builder.put(grammarAccess.getSourceReferenceAccess().getGroup(), "rule__SourceReference__Group__0");
			builder.put(grammarAccess.getSourceReferenceAccess().getGroup_1_1(), "rule__SourceReference__Group_1_1__0");
			builder.put(grammarAccess.getTargetReferenceAccess().getGroup(), "rule__TargetReference__Group__0");
			builder.put(grammarAccess.getTargetReferenceAccess().getGroup_1_1(), "rule__TargetReference__Group_1_1__0");
			builder.put(grammarAccess.getNodeQualifiedNameAccess().getGroup(), "rule__NodeQualifiedName__Group__0");
			builder.put(grammarAccess.getNodeQualifiedNameAccess().getGroup_1(), "rule__NodeQualifiedName__Group_1__0");
			builder.put(grammarAccess.getActivitySetAccess().getImportsAssignment_1(), "rule__ActivitySet__ImportsAssignment_1");
			builder.put(grammarAccess.getActivitySetAccess().getActivitiesAssignment_2(), "rule__ActivitySet__ActivitiesAssignment_2");
			builder.put(grammarAccess.getImportAccess().getImportURIAssignment_1(), "rule__Import__ImportURIAssignment_1");
			builder.put(grammarAccess.getActivityAccess().getNameAssignment_1(), "rule__Activity__NameAssignment_1");
			builder.put(grammarAccess.getActivityAccess().getPrerequisitesAssignment_3_2(), "rule__Activity__PrerequisitesAssignment_3_2");
			builder.put(grammarAccess.getActivityAccess().getNodesAssignment_6(), "rule__Activity__NodesAssignment_6");
			builder.put(grammarAccess.getActivityAccess().getEdgesAssignment_10(), "rule__Activity__EdgesAssignment_10");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getResourceAssignment_0(), "rule__LocationPrerequisite__ResourceAssignment_0");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getPeripheralAssignment_2(), "rule__LocationPrerequisite__PeripheralAssignment_2");
			builder.put(grammarAccess.getLocationPrerequisiteAccess().getPositionAssignment_4(), "rule__LocationPrerequisite__PositionAssignment_4");
			builder.put(grammarAccess.getClaimAccess().getNameAssignment_1(), "rule__Claim__NameAssignment_1");
			builder.put(grammarAccess.getClaimAccess().getEntryAssignment_3_0(), "rule__Claim__EntryAssignment_3_0");
			builder.put(grammarAccess.getClaimAccess().getOuterEntryAssignment_3_1_0(), "rule__Claim__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getClaimAccess().getEntryAssignment_3_1_1(), "rule__Claim__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getClaimAccess().getPassiveAssignment_4(), "rule__Claim__PassiveAssignment_4");
			builder.put(grammarAccess.getClaimAccess().getResourceAssignment_6(), "rule__Claim__ResourceAssignment_6");
			builder.put(grammarAccess.getClaimAccess().getExitAssignment_7_0(), "rule__Claim__ExitAssignment_7_0");
			builder.put(grammarAccess.getClaimAccess().getExitAssignment_7_1_0(), "rule__Claim__ExitAssignment_7_1_0");
			builder.put(grammarAccess.getClaimAccess().getOuterExitAssignment_7_1_1(), "rule__Claim__OuterExitAssignment_7_1_1");
			builder.put(grammarAccess.getReleaseAccess().getNameAssignment_1(), "rule__Release__NameAssignment_1");
			builder.put(grammarAccess.getReleaseAccess().getEntryAssignment_3_0(), "rule__Release__EntryAssignment_3_0");
			builder.put(grammarAccess.getReleaseAccess().getOuterEntryAssignment_3_1_0(), "rule__Release__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getReleaseAccess().getEntryAssignment_3_1_1(), "rule__Release__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getReleaseAccess().getResourceAssignment_5(), "rule__Release__ResourceAssignment_5");
			builder.put(grammarAccess.getReleaseAccess().getExitAssignment_6_0(), "rule__Release__ExitAssignment_6_0");
			builder.put(grammarAccess.getReleaseAccess().getExitAssignment_6_1_0(), "rule__Release__ExitAssignment_6_1_0");
			builder.put(grammarAccess.getReleaseAccess().getOuterExitAssignment_6_1_1(), "rule__Release__OuterExitAssignment_6_1_1");
			builder.put(grammarAccess.getRaiseEventAccess().getNameAssignment_1(), "rule__RaiseEvent__NameAssignment_1");
			builder.put(grammarAccess.getRaiseEventAccess().getEventNameAssignment_4(), "rule__RaiseEvent__EventNameAssignment_4");
			builder.put(grammarAccess.getRequireEventAccess().getNameAssignment_1(), "rule__RequireEvent__NameAssignment_1");
			builder.put(grammarAccess.getRequireEventAccess().getEventNameAssignment_4(), "rule__RequireEvent__EventNameAssignment_4");
			builder.put(grammarAccess.getMoveAccess().getNameAssignment_1(), "rule__Move__NameAssignment_1");
			builder.put(grammarAccess.getMoveAccess().getEntryAssignment_3_0(), "rule__Move__EntryAssignment_3_0");
			builder.put(grammarAccess.getMoveAccess().getOuterEntryAssignment_3_1_0(), "rule__Move__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getMoveAccess().getEntryAssignment_3_1_1(), "rule__Move__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getMoveAccess().getResourceAssignment_5(), "rule__Move__ResourceAssignment_5");
			builder.put(grammarAccess.getMoveAccess().getPeripheralAssignment_7(), "rule__Move__PeripheralAssignment_7");
			builder.put(grammarAccess.getMoveAccess().getPassingAssignment_8_0_0_0(), "rule__Move__PassingAssignment_8_0_0_0");
			builder.put(grammarAccess.getMoveAccess().getTargetPositionAssignment_8_0_1(), "rule__Move__TargetPositionAssignment_8_0_1");
			builder.put(grammarAccess.getMoveAccess().getContinuingAssignment_8_1_0_0(), "rule__Move__ContinuingAssignment_8_1_0_0");
			builder.put(grammarAccess.getMoveAccess().getDistanceAssignment_8_1_1(), "rule__Move__DistanceAssignment_8_1_1");
			builder.put(grammarAccess.getMoveAccess().getProfileAssignment_9_1(), "rule__Move__ProfileAssignment_9_1");
			builder.put(grammarAccess.getMoveAccess().getSchedulingTypeAssignment_10(), "rule__Move__SchedulingTypeAssignment_10");
			builder.put(grammarAccess.getMoveAccess().getExitAssignment_11_0(), "rule__Move__ExitAssignment_11_0");
			builder.put(grammarAccess.getMoveAccess().getExitAssignment_11_1_0(), "rule__Move__ExitAssignment_11_1_0");
			builder.put(grammarAccess.getMoveAccess().getOuterExitAssignment_11_1_1(), "rule__Move__OuterExitAssignment_11_1_1");
			builder.put(grammarAccess.getSimpleActionAccess().getNameAssignment_1(), "rule__SimpleAction__NameAssignment_1");
			builder.put(grammarAccess.getSimpleActionAccess().getEntryAssignment_3_0(), "rule__SimpleAction__EntryAssignment_3_0");
			builder.put(grammarAccess.getSimpleActionAccess().getOuterEntryAssignment_3_1_0(), "rule__SimpleAction__OuterEntryAssignment_3_1_0");
			builder.put(grammarAccess.getSimpleActionAccess().getEntryAssignment_3_1_1(), "rule__SimpleAction__EntryAssignment_3_1_1");
			builder.put(grammarAccess.getSimpleActionAccess().getResourceAssignment_4(), "rule__SimpleAction__ResourceAssignment_4");
			builder.put(grammarAccess.getSimpleActionAccess().getPeripheralAssignment_5_1(), "rule__SimpleAction__PeripheralAssignment_5_1");
			builder.put(grammarAccess.getSimpleActionAccess().getTypeAssignment_5_3(), "rule__SimpleAction__TypeAssignment_5_3");
			builder.put(grammarAccess.getSimpleActionAccess().getSchedulingTypeAssignment_6(), "rule__SimpleAction__SchedulingTypeAssignment_6");
			builder.put(grammarAccess.getSimpleActionAccess().getExitAssignment_7_0(), "rule__SimpleAction__ExitAssignment_7_0");
			builder.put(grammarAccess.getSimpleActionAccess().getExitAssignment_7_1_0(), "rule__SimpleAction__ExitAssignment_7_1_0");
			builder.put(grammarAccess.getSimpleActionAccess().getOuterExitAssignment_7_1_1(), "rule__SimpleAction__OuterExitAssignment_7_1_1");
			builder.put(grammarAccess.getTracePointAccess().getRegexAssignment_1(), "rule__TracePoint__RegexAssignment_1");
			builder.put(grammarAccess.getTracePointAccess().getValueAssignment_2(), "rule__TracePoint__ValueAssignment_2");
			builder.put(grammarAccess.getEdgeAccess().getSourceAssignment_1(), "rule__Edge__SourceAssignment_1");
			builder.put(grammarAccess.getEdgeAccess().getTargetAssignment_3(), "rule__Edge__TargetAssignment_3");
			builder.put(grammarAccess.getSourceReferenceAccess().getNodeAssignment_1_0(), "rule__SourceReference__NodeAssignment_1_0");
			builder.put(grammarAccess.getSourceReferenceAccess().getNodeAssignment_1_1_1(), "rule__SourceReference__NodeAssignment_1_1_1");
			builder.put(grammarAccess.getTargetReferenceAccess().getNodeAssignment_1_0(), "rule__TargetReference__NodeAssignment_1_0");
			builder.put(grammarAccess.getTargetReferenceAccess().getNodeAssignment_1_1_1(), "rule__TargetReference__NodeAssignment_1_1_1");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private ActivityGrammarAccess grammarAccess;

	@Override
	protected InternalActivityParser createParser() {
		InternalActivityParser result = new InternalActivityParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public ActivityGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(ActivityGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
	
	public NameMappings getNameMappings() {
		return nameMappings;
	}
	
	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
