/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler.simulator.main;

import activity.Move;
import activity.PeripheralAction;
import activity.SimpleAction;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import lsat_graph.PeripheralActionTask;
import machine.Axis;
import machine.HasResourcePeripheral;
import machine.IResource;
import machine.Machine;
import machine.Peripheral;
import machine.Position;
import org.eclipse.emf.common.util.EList;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.schedule.Schedule;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.common.xtend.Queries;
import org.eclipse.lsat.scheduler.simulator.common.Common;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class GenerateScheduleTemplate {
    public static CharSequence generateScheduleHtml(Machine machine) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("<!DOCTYPE html>");
        _builder.newLine();
        _builder.append("<html>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<head>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<meta charset=\"UTF-8\">");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<title>");
        String _type = machine.getType();
        _builder.append(_type, "    ");
        _builder.append("</title>");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<!-- Designed against Paper.js v0.12.15, which can be downloaded from: http://paperjs.org/download/ -->");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script type=\"text/javascript\" src=\"http://paperjs.org/assets/js/paper.js\"></script>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script type=\"text/javascript\">");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("paper.install(window);");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</script>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script src=\"settings.js\" type=\"text/javascript\"></script>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script src=\"machine.js\" \"text/javascript\"></script>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script src=\"schedule.js\" type=\"text/javascript\"></script>");
        _builder.newLine();
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<script>");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("window.onload = function() {");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("paper.setup('mcanvas');");
        _builder.newLine();
        Functions.Function1 _function = it -> Common.getItemsOrResource((IResource)it);
        Functions.Function1 _function_1 = it -> it.fqn();
        List _sortBy = IterableExtensions.sortBy((Iterable)Queries.xcollect((Iterable)machine.getResources(), (Functions.Function1)_function), (Functions.Function1)_function_1);
        for (IResource resource : _sortBy) {
            Functions.Function1 _function_2 = it -> it.getName();
            List _sortBy_1 = IterableExtensions.sortBy((Iterable)resource.getResource().getPeripherals(), (Functions.Function1)_function_2);
            for (Peripheral peripheral : _sortBy_1) {
                boolean _not;
                _builder.append("        ");
                String _iD = Common.getID(resource, peripheral);
                _builder.append(_iD, "        ");
                _builder.append(".init(");
                boolean _isEmpty = peripheral.getPositions().isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append("/*TODO: position*/");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append("        ");
        _builder.append("var message;");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("var count = 0; // The total number frames");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("view.onFrame = function(event) {");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("count++;");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("// Default frame rate approximately 60fps, reducing it to 20fps");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("if (count % 3 !== 0) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("return;");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("          ");
        _builder.append("if (typeof schedule == 'function') {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("schedule(event.time);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("if (typeof setAnimationTime == 'function') {");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("setAnimationTime(event.time);");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("} else if (message == undefined) {");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("message = new PointText({");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("point : new Point(10, 50),");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("content : 'Please generate a schedule to start the animation',");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("fillColor : 'Black',");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("strokeColor: 'White',");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("strokeWidth: 1,");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("fontFamily : 'Courier New',");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("fontWeight : 'bold',");
        _builder.newLine();
        _builder.append("              ");
        _builder.append("fontSize : 25");
        _builder.newLine();
        _builder.append("            ");
        _builder.append("});");
        _builder.newLine();
        _builder.append("          ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("        ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("      ");
        _builder.append("}");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("</script>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("</head>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("<body>");
        _builder.newLine();
        _builder.append("    ");
        _builder.append("<canvas id=\"mcanvas\" width=\"800\" height=\"600\" hidpi=\"off\" keepalive=\"true\" style=\"background:white\"></canvas>");
        _builder.newLine();
        _builder.append("  ");
        _builder.append("</body>");
        _builder.newLine();
        _builder.append("</html>");
        _builder.newLine();
        return _builder;
    }

    public static <T extends Task> String generateScheduleJavaScript(Schedule<T> schedule) {
        Functions.Function1 _function = it -> it.getScheduledTasks();
        Functions.Function1 _function_1 = it -> {
            Task _task = it.getTask();
            return _task instanceof PeripheralActionTask;
        };
        Functions.Function1 _function_2 = it -> it;
        List paTasks = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Queries.select((Iterable)IterableExtensions.flatMap((Iterable)schedule.getSequences(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1 _function_3 = it -> (PeripheralAction)((PeripheralActionTask)it.getTask()).getAction();
        Functions.Function1 _function_4 = it -> it.isPositionMove();
        Functions.Function1 _function_5 = it -> {
            IResource _resource = it.getResource();
            Peripheral _peripheral = it.getPeripheral();
            return Pair.of((Object)_resource, (Object)_peripheral);
        };
        Iterable distancePeripherals = Queries.unique((Iterable)IterableExtensions.map((Iterable)IterableExtensions.reject((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)paTasks, (Functions.Function1)_function_3), Move.class), (Functions.Function1)_function_4), (Functions.Function1)_function_5));
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("// Auto generated, do not modify!");
        _builder.newLine();
        _builder.append("function schedule(time) {");
        _builder.newLine();
        boolean _hasElements = false;
        for (Pair rp : distancePeripherals) {
            if (!_hasElements) {
                _hasElements = true;
            }
            _builder.append("  ");
            _builder.append("var ");
            String _positionID = Common.getPositionID((IResource)rp.getKey(), (Peripheral)rp.getValue(), "_CURRENT_POSITION");
            _builder.append(_positionID);
            _builder.append(" = {");
            EList _axes = ((Peripheral)rp.getValue()).getType().getAxes();
            boolean _hasElements_1 = false;
            for (Axis axis : _axes) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = axis.getName();
                _builder.append(_name);
                _builder.append(":");
                String _positionID_1 = Common.getPositionID((IResource)rp.getKey(), (Peripheral)rp.getValue(), "_INITIAL_POSITION");
                _builder.append(_positionID_1);
                _builder.append("_");
                String _name_1 = axis.getName();
                _builder.append(_name_1);
            }
            _builder.append("};");
            _builder.newLineIfNotEmpty();
        }
        if (_hasElements) {
            String _lineSeparator = System.lineSeparator();
            _builder.append(_lineSeparator);
        }
        for (ScheduledTask task : paTasks) {
            _builder.append("  ");
            CharSequence _generateTask = GenerateScheduleTemplate.generateTask((ScheduledTask<PeripheralActionTask>)task);
            _builder.append((Object)_generateTask);
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return _builder.toString();
    }

    private static CharSequence generateTask(ScheduledTask<PeripheralActionTask> scheduledTask) {
        return GenerateScheduleTemplate.generateTask(scheduledTask, (PeripheralAction)((PeripheralActionTask)scheduledTask.getTask()).getAction());
    }

    private static CharSequence _generateTask(ScheduledTask<PeripheralActionTask> task, SimpleAction action) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = action.getType().getName();
        _builder.append(_name);
        _builder.append("(");
        String _iD = Common.getID((HasResourcePeripheral)action);
        _builder.append(_iD);
        _builder.append(", ");
        BigDecimal _roundToOneDecimal = GenerateScheduleTemplate.roundToOneDecimal(task.getStartTime());
        _builder.append((Object)_roundToOneDecimal);
        _builder.append(", ");
        BigDecimal _roundToOneDecimal_1 = GenerateScheduleTemplate.roundToOneDecimal(task.getEndTime());
        _builder.append((Object)_roundToOneDecimal_1);
        _builder.append(", time);");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private static CharSequence _generateTask(ScheduledTask<PeripheralActionTask> task, Move move) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPositionMove = move.isPositionMove();
        if (_isPositionMove) {
            _builder.append("move(");
            String _iD = Common.getID((HasResourcePeripheral)move);
            _builder.append(_iD);
            _builder.append(", ");
            String _positionID = Common.getPositionID((HasResourcePeripheral)move, (Position)move.getSourcePosition());
            _builder.append(_positionID);
            _builder.append(", ");
            String _positionID_1 = Common.getPositionID((HasResourcePeripheral)move, (Position)move.getTargetPosition());
            _builder.append(_positionID_1);
            _builder.append(", ");
            BigDecimal _roundToOneDecimal = GenerateScheduleTemplate.roundToOneDecimal(task.getStartTime());
            _builder.append((Object)_roundToOneDecimal);
            _builder.append(", ");
            BigDecimal _roundToOneDecimal_1 = GenerateScheduleTemplate.roundToOneDecimal(task.getEndTime());
            _builder.append((Object)_roundToOneDecimal_1);
            _builder.append(", time);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("move(");
            String _iD_1 = Common.getID((HasResourcePeripheral)move);
            _builder.append(_iD_1);
            _builder.append(", clone(");
            String _positionID_2 = Common.getPositionID((HasResourcePeripheral)move, "_CURRENT_POSITION");
            _builder.append(_positionID_2);
            _builder.append("), plusIs(");
            String _positionID_3 = Common.getPositionID((HasResourcePeripheral)move, "_CURRENT_POSITION");
            _builder.append(_positionID_3);
            _builder.append(", ");
            String _distanceID = Common.getDistanceID((HasResourcePeripheral)move, move.getDistance());
            _builder.append(_distanceID);
            _builder.append("), ");
            BigDecimal _roundToOneDecimal_2 = GenerateScheduleTemplate.roundToOneDecimal(task.getStartTime());
            _builder.append((Object)_roundToOneDecimal_2);
            _builder.append(", ");
            BigDecimal _roundToOneDecimal_3 = GenerateScheduleTemplate.roundToOneDecimal(task.getEndTime());
            _builder.append((Object)_roundToOneDecimal_3);
            _builder.append(", time);");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private static BigDecimal roundToOneDecimal(BigDecimal input) {
        return input.setScale(1, RoundingMode.HALF_UP);
    }

    private static CharSequence generateTask(ScheduledTask<PeripheralActionTask> task, PeripheralAction move) {
        if (move instanceof Move) {
            return GenerateScheduleTemplate._generateTask(task, (Move)move);
        }
        if (move instanceof SimpleAction) {
            return GenerateScheduleTemplate._generateTask(task, (SimpleAction)move);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task, move).toString());
    }
}

