/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.timing.util;

import activity.Activity;
import activity.Move;
import expressions.Expression;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.script.ScriptException;
import machine.Axis;
import machine.Distance;
import machine.HasResourcePeripheral;
import machine.IResource;
import machine.PathTargetReference;
import machine.Peripheral;
import machine.PeripheralType;
import machine.Position;
import machine.Profile;
import machine.Resource;
import machine.ResourceItem;
import machine.SetPoint;
import machine.SymbolicPosition;
import machine.impl.MachineQueries;
import machine.util.ResourcePeripheralKey;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.activity.teditor.validation.ActivityValidator;
import org.eclipse.lsat.common.graph.directed.editable.Node;
import org.eclipse.lsat.common.queries.QueryableIterable;
import org.eclipse.lsat.motioncalculator.MotionProfile;
import org.eclipse.lsat.motioncalculator.MotionProfileParameter;
import org.eclipse.lsat.motioncalculator.MotionSegment;
import org.eclipse.lsat.motioncalculator.MotionSetPoint;
import org.eclipse.lsat.motioncalculator.MotionValidationException;
import org.eclipse.lsat.timing.Activator;
import org.eclipse.lsat.timing.calculator.MotionCalculatorExtension;
import org.eclipse.lsat.timing.util.AxesDistance;
import org.eclipse.lsat.timing.util.AxesLocation;
import org.eclipse.lsat.timing.util.MoveHelper;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtext.EcoreUtil2;
import setting.MotionProfileSettings;
import setting.MotionSettings;
import setting.PhysicalLocation;
import setting.PhysicalSettings;
import setting.Settings;

public class MotionCalculatorHelper {
    private final Settings settings;
    private final MotionCalculatorExtension motionCalculator;

    public MotionCalculatorHelper(Settings settings, MotionCalculatorExtension motionCalculator) {
        this.settings = settings;
        this.motionCalculator = motionCalculator;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public MotionCalculatorExtension getMotionCalculator() {
        return this.motionCalculator;
    }

    public List<Move> getConcatenatedMove(Move self) {
        LinkedList<Move> fullMove = new LinkedList<Move>();
        Move predecessorMove = self;
        do {
            fullMove.offerFirst(predecessorMove);
        } while ((predecessorMove = predecessorMove.getPredecessorMove()) != null && !predecessorMove.isStopAtTarget());
        while (!((Move)fullMove.getLast()).isStopAtTarget()) {
            fullMove.offerLast(fullMove.getLast().getSuccessorMove());
        }
        return fullMove;
    }

    public void validate(List<Move> concatenatedMove) throws SpecificationException {
        this.validate(concatenatedMove, (Collection<Axis>)concatenatedMove.get(0).getPeripheral().getType().getAxes());
    }

    public List<MotionSegment> createMotionSegments(List<Move> concatenatedMove) throws SpecificationException {
        return concatenatedMove.isEmpty() ? Collections.emptyList() : this.createMotionSegments(concatenatedMove, (Collection<Axis>)concatenatedMove.get(0).getPeripheral().getType().getAxes());
    }

    public void validate(List<Move> concatenatedMove, Collection<Axis> axes) throws SpecificationException {
        ArrayList<MotionSegment> segments = new ArrayList<MotionSegment>(concatenatedMove.size());
        for (Move move : concatenatedMove) {
            if (!this.canValidate((HasResourcePeripheral)move)) {
                return;
            }
            if (move.isPositionMove()) {
                segments.add(this.createPositionMotionSegment(move, axes));
                continue;
            }
            segments.add(this.createDistanceMotionSegment(move, axes));
        }
        try {
            this.motionCalculator.validate(segments);
        }
        catch (MotionValidationException e) {
            Move[] moves = (Move[])e.getSegments().stream().map(s -> (Move)concatenatedMove.get(segments.indexOf(s))).toArray(Move[]::new);
            throw new SpecificationException(e.getMessage(), (Throwable)e, (EObject[])moves);
        }
    }

    public List<MotionSegment> createMotionSegments(List<Move> concatenatedMove, Collection<Axis> axes) throws SpecificationException {
        ArrayList<MotionSegment> segments = new ArrayList<MotionSegment>(concatenatedMove.size());
        for (Move move : concatenatedMove) {
            if (move.isPositionMove()) {
                segments.add(this.createPositionMotionSegment(move, axes));
                continue;
            }
            segments.add(this.createDistanceMotionSegment(move, axes));
        }
        try {
            this.motionCalculator.validate(segments);
        }
        catch (MotionValidationException e) {
            Move[] moves = (Move[])e.getSegments().stream().map(s -> (Move)concatenatedMove.get(segments.indexOf(s))).toArray(Move[]::new);
            Activity act = (Activity)EcoreUtil2.getContainerOfType((EObject)((EObject)concatenatedMove.get(0)), Activity.class);
            String prefix = Stream.of(moves).map(Node::getName).collect(Collectors.joining("->", "", " in activity " + act.getName() + ":\n\n"));
            throw new SpecificationException(String.valueOf(prefix) + e.getMessage(), (Throwable)e, (EObject[])moves);
        }
        return segments;
    }

    private MotionSegment createDistanceMotionSegment(Move move, Collection<Axis> axes) throws SpecificationException {
        Peripheral peripheral = move.getPeripheral();
        PeripheralType peripheralType = peripheral.getType();
        Distance distance = move.getDistance();
        Profile profile = move.getProfile();
        if (distance == null) {
            throw new SpecificationException(String.format("Don't know how to move peripheral %s using speed profile %s, because the distance is not set.", peripheral.fqn(), profile.getName()), new EObject[]{move});
        }
        AxesDistance axesDistance = this.getAxesDistance(move.getResource(), distance);
        Map<SetPoint, BigDecimal> setPoints = MotionCalculatorHelper.toSetPoint(peripheralType, axesDistance);
        MotionSegment result = new MotionSegment(ActivityValidator.id((Node)move));
        for (SetPoint setPoint : QueryableIterable.from(axes).collect(Axis::getSetPoints).asOrderedSet()) {
            LinkedHashSet<Axis> motionAxes = new LinkedHashSet<Axis>((Collection<Axis>)setPoint.getAxes());
            if (motionAxes.isEmpty()) {
                throw new SpecificationException(String.format("Setpoint %s should refer to at least one axis for peripheral type %s", setPoint.getName(), peripheral.getType().getName()), new EObject[]{move, setPoint});
            }
            if (!axes.containsAll(motionAxes)) {
                throw new IllegalArgumentException("Argument 'axes' should contain all axes for setpoint");
            }
            LinkedHashSet<Axis> settlingAxes = new LinkedHashSet<Axis>((Collection<Axis>)distance.getSettling());
            settlingAxes.retainAll(motionAxes);
            MotionSetPoint motionSetPoint = new MotionSetPoint(setPoint.getName());
            motionSetPoint.setDistance(setPoints.get(setPoint));
            motionSetPoint.setSettling(!settlingAxes.isEmpty());
            Set<Axis> movingAxes = axesDistance.getMovingAxes();
            this.setProfileArguments(motionSetPoint, move, motionAxes, settlingAxes, movingAxes);
            result.addMotionSetpoint(motionSetPoint);
        }
        return result;
    }

    private MotionSegment createPositionMotionSegment(Move move, Collection<Axis> axes) throws SpecificationException {
        Peripheral peripheral = move.getPeripheral();
        PeripheralType peripheralType = peripheral.getType();
        SymbolicPosition source = move.getSourcePosition();
        SymbolicPosition target = move.getTargetPosition();
        Profile profile = move.getProfile();
        if (source == null) {
            throw new SpecificationException(String.format("Don't know how to move peripheral %s to %s using speed profile %s, because the source position is not set.", peripheral.fqn(), target.getName(), profile.getName()), new EObject[]{move});
        }
        PathTargetReference targetReference = MachineQueries.findPath((SymbolicPosition)source, (SymbolicPosition)target, (Profile)profile);
        if (targetReference == null) {
            throw new SpecificationException(String.format("Don't know how to move peripheral %s from %s to %s using speed profile %s", peripheral.fqn(), source.getName(), target.getName(), profile.getName()), new EObject[]{move});
        }
        AxesLocation sourceAxesLocation = this.getAxesLocation(move.getResource(), source);
        Map<SetPoint, BigDecimal> sourceSetPointsLocation = MotionCalculatorHelper.toSetPoint(peripheralType, sourceAxesLocation);
        AxesLocation targetAxesLocation = this.getAxesLocation(move.getResource(), target);
        Map<SetPoint, BigDecimal> targetSetPointsLocation = MotionCalculatorHelper.toSetPoint(peripheralType, targetAxesLocation);
        MotionSegment result = new MotionSegment(ActivityValidator.id((Node)move));
        for (SetPoint setPoint : QueryableIterable.from(axes).collect(Axis::getSetPoints).asOrderedSet()) {
            LinkedHashSet<Axis> motionAxes = new LinkedHashSet<Axis>((Collection<Axis>)setPoint.getAxes());
            if (motionAxes.isEmpty()) {
                throw new SpecificationException(String.format("Setpoint %s should refer to at least one axis for peripheral type %s", setPoint.getName(), peripheral.getType().getName()), new EObject[]{move, setPoint});
            }
            if (!axes.containsAll(motionAxes)) {
                throw new IllegalArgumentException("Argument 'axes' should contain all axes for setpoint");
            }
            LinkedHashSet<Axis> settlingAxes = new LinkedHashSet<Axis>((Collection<Axis>)targetReference.getSettling());
            settlingAxes.retainAll(motionAxes);
            MotionSetPoint motionSetPoint = new MotionSetPoint(setPoint.getName());
            motionSetPoint.setFrom(sourceSetPointsLocation.get(setPoint));
            motionSetPoint.setTo(targetSetPointsLocation.get(setPoint));
            motionSetPoint.setDistance(motionSetPoint.getTo().subtract(motionSetPoint.getFrom()));
            motionSetPoint.setSettling(!settlingAxes.isEmpty());
            Set<Axis> movingAxes = sourceAxesLocation.getMovingAxes(targetAxesLocation);
            this.setProfileArguments(motionSetPoint, move, motionAxes, settlingAxes, movingAxes);
            result.addMotionSetpoint(motionSetPoint);
        }
        return result;
    }

    private void setProfileArguments(MotionSetPoint motionSetPoint, Move move, Set<Axis> motionAxes, Set<Axis> settlingAxes, Set<Axis> movingAxes) throws SpecificationException {
        Peripheral peripheral = move.getPeripheral();
        Profile profile = move.getProfile();
        if (motionAxes.size() > 1) {
            movingAxes.retainAll(motionAxes);
            if (movingAxes.isEmpty()) {
                if (settlingAxes.isEmpty()) {
                    this.retainHead(motionAxes);
                } else {
                    motionAxes.retainAll(settlingAxes);
                }
            } else {
                motionAxes.retainAll(movingAxes);
            }
        }
        Iterator<Axis> motionAxesIterator = motionAxes.iterator();
        Axis motionAxis = motionAxesIterator.next();
        MotionProfileSettings motionProfileSettings = this.getMotionProfileSettings(move, profile, motionAxis);
        while (motionAxesIterator.hasNext()) {
            MotionProfileSettings otherMmotionProfileSettings = this.getMotionProfileSettings(move, profile, motionAxesIterator.next());
            if (this.deepEquals(motionProfileSettings, otherMmotionProfileSettings)) continue;
            throw new SpecificationException(String.format("Multiple axes adjust the same setpoints with different settings when peripheral %s moves for %s.", peripheral.fqn(), MoveHelper.getName(move)), new EObject[]{move, motionProfileSettings, otherMmotionProfileSettings});
        }
        MotionProfile motionProfile = this.motionCalculator.getMotionProfile(motionProfileSettings.getMotionProfile());
        if (motionProfile == null) {
            throw new SpecificationException(String.format("Selected motion calculator %s does not support motion profile %s", this.motionCalculator.getName(), motionProfileSettings.getMotionProfile()), new EObject[]{move});
        }
        motionSetPoint.setMotionProfile(motionProfile);
        for (MotionProfileParameter parameter : motionProfile.getParameters()) {
            Expression expression = (Expression)motionProfileSettings.getMotionArguments().get((Object)parameter.getKey());
            if (expression == null) continue;
            BigDecimal argument = expression.evaluate();
            if (argument != null) {
                motionSetPoint.setMotionProfileArgument(parameter.getKey(), argument);
                continue;
            }
            if (!parameter.isRequired()) continue;
            throw new SpecificationException(String.format("Required motion profile argument %s is not set for profile %s on axes %s of peripheral %s", parameter.getKey(), profile.getName(), motionAxis.getName(), peripheral.fqn()), new EObject[]{move, motionProfileSettings});
        }
    }

    private MotionProfileSettings getMotionProfileSettings(Move move, Profile profile, Axis motionAxis) throws SpecificationException {
        EMap profileSettings = this.getMotionSettings((HasResourcePeripheral)move, motionAxis).getProfileSettings();
        MotionProfileSettings motionProfileSettings = (MotionProfileSettings)profileSettings.get((Object)profile);
        if (motionProfileSettings == null) {
            profileSettings.entrySet().stream().filter(e -> e.getKey() == profile).map(e -> (MotionProfileSettings)e.getValue()).findFirst().orElse(null);
        }
        return motionProfileSettings;
    }

    private static Map<SetPoint, BigDecimal> toSetPoint(PeripheralType peripheralType, Map<Axis, BigDecimal> axesSettings) throws SpecificationException {
        return peripheralType.getConversion() == null ? MotionCalculatorHelper.toSetPointDirect(peripheralType, axesSettings) : MotionCalculatorHelper.toSetPointUsingScript(peripheralType, axesSettings);
    }

    private static Map<SetPoint, BigDecimal> toSetPointDirect(PeripheralType peripheralType, Map<Axis, BigDecimal> axesSettings) throws SpecificationException {
        HashMap<SetPoint, BigDecimal> conversion = new HashMap<SetPoint, BigDecimal>(peripheralType.getSetPoints().size());
        for (Map.Entry<Axis, BigDecimal> entry : axesSettings.entrySet()) {
            for (SetPoint setPoint : entry.getKey().getSetPoints()) {
                if (!Objects.equals(entry.getKey().getUnit(), setPoint.getUnit())) {
                    throw new SpecificationException(String.format("Don't know how to convert %s axis unit [%s] to %s setpoint unit [%s], please specifiy a conversion in peripheral type %s", entry.getKey().getName(), entry.getKey().getUnit(), setPoint.getName(), setPoint.getUnit(), peripheralType.getName()), new EObject[0]);
                }
                if (conversion.put(setPoint, entry.getValue()) == null) continue;
                String axesNames = QueryableIterable.from((Iterable)setPoint.getAxes()).collectOne(Axis::getName).joinfields((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
                throw new SpecificationException(String.format("Multiple axes %s adjust setpoint %s, please specifiy a conversion in peripheral type %s", axesNames, setPoint.getName(), peripheralType.getName()), new EObject[0]);
            }
        }
        return conversion;
    }

    private static Map<SetPoint, BigDecimal> toSetPointUsingScript(PeripheralType peripheralType, Map<Axis, BigDecimal> args) throws SpecificationException {
        Map scriptArgs = QueryableIterable.from(args).toMap(e -> ((Axis)e.getKey()).getName(), Map.Entry::getValue);
        try {
            Activator.getDefault().evalJavaScript(peripheralType.getConversion(), scriptArgs);
            return QueryableIterable.from((Iterable)peripheralType.getSetPoints()).toMap(sp -> sp, sp -> MotionCalculatorHelper.toBigDecimal(scriptArgs.get(sp.getName())));
        }
        catch (ScriptException e2) {
            throw new SpecificationException(e2.getMessage(), (Throwable)e2, new EObject[]{peripheralType});
        }
    }

    private static BigDecimal toBigDecimal(Object object) throws IllegalArgumentException {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Number) {
            return new BigDecimal(((Number)object).doubleValue());
        }
        throw new IllegalArgumentException("Cannot convert value to BigDecimal: " + object);
    }

    public AxesLocation getAxesLocation(IResource resource, SymbolicPosition position) throws SpecificationException {
        AxesLocation axesLocation = new AxesLocation(position);
        for (Axis axis : AxesLocation.safeGetAxes(position)) {
            MotionSettings ms = this.getMotionSettings(resource, position.getPeripheral(), axis);
            Position axisPosition = position.getPosition(axis);
            PhysicalLocation axisLocation = (PhysicalLocation)ms.getLocationSettings().get((Object)axisPosition);
            if (axisLocation == null) {
                throw new SpecificationException(String.format("Axis location not specified for position %s of axis %s in peripheral %s", axisPosition.getName(), axis.getName(), position.getPeripheral().fqn()), new EObject[]{ms});
            }
            axesLocation.put(axis, axisLocation.getDefault());
        }
        return axesLocation;
    }

    public AxesDistance getAxesDistance(IResource resource, Distance distance) throws SpecificationException {
        AxesDistance axesDistance = new AxesDistance(distance);
        for (Axis axis : AxesDistance.safeGetAxes(distance)) {
            MotionSettings ms = this.getMotionSettings(resource, distance.getPeripheral(), axis);
            BigDecimal value = BigDecimal.ZERO;
            Expression expression = (Expression)ms.getDistanceSettings().get((Object)distance);
            if (expression == null) {
                throw new SpecificationException(String.format("Axis distance not specified for distance %s of axis %s in peripheral %s", distance.getName(), axis.getName(), distance.getPeripheral().fqn()), new EObject[]{ms});
            }
            value = expression.evaluate();
            axesDistance.put(axis, value);
        }
        return axesDistance;
    }

    private boolean canValidate(HasResourcePeripheral rp) {
        if (rp.getResource() instanceof ResourceItem) {
            return true;
        }
        Resource resource = rp.getResource().getResource();
        if (resource.getItems().isEmpty()) {
            return true;
        }
        return this.settings.getPhysicalSettings((IResource)resource, rp.getPeripheral()) != null;
    }

    private MotionSettings getMotionSettings(HasResourcePeripheral rp, Axis axis) throws SpecificationException {
        return this.getMotionSettings(rp.getResource(), rp.getPeripheral(), axis);
    }

    private MotionSettings getMotionSettings(IResource resource, Peripheral peripheral, Axis axis) throws SpecificationException {
        ResourcePeripheralKey rp = new ResourcePeripheralKey(resource, peripheral);
        PhysicalSettings ps = this.settings.getPhysicalSettings(resource, peripheral);
        if (ps == null) {
            throw new SpecificationException(String.format("Physical settings not specified for peripheral %s", rp.fqn()), new EObject[]{this.settings});
        }
        MotionSettings ms = (MotionSettings)ps.getMotionSettings().get((Object)axis);
        if (ms == null) {
            throw new SpecificationException(String.format("Motion settings not specified for axis %s in peripheral %s", axis.getName(), rp.fqn()), new EObject[]{ps});
        }
        return ms;
    }

    private void retainHead(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    private boolean deepEquals(MotionProfileSettings s1, MotionProfileSettings s2) {
        if (!Objects.equals(s1.getMotionProfile(), s2.getMotionProfile())) {
            return false;
        }
        if (!s1.getMotionArguments().keySet().equals(s2.getMotionArguments().keySet())) {
            return false;
        }
        for (Map.Entry entry : s1.getMotionArguments().entrySet()) {
            if (((Expression)entry.getValue()).evaluate().compareTo(((Expression)s2.getMotionArguments().get(entry.getKey())).evaluate()) == 0) continue;
            return false;
        }
        return true;
    }
}

