/*
 * Decompiled with CFR 0.152.
 */
package activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SchedulingType implements Enumerator
{
    ASAP(0, "ASAP", "As Soon As Possible (ASAP)"),
    ALAP(1, "ALAP", "As Late As Possible (ALAP)");

    public static final int ASAP_VALUE = 0;
    public static final int ALAP_VALUE = 1;
    private static final SchedulingType[] VALUES_ARRAY;
    public static final List<SchedulingType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SchedulingType[]{ASAP, ALAP};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SchedulingType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SchedulingType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SchedulingType get(int value) {
        switch (value) {
            case 0: {
                return ASAP;
            }
            case 1: {
                return ALAP;
            }
        }
        return null;
    }

    private SchedulingType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

