/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.common.ludus.backend.games.energy.solvers;

import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.lsat.common.ludus.backend.games.energy.EnergyGame;
import org.eclipse.lsat.common.ludus.backend.games.energy.solvers.SEPM;

public class ValueIterationInt {
    public static final Integer TOP = Integer.MAX_VALUE;

    private ValueIterationInt() {
    }

    private static <V, E> Predicate<V> allSuccessorsNegative(EnergyGame<V, E, Integer> game) {
        return v -> game.outgoingEdgesOf(v).stream().allMatch(e -> (Integer)game.getWeight(e) < 0);
    }

    private static <V, E> Predicate<V> anySuccessorNegative(EnergyGame<V, E, Integer> game) {
        return v -> game.outgoingEdgesOf(v).stream().anyMatch(e -> (Integer)game.getWeight(e) < 0);
    }

    private static <V, E> Predicate<E> isConsistentSuccessor(EnergyGame<V, E, Integer> game, SEPM<V, Integer> sepm) {
        return e -> (Integer)sepm.getValue(game.getEdgeSource(e)) >= ValueIterationInt.minus((Integer)game.getSumNegWeights(), (Integer)sepm.getValue(game.getEdgeTarget(e)), (Integer)game.getWeight(game.getEdge(game.getEdgeSource(e), game.getEdgeTarget(e))));
    }

    private static Integer minus(Integer sumNegativeWeights, Integer a, Integer b) {
        if (a < TOP && a - b <= sumNegativeWeights) {
            return Math.max(0, a - b);
        }
        return TOP;
    }

    private static <V, E> Integer lift(EnergyGame<V, E, Integer> game, SEPM<V, Integer> sepm, V vertex) {
        Integer newValue = game.getV0().contains(vertex) ? Integer.valueOf(game.outgoingEdgesOf(vertex).stream().mapToInt(e -> ValueIterationInt.minus((Integer)game.getSumNegWeights(), (Integer)sepm.getValue(game.getEdgeTarget(e)), (Integer)game.getWeight(e))).reduce(Integer.MAX_VALUE, Integer::min)) : Integer.valueOf(game.outgoingEdgesOf(vertex).stream().mapToInt(e -> ValueIterationInt.minus((Integer)game.getSumNegWeights(), (Integer)sepm.getValue(game.getEdgeTarget(e)), (Integer)game.getWeight(e))).reduce(Integer.MIN_VALUE, Integer::max));
        return newValue;
    }

    public static <V, E> SEPM<V, Integer> getProgressMeasure(EnergyGame<V, E, Integer> game) {
        assert (game != null);
        HashMap count = new HashMap();
        ArrayDeque l = new ArrayDeque();
        SEPM sepm = new SEPM();
        l.addAll(game.getV0().stream().filter(ValueIterationInt.allSuccessorsNegative(game)).collect(Collectors.toSet()));
        l.addAll(game.getV1().stream().filter(ValueIterationInt.anySuccessorNegative(game)).collect(Collectors.toSet()));
        game.getVertices().stream().forEach(v -> sepm.setValue(v, 0));
        game.getV0().stream().forEach(v -> {
            if (l.contains(v)) {
                count.put(v, 0);
            } else {
                int numberOfConsistentVertices = (int)game.outgoingEdgesOf(v).stream().filter(ValueIterationInt.isConsistentSuccessor(game, sepm)).count();
                count.put(v, numberOfConsistentVertices);
            }
        });
        while (!l.isEmpty()) {
            Object v2 = l.pop();
            Integer old = (Integer)sepm.getValue(v2);
            sepm.setValue(v2, ValueIterationInt.lift(game, sepm, v2));
            if (game.getV0().contains(v2)) {
                int numberOfConsistentVertices = (int)game.outgoingEdgesOf(v2).stream().filter(ValueIterationInt.isConsistentSuccessor(game, sepm)).count();
                count.put(v2, numberOfConsistentVertices);
            }
            game.incomingEdgesOf(v2).stream().forEach(e -> {
                Object vPre = game.getEdgeSource(e);
                if ((Integer)sepm.getValue(vPre) < ValueIterationInt.minus((Integer)game.getSumNegWeights(), (Integer)sepm.getValue(v2), (Integer)game.getWeight(e))) {
                    if (game.getV0().contains(vPre)) {
                        if ((Integer)sepm.getValue(vPre) >= ValueIterationInt.minus((Integer)game.getSumNegWeights(), old, (Integer)game.getWeight(e))) {
                            count.put(vPre, (Integer)count.get(vPre) - 1);
                        }
                        if ((Integer)count.get(vPre) <= 0 && !l.contains(vPre)) {
                            l.add(vPre);
                        }
                    } else if (!l.contains(vPre)) {
                        l.add(vPre);
                    }
                }
            });
        }
        return sepm;
    }

    public static <V, E> Optional<E> getConsistentSuccessor(EnergyGame<V, E, Integer> game, SEPM<V, Integer> sepm, V v) {
        return game.outgoingEdgesOf(v).stream().filter(ValueIterationInt.isConsistentSuccessor(game, sepm)).findFirst();
    }

    public static <V, E> Optional<E> getLargestConsistentSuccessor(EnergyGame<V, E, Integer> game, SEPM<V, Integer> sepm, V v) {
        return game.outgoingEdgesOf(v).stream().filter(ValueIterationInt.isConsistentSuccessor(game, sepm)).max(Comparator.comparingInt(e -> (Integer)sepm.getValue(game.getEdgeTarget(e))));
    }

    public static <V, E> Optional<E> getSmallestConsistentSuccessor(EnergyGame<V, E, Integer> game, SEPM<V, Integer> sepm, V v) {
        return game.outgoingEdgesOf(v).stream().filter(ValueIterationInt.isConsistentSuccessor(game, sepm)).min(Comparator.comparingInt(e -> (Integer)sepm.getValue(game.getEdgeTarget(e))));
    }
}

