/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler.product;

import activity.ActivityFactory;
import activity.Move;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.schedule.ScheduledTask;
import org.eclipse.lsat.product.productdata.LocationInformation;
import org.eclipse.lsat.product.productdata.ProductProperty;
import org.eclipse.lsat.scheduler.product.ProductOwner;
import org.eclipse.lsat.scheduler.product.ProductUtil;
import product.IProductDefinition;
import product.Property;
import product.TransferType;

public class ProductChange {
    private static final String PRODUCT = "product";
    private final ScheduledTask<Task> scheduledTask;
    private final activity.ProductChange activityProductChange;
    private final ProductOwner productOwner;
    private final TransferType transferType;
    private final org.eclipse.lsat.product.productdata.Task taskData;
    private final String slot;

    public String toString() {
        return "ProductChange [ scheduledTask=" + this.scheduledTask.getName() + ", activity=" + this.scheduledTask.getTask().getGraph().getName() + ", (slot=" + this.slot + ", productOwner=" + String.valueOf(this.productOwner) + ", transferType=" + String.valueOf(this.getTransferType()) + "]";
    }

    public ProductChange(ScheduledTask<Task> scheduledTask, org.eclipse.lsat.product.productdata.Task taskData, activity.ProductChange activityProductChange) {
        this.scheduledTask = scheduledTask;
        this.taskData = taskData;
        if (activityProductChange == null) {
            activityProductChange = ActivityFactory.eINSTANCE.createProductChange();
            ProductUtil.getAction(scheduledTask).getProductChanges().add((Object)activityProductChange);
        }
        this.activityProductChange = activityProductChange;
        this.transferType = activityProductChange.getTransferType();
        this.slot = activityProductChange.getSlot();
        this.productOwner = new ProductOwner(ProductUtil.getAction(scheduledTask));
    }

    public void initProduct(String productId) {
        this.setStatus(productId, null);
    }

    public void setStatus(String suppliedProductId, ProductChange predecessor) {
        IProductDefinition product;
        if (suppliedProductId == null && predecessor == null) {
            return;
        }
        String productId = suppliedProductId == null ? "?" : suppliedProductId;
        EMap map = this.scheduledTask.getProperties();
        if (predecessor != null) {
            for (Map.Entry e : predecessor.scheduledTask.getProperties().entrySet()) {
                map.put((Object)((String)e.getKey()), (Object)((String)e.getValue()));
            }
        }
        if ((product = this.activityProductChange.getProduct()) != null) {
            ProductChange.putConditional((EMap<String, String>)map, productId, "name", this.getStartTime(), (Serializable)((Object)product.getName()));
        }
        if (this.transferType == TransferType.EXIT) {
            ProductChange.putConditional((EMap<String, String>)map, productId, "exit", this.getStartTime(), (Serializable)((Object)"true"));
        }
        ProductChange.putConditional((EMap<String, String>)map, productId, "id", this.getStartTime(), (Serializable)((Object)productId));
        ProductChange.putConditional((EMap<String, String>)map, productId, "slot", this.getStartTime(), (Serializable)((Object)this.getSlot()));
        for (Property p : this.activityProductChange.getStartProperties()) {
            ProductChange.putConditional((EMap<String, String>)map, productId, p.getDefinition().getName(), this.getStartTime(), p.getValue().getValueAsSerializable());
        }
        for (Property p : this.activityProductChange.getEndProperties()) {
            ProductChange.putConditional((EMap<String, String>)map, productId, p.getDefinition().getName(), this.getEndTime(), p.getValue().getValueAsSerializable());
        }
    }

    public String getSlot() {
        return this.slot;
    }

    public boolean isTransfer() {
        return this.getTransferType() == TransferType.IN || this.getTransferType() == TransferType.OUT;
    }

    public boolean isEntry() {
        return this.getTransferType() == TransferType.ENTRY;
    }

    public boolean isExit() {
        return this.getTransferType() == TransferType.EXIT;
    }

    public boolean isMove() {
        return ProductUtil.getAction(this.scheduledTask) instanceof Move;
    }

    public ProductOwner getProductOwner() {
        return this.productOwner;
    }

    public List<Property> getStartProperties() {
        return this.activityProductChange.getStartProperties();
    }

    public List<Property> getEndProperties() {
        return this.activityProductChange.getEndProperties();
    }

    public BigDecimal getStartTime() {
        return this.scheduledTask.getStartTime();
    }

    public BigDecimal getEndTime() {
        return this.scheduledTask.getEndTime();
    }

    public TransferType getTransferType() {
        return this.transferType;
    }

    public org.eclipse.lsat.product.productdata.Task getTaskData() {
        return this.taskData;
    }

    public boolean isMatch(ProductChange target) {
        if (!target.isTransfer() || this.getTransferType().equals((Object)target.getTransferType())) {
            return false;
        }
        if (this.getProductOwner().equals(target.getProductOwner())) {
            return false;
        }
        if (!Objects.equals(this.getSlot(), target.getSlot())) {
            return false;
        }
        return ProductUtil.isSuccessor(this.scheduledTask.getTask(), target.scheduledTask.getTask());
    }

    public List<ProductProperty> getChangedProperties() {
        return Stream.concat(this.getStartProperties().stream().map(prop -> new ProductProperty(this.taskData, ProductProperty.WHEN.start, prop.getDefinition().getName(), (Object)prop.getValue().getValueAsSerializable())), this.getEndProperties().stream().map(prop -> new ProductProperty(this.taskData, ProductProperty.WHEN.end, prop.getDefinition().getName(), (Object)prop.getValue().getValueAsSerializable()))).toList();
    }

    public LocationInformation createLocationInformation() {
        String slot = this.getSlot();
        return new LocationInformation(this.taskData, slot);
    }

    private static void putConditional(EMap<String, String> map, String productId, String key, BigDecimal since, Serializable value) {
        String fullKey = "product/" + productId + "/" + key;
        ProductChange.putConditional(map, fullKey, since, value);
    }

    private static void putConditional(EMap<String, String> map, String fullKey, BigDecimal since, Serializable value) {
        if (value != null && !value.toString().isBlank()) {
            String precedingValue;
            String preceding = (String)map.get((Object)fullKey);
            Object pValue = value.toString() + " (since: " + String.valueOf(since) + ")";
            if (preceding != null && (precedingValue = preceding.toString().replaceFirst("(.*) \\(since: .*\\)", "$1")).equals(value)) {
                pValue = preceding.toString();
            }
            map.put((Object)fullKey, pValue);
        }
    }
}

