/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import activity.Claim;
import activity.EventAction;
import activity.Release;
import activity.RequireEvent;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import lsat_graph.ClaimTask;
import lsat_graph.EventAnnotation;
import lsat_graph.ReleaseTask;
import lsat_graph.lsat_graphFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Edge;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.common.scheduler.graph.TaskDependencyGraph;
import org.eclipse.lsat.motioncalculator.MotionException;
import org.eclipse.lsat.timing.util.SpecificationException;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotateClaimRelease<T extends Task, E extends Edge> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotateClaimRelease.class);
    private final TaskDependencyGraph<T> root;

    private AnnotateClaimRelease(TaskDependencyGraph<T> graph) {
        boolean _tripleEquals;
        this.root = graph;
        Resource _eResource = graph.eResource();
        boolean bl = _tripleEquals = _eResource == null;
        if (_tripleEquals) {
            EList _contents = AnnotateClaimRelease.createResourceSet().createResource(URI.createURI((String)"graph")).getContents();
            _contents.add(graph);
        }
    }

    public static <T extends Task> TaskDependencyGraph<T> transformModel(TaskDependencyGraph<T> graph) {
        try {
            LOGGER.debug("Starting transformation");
            AnnotateClaimRelease scr = new AnnotateClaimRelease(graph);
            scr.processGraph((DirectedGraph)scr.root);
            LOGGER.debug("Finished transformation");
            return graph;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private <T extends Task, E extends Edge> void processGraph(DirectedGraph<T, E> graph) throws SpecificationException, MotionException {
        Consumer<DirectedGraph> _function = it -> {
            try {
                this.processGraph((DirectedGraph<T, E>)it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        ((List)Conversions.doWrapArray((Object)((DirectedGraph[])Conversions.unwrapArray((Object)graph.getSubGraphs(), DirectedGraph.class)).clone())).forEach(_function);
        Consumer<Task> _function_1 = it -> {
            try {
                this.annotate((Node)it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        ((List)Conversions.doWrapArray((Object)((Task[])Conversions.unwrapArray((Object)graph.getNodes(), Task.class)).clone())).forEach(_function_1);
    }

    private void _annotate(Node node) {
    }

    private void _annotate(ClaimTask task) throws SpecificationException, MotionException {
        Functions.Function1 _function = it -> it.getTargetNode();
        Functions.Function1 _function_1 = it -> true;
        EventAction event = (EventAction)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)((Claim)task.getAction()).getOutgoingEdges(), (Functions.Function1)_function), EventAction.class), (Functions.Function1)_function_1);
        if (event != null) {
            EList _aspects = task.getAspects();
            EventAnnotation<T> _queryCreateEventAnnotation = AnnotateClaimRelease.queryCreateEventAnnotation(this.root, event.getResource().fqn(), event instanceof RequireEvent);
            _aspects.add(_queryCreateEventAnnotation);
        }
    }

    private void _annotate(ReleaseTask task) throws SpecificationException, MotionException {
        Functions.Function1 _function = it -> it.getSourceNode();
        Functions.Function1 _function_1 = it -> true;
        EventAction event = (EventAction)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)ListExtensions.map((List)((Release)task.getAction()).getIncomingEdges(), (Functions.Function1)_function), EventAction.class), (Functions.Function1)_function_1);
        if (event != null) {
            EList _aspects = task.getAspects();
            EventAnnotation<T> _queryCreateEventAnnotation = AnnotateClaimRelease.queryCreateEventAnnotation(this.root, event.getResource().fqn(), event instanceof RequireEvent);
            _aspects.add(_queryCreateEventAnnotation);
        }
    }

    public static <T extends Task> EventAnnotation<T> queryCreateEventAnnotation(TaskDependencyGraph<T> graph, String eventName, boolean require) {
        Functions.Function1 _function;
        Functions.Function1 _final_function = _function = a -> a;
        Functions.Function1 _function_1 = it -> {
            boolean _isRequireEvent = it.isRequireEvent();
            return _isRequireEvent == require;
        };
        Functions.Function1 _function_2 = it -> {
            String _name = it.getName();
            return Objects.equals(_name, eventName);
        };
        EventAnnotation result = (EventAnnotation)IterableExtensions.findFirst((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)graph.getAspects(), EventAnnotation.class), (Functions.Function1)_final_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        if (result == null) {
            result = lsat_graphFactory.eINSTANCE.createEventAnnotation();
            result.setName(eventName);
            result.setRequireEvent(require);
            EList _aspects = graph.getAspects();
            _aspects.add((Object)result);
            EList _contents = graph.eResource().getResourceSet().createResource(URI.createURI((String)("events/" + eventName + "/" + String.valueOf((Object)require)))).getContents();
            _contents.add((Object)result);
        }
        return result;
    }

    public static ResourceSet createResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        HashMap _hashMap = new HashMap();
        resourceSet.setURIResourceMap(_hashMap);
        return resourceSet;
    }

    @XbaseGenerated
    private void annotate(Node task) throws SpecificationException, MotionException {
        if (task instanceof ClaimTask) {
            this._annotate((ClaimTask)task);
            return;
        }
        if (task instanceof ReleaseTask) {
            this._annotate((ReleaseTask)task);
            return;
        }
        if (task != null) {
            this._annotate(task);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task).toString());
    }
}

